/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.jspecify.annotations.Nullable;

public class DoorBlock
extends Block {
    public static final MapCodec<DoorBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(DoorBlock::type), DoorBlock.propertiesCodec()).apply((Applicative)instance, DoorBlock::new));
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.DOOR_HINGE;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateHorizontal(Block.boxZ(16.0, 13.0, 16.0));
    private final BlockSetType type;

    public MapCodec<? extends DoorBlock> codec() {
        return CODEC;
    }

    protected DoorBlock(BlockSetType blocksettype, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info.sound(blocksettype.soundType()));
        this.type = blocksettype;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(OPEN, false)).setValue(HINGE, DoorHingeSide.LEFT)).setValue(POWERED, false)).setValue(HALF, DoubleBlockHalf.LOWER));
    }

    public BlockSetType type() {
        return this.type;
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        Direction enumdirection = iblockdata.getValue(FACING);
        Direction enumdirection1 = iblockdata.getValue(OPEN).booleanValue() ? (iblockdata.getValue(HINGE) == DoorHingeSide.RIGHT ? enumdirection.getCounterClockWise() : enumdirection.getClockWise()) : enumdirection;
        return SHAPES.get(enumdirection1);
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        DoubleBlockHalf blockpropertydoubleblockhalf = iblockdata.getValue(HALF);
        return enumdirection.getAxis() == Direction.Axis.Y && blockpropertydoubleblockhalf == DoubleBlockHalf.LOWER == (enumdirection == Direction.UP) ? (iblockdata1.getBlock() instanceof DoorBlock && iblockdata1.getValue(HALF) != blockpropertydoubleblockhalf ? (BlockState)iblockdata1.setValue(HALF, blockpropertydoubleblockhalf) : Blocks.AIR.defaultBlockState()) : (blockpropertydoubleblockhalf == DoubleBlockHalf.LOWER && enumdirection == Direction.DOWN && !iblockdata.canSurvive(iworldreader, blockposition) ? Blocks.AIR.defaultBlockState() : super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource));
    }

    @Override
    protected void onExplosionHit(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPos> biconsumer) {
        if (explosion.canTriggerBlocks() && iblockdata.getValue(HALF) == DoubleBlockHalf.LOWER && this.type.canOpenByWindCharge() && !iblockdata.getValue(POWERED).booleanValue()) {
            this.setOpen(null, worldserver, iblockdata, blockposition, !this.isOpen(iblockdata));
        }
        super.onExplosionHit(iblockdata, worldserver, blockposition, explosion, biconsumer);
    }

    @Override
    public BlockState playerWillDestroy(Level world, BlockPos blockposition, BlockState iblockdata, Player entityhuman) {
        if (!(world.isClientSide() || !entityhuman.preventsBlockDrops() && entityhuman.hasCorrectToolForDrops(iblockdata))) {
            DoublePlantBlock.preventDropFromBottomPart(world, blockposition, iblockdata, entityhuman);
        }
        return super.playerWillDestroy(world, blockposition, iblockdata, entityhuman);
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        return switch (pathmode) {
            case PathComputationType.LAND, PathComputationType.AIR -> iblockdata.getValue(OPEN);
            case PathComputationType.WATER -> false;
            default -> throw new MatchException(null, null);
        };
    }

    @Override
    public @Nullable BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        BlockPos blockposition = blockactioncontext.getClickedPos();
        Level world = blockactioncontext.getLevel();
        if (blockposition.getY() < world.getMaxY() && world.getBlockState(blockposition.above()).canBeReplaced(blockactioncontext)) {
            boolean flag = world.hasNeighborSignal(blockposition) || world.hasNeighborSignal(blockposition.above());
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, blockactioncontext.getHorizontalDirection())).setValue(HINGE, this.getHinge(blockactioncontext))).setValue(POWERED, flag)).setValue(OPEN, flag)).setValue(HALF, DoubleBlockHalf.LOWER);
        }
        return null;
    }

    @Override
    public void setPlacedBy(Level world, BlockPos blockposition, BlockState iblockdata, @Nullable LivingEntity entityliving, ItemStack itemstack) {
        world.setBlock(blockposition.above(), (BlockState)iblockdata.setValue(HALF, DoubleBlockHalf.UPPER), 3);
    }

    private DoorHingeSide getHinge(BlockPlaceContext blockactioncontext) {
        boolean flag1;
        Level iblockaccess = blockactioncontext.getLevel();
        BlockPos blockposition = blockactioncontext.getClickedPos();
        Direction enumdirection = blockactioncontext.getHorizontalDirection();
        BlockPos blockposition1 = blockposition.above();
        Direction enumdirection1 = enumdirection.getCounterClockWise();
        BlockPos blockposition2 = blockposition.relative(enumdirection1);
        BlockState iblockdata = iblockaccess.getBlockState(blockposition2);
        BlockPos blockposition3 = blockposition1.relative(enumdirection1);
        BlockState iblockdata1 = iblockaccess.getBlockState(blockposition3);
        Direction enumdirection2 = enumdirection.getClockWise();
        BlockPos blockposition4 = blockposition.relative(enumdirection2);
        BlockState iblockdata2 = iblockaccess.getBlockState(blockposition4);
        BlockPos blockposition5 = blockposition1.relative(enumdirection2);
        BlockState iblockdata3 = iblockaccess.getBlockState(blockposition5);
        int i = (iblockdata.isCollisionShapeFullBlock(iblockaccess, blockposition2) ? -1 : 0) + (iblockdata1.isCollisionShapeFullBlock(iblockaccess, blockposition3) ? -1 : 0) + (iblockdata2.isCollisionShapeFullBlock(iblockaccess, blockposition4) ? 1 : 0) + (iblockdata3.isCollisionShapeFullBlock(iblockaccess, blockposition5) ? 1 : 0);
        boolean flag = iblockdata.getBlock() instanceof DoorBlock && iblockdata.getValue(HALF) == DoubleBlockHalf.LOWER;
        boolean bl = flag1 = iblockdata2.getBlock() instanceof DoorBlock && iblockdata2.getValue(HALF) == DoubleBlockHalf.LOWER;
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = enumdirection.getStepX();
                int k = enumdirection.getStepZ();
                Vec3 vec3d = blockactioncontext.getClickLocation();
                double d0 = vec3d.x - (double)blockposition.getX();
                double d1 = vec3d.z - (double)blockposition.getZ();
                return !(j < 0 && !(d1 >= 0.5) || j > 0 && !(d1 <= 0.5) || k < 0 && !(d0 <= 0.5) || k > 0 && !(d0 >= 0.5)) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        if (!this.type.canOpenByHand()) {
            return InteractionResult.PASS;
        }
        iblockdata = (BlockState)iblockdata.cycle(OPEN);
        world.setBlock(blockposition, iblockdata, 10);
        this.playSound(entityhuman, world, blockposition, iblockdata.getValue(OPEN));
        world.gameEvent((Entity)entityhuman, this.isOpen(iblockdata) ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, blockposition);
        return InteractionResult.SUCCESS;
    }

    public boolean isOpen(BlockState iblockdata) {
        return iblockdata.getValue(OPEN);
    }

    public void setOpen(@Nullable Entity entity, Level world, BlockState iblockdata, BlockPos blockposition, boolean flag) {
        if (iblockdata.is(this) && iblockdata.getValue(OPEN) != flag) {
            world.setBlock(blockposition, (BlockState)iblockdata.setValue(OPEN, flag), 10);
            this.playSound(entity, world, blockposition, flag);
            world.gameEvent(entity, flag ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, blockposition);
        }
    }

    @Override
    protected void neighborChanged(BlockState iblockdata, Level world, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        int oldPower;
        BlockPos otherHalf = blockposition.relative(iblockdata.getValue(HALF) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN);
        CraftWorld bworld = world.getWorld();
        org.bukkit.block.Block bukkitBlock = bworld.getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
        org.bukkit.block.Block blockTop = bworld.getBlockAt(otherHalf.getX(), otherHalf.getY(), otherHalf.getZ());
        int power = bukkitBlock.getBlockPower();
        int powerTop = blockTop.getBlockPower();
        if (powerTop > power) {
            power = powerTop;
        }
        if ((oldPower = iblockdata.getValue(POWERED) != false ? 15 : 0) == 0 ^ power == 0) {
            boolean flag1;
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(bukkitBlock, oldPower, power);
            world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
            boolean bl = flag1 = eventRedstone.getNewCurrent() > 0;
            if (flag1 != iblockdata.getValue(OPEN)) {
                this.playSound(null, world, blockposition, flag1);
                world.gameEvent((Entity)null, flag1 ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, blockposition);
            }
            world.setBlock(blockposition, (BlockState)((BlockState)iblockdata.setValue(POWERED, flag1)).setValue(OPEN, flag1), 2);
        }
    }

    @Override
    protected boolean canSurvive(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        BlockPos blockposition1 = blockposition.below();
        BlockState iblockdata1 = iworldreader.getBlockState(blockposition1);
        return iblockdata.getValue(HALF) == DoubleBlockHalf.LOWER ? iblockdata1.isFaceSturdy(iworldreader, blockposition1, Direction.UP) : iblockdata1.is(this);
    }

    private void playSound(@Nullable Entity entity, Level world, BlockPos blockposition, boolean flag) {
        world.playSound(entity, blockposition, flag ? this.type.doorOpen() : this.type.doorClose(), SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.1f + 0.9f);
    }

    @Override
    protected BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        return (BlockState)iblockdata.setValue(FACING, enumblockrotation.rotate(iblockdata.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState iblockdata, Mirror enumblockmirror) {
        return enumblockmirror == Mirror.NONE ? iblockdata : (BlockState)iblockdata.rotate(enumblockmirror.getRotation(iblockdata.getValue(FACING))).cycle(HINGE);
    }

    @Override
    protected long getSeed(BlockState iblockdata, BlockPos blockposition) {
        return Mth.getSeed(blockposition.getX(), blockposition.below(iblockdata.getValue(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).getY(), blockposition.getZ());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(HALF, FACING, OPEN, HINGE, POWERED);
    }

    public static boolean isWoodenDoor(Level world, BlockPos blockposition) {
        return DoorBlock.isWoodenDoor(world.getBlockState(blockposition));
    }

    public static boolean isWoodenDoor(BlockState iblockdata) {
        DoorBlock blockdoor;
        Block block = iblockdata.getBlock();
        if (block instanceof DoorBlock && (blockdoor = (DoorBlock)block).type().canOpenByHand()) {
            boolean flag = true;
            return flag;
        }
        boolean flag = false;
        return flag;
    }
}

