/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;

public class EndRodBlock
extends RodBlock {
    public static final MapCodec<EndRodBlock> CODEC = EndRodBlock.simpleCodec(EndRodBlock::new);

    public MapCodec<EndRodBlock> codec() {
        return CODEC;
    }

    protected EndRodBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.UP));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        Direction var1 = var0.getClickedFace();
        BlockState var2 = var0.getLevel().getBlockState(var0.getClickedPos().relative(var1.getOpposite()));
        if (var2.is(this) && var2.getValue(FACING) == var1) {
            return (BlockState)this.defaultBlockState().setValue(FACING, var1.getOpposite());
        }
        return (BlockState)this.defaultBlockState().setValue(FACING, var1);
    }

    @Override
    public void animateTick(BlockState var0, Level var1, BlockPos var2, RandomSource var3) {
        Direction var4 = (Direction)var0.getValue(FACING);
        double var5 = (double)var2.getX() + 0.55 - (double)(var3.nextFloat() * 0.1f);
        double var7 = (double)var2.getY() + 0.55 - (double)(var3.nextFloat() * 0.1f);
        double var9 = (double)var2.getZ() + 0.55 - (double)(var3.nextFloat() * 0.1f);
        double var11 = 0.4f - (var3.nextFloat() + var3.nextFloat()) * 0.4f;
        if (var3.nextInt(5) == 0) {
            var1.addParticle(ParticleTypes.END_ROD, var5 + (double)var4.getStepX() * var11, var7 + (double)var4.getStepY() * var11, var9 + (double)var4.getStepZ() * var11, var3.nextGaussian() * 0.005, var3.nextGaussian() * 0.005, var3.nextGaussian() * 0.005);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(FACING);
    }
}

