/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FenceBlock
extends CrossCollisionBlock {
    public static final MapCodec<FenceBlock> CODEC = FenceBlock.simpleCodec(FenceBlock::new);
    private final Function<BlockState, VoxelShape> occlusionShapes;

    public MapCodec<FenceBlock> codec() {
        return CODEC;
    }

    public FenceBlock(BlockBehaviour.Properties var0) {
        super(4.0f, 16.0f, 4.0f, 16.0f, 24.0f, var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false)).setValue(WATERLOGGED, false));
        this.occlusionShapes = this.makeShapes(4.0f, 16.0f, 2.0f, 6.0f, 15.0f);
    }

    @Override
    protected VoxelShape getOcclusionShape(BlockState var0) {
        return this.occlusionShapes.apply(var0);
    }

    @Override
    protected VoxelShape getVisualShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return this.getShape(var0, var1, var2, var3);
    }

    @Override
    protected boolean isPathfindable(BlockState var0, PathComputationType var1) {
        return false;
    }

    public boolean connectsTo(BlockState var0, boolean var1, Direction var2) {
        Block var3 = var0.getBlock();
        boolean var4 = this.isSameFence(var0);
        boolean var5 = var3 instanceof FenceGateBlock && FenceGateBlock.connectsToDirection(var0, var2);
        return !FenceBlock.isExceptionForConnection(var0) && var1 || var4 || var5;
    }

    private boolean isSameFence(BlockState var0) {
        return var0.is(BlockTags.FENCES) && var0.is(BlockTags.WOODEN_FENCES) == this.defaultBlockState().is(BlockTags.WOODEN_FENCES);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState var0, Level var1, BlockPos var2, Player var3, BlockHitResult var4) {
        return !var1.isClientSide() ? LeadItem.bindPlayerMobs(var3, var1, var2) : InteractionResult.PASS;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        Level var1 = var0.getLevel();
        BlockPos var2 = var0.getClickedPos();
        FluidState var3 = var0.getLevel().getFluidState(var0.getClickedPos());
        BlockPos var4 = var2.north();
        BlockPos var5 = var2.east();
        BlockPos var6 = var2.south();
        BlockPos var7 = var2.west();
        BlockState var8 = var1.getBlockState(var4);
        BlockState var9 = var1.getBlockState(var5);
        BlockState var10 = var1.getBlockState(var6);
        BlockState var11 = var1.getBlockState(var7);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.getStateForPlacement(var0).setValue(NORTH, this.connectsTo(var8, var8.isFaceSturdy(var1, var4, Direction.SOUTH), Direction.SOUTH))).setValue(EAST, this.connectsTo(var9, var9.isFaceSturdy(var1, var5, Direction.WEST), Direction.WEST))).setValue(SOUTH, this.connectsTo(var10, var10.isFaceSturdy(var1, var6, Direction.NORTH), Direction.NORTH))).setValue(WEST, this.connectsTo(var11, var11.isFaceSturdy(var1, var7, Direction.EAST), Direction.EAST))).setValue(WATERLOGGED, var3.getType() == Fluids.WATER);
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, Fluids.WATER, Fluids.WATER.getTickDelay(var1));
        }
        if (var4.getAxis().isHorizontal()) {
            return (BlockState)var0.setValue((Property)PROPERTY_BY_DIRECTION.get(var4), this.connectsTo(var6, var6.isFaceSturdy(var1, var5, var4.getOpposite()), var4.getOpposite()));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(NORTH, EAST, WEST, SOUTH, WATERLOGGED);
    }
}

