/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.jspecify.annotations.Nullable;

public class FenceGateBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<FenceGateBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WoodType.CODEC.fieldOf("wood_type").forGetter(blockfencegate -> blockfencegate.type), FenceGateBlock.propertiesCodec()).apply((Applicative)instance, FenceGateBlock::new));
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty IN_WALL = BlockStateProperties.IN_WALL;
    private static final Map<Direction.Axis, VoxelShape> SHAPES = Shapes.rotateHorizontalAxis(Block.cube(16.0, 16.0, 4.0));
    private static final Map<Direction.Axis, VoxelShape> SHAPES_WALL = Maps.newEnumMap(Util.mapValues(SHAPES, voxelshape -> Shapes.join(voxelshape, Block.column(16.0, 13.0, 16.0), BooleanOp.ONLY_FIRST)));
    private static final Map<Direction.Axis, VoxelShape> SHAPE_COLLISION = Shapes.rotateHorizontalAxis(Block.column(16.0, 4.0, 0.0, 24.0));
    private static final Map<Direction.Axis, VoxelShape> SHAPE_SUPPORT = Shapes.rotateHorizontalAxis(Block.column(16.0, 4.0, 5.0, 24.0));
    private static final Map<Direction.Axis, VoxelShape> SHAPE_OCCLUSION = Shapes.rotateHorizontalAxis(Shapes.or(Block.box(0.0, 5.0, 7.0, 2.0, 16.0, 9.0), Block.box(14.0, 5.0, 7.0, 16.0, 16.0, 9.0)));
    private static final Map<Direction.Axis, VoxelShape> SHAPE_OCCLUSION_WALL = Maps.newEnumMap(Util.mapValues(SHAPE_OCCLUSION, voxelshape -> voxelshape.move(0.0, -0.1875, 0.0).optimize()));
    private final WoodType type;

    public MapCodec<FenceGateBlock> codec() {
        return CODEC;
    }

    public FenceGateBlock(WoodType blockpropertywood, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info.sound(blockpropertywood.soundType()));
        this.type = blockpropertywood;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(OPEN, false)).setValue(POWERED, false)).setValue(IN_WALL, false));
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        Direction.Axis enumdirection_enumaxis = ((Direction)iblockdata.getValue(FACING)).getAxis();
        return (iblockdata.getValue(IN_WALL) != false ? SHAPES_WALL : SHAPES).get(enumdirection_enumaxis);
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        Direction.Axis enumdirection_enumaxis = enumdirection.getAxis();
        if (((Direction)iblockdata.getValue(FACING)).getClockWise().getAxis() != enumdirection_enumaxis) {
            return super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
        }
        boolean flag = this.isWall(iblockdata1) || this.isWall(iworldreader.getBlockState(blockposition.relative(enumdirection.getOpposite())));
        return (BlockState)iblockdata.setValue(IN_WALL, flag);
    }

    @Override
    protected VoxelShape getBlockSupportShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition) {
        Direction.Axis enumdirection_enumaxis = ((Direction)iblockdata.getValue(FACING)).getAxis();
        return iblockdata.getValue(OPEN) != false ? Shapes.empty() : SHAPE_SUPPORT.get(enumdirection_enumaxis);
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        Direction.Axis enumdirection_enumaxis = ((Direction)iblockdata.getValue(FACING)).getAxis();
        return iblockdata.getValue(OPEN) != false ? Shapes.empty() : SHAPE_COLLISION.get(enumdirection_enumaxis);
    }

    @Override
    protected VoxelShape getOcclusionShape(BlockState iblockdata) {
        Direction.Axis enumdirection_enumaxis = ((Direction)iblockdata.getValue(FACING)).getAxis();
        return (iblockdata.getValue(IN_WALL) != false ? SHAPE_OCCLUSION_WALL : SHAPE_OCCLUSION).get(enumdirection_enumaxis);
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        switch (pathmode) {
            case LAND: {
                return iblockdata.getValue(OPEN);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return iblockdata.getValue(OPEN);
            }
        }
        return false;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        Level world = blockactioncontext.getLevel();
        BlockPos blockposition = blockactioncontext.getClickedPos();
        boolean flag = world.hasNeighborSignal(blockposition);
        Direction enumdirection = blockactioncontext.getHorizontalDirection();
        Direction.Axis enumdirection_enumaxis = enumdirection.getAxis();
        boolean flag1 = enumdirection_enumaxis == Direction.Axis.Z && (this.isWall(world.getBlockState(blockposition.west())) || this.isWall(world.getBlockState(blockposition.east()))) || enumdirection_enumaxis == Direction.Axis.X && (this.isWall(world.getBlockState(blockposition.north())) || this.isWall(world.getBlockState(blockposition.south())));
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, enumdirection)).setValue(OPEN, flag)).setValue(POWERED, flag)).setValue(IN_WALL, flag1);
    }

    private boolean isWall(BlockState iblockdata) {
        return iblockdata.is(BlockTags.WALLS);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        if (iblockdata.getValue(OPEN).booleanValue()) {
            iblockdata = (BlockState)iblockdata.setValue(OPEN, false);
            world.setBlock(blockposition, iblockdata, 10);
        } else {
            Direction enumdirection = entityhuman.getDirection();
            if (iblockdata.getValue(FACING) == enumdirection.getOpposite()) {
                iblockdata = (BlockState)iblockdata.setValue(FACING, enumdirection);
            }
            iblockdata = (BlockState)iblockdata.setValue(OPEN, true);
            world.setBlock(blockposition, iblockdata, 10);
        }
        boolean flag = iblockdata.getValue(OPEN);
        world.playSound((Entity)entityhuman, blockposition, flag ? this.type.fenceGateOpen() : this.type.fenceGateClose(), SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.1f + 0.9f);
        world.gameEvent((Entity)entityhuman, flag ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, blockposition);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void onExplosionHit(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPos> biconsumer) {
        if (explosion.canTriggerBlocks() && !iblockdata.getValue(POWERED).booleanValue()) {
            boolean flag = iblockdata.getValue(OPEN);
            worldserver.setBlockAndUpdate(blockposition, (BlockState)iblockdata.setValue(OPEN, !flag));
            worldserver.playSound((Entity)null, blockposition, flag ? this.type.fenceGateClose() : this.type.fenceGateOpen(), SoundSource.BLOCKS, 1.0f, worldserver.getRandom().nextFloat() * 0.1f + 0.9f);
            worldserver.gameEvent(flag ? GameEvent.BLOCK_CLOSE : GameEvent.BLOCK_OPEN, blockposition, GameEvent.Context.of(iblockdata));
        }
        super.onExplosionHit(iblockdata, worldserver, blockposition, explosion, biconsumer);
    }

    @Override
    protected void neighborChanged(BlockState iblockdata, Level world, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        if (!world.isClientSide()) {
            boolean flag1 = world.hasNeighborSignal(blockposition);
            boolean oldPowered = iblockdata.getValue(POWERED);
            if (oldPowered != flag1) {
                int newPower = flag1 ? 15 : 0;
                int oldPower = oldPowered ? 15 : 0;
                CraftBlock bukkitBlock = CraftBlock.at(world, blockposition);
                BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)bukkitBlock, oldPower, newPower);
                world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
                boolean bl = flag1 = eventRedstone.getNewCurrent() > 0;
            }
            if (iblockdata.getValue(POWERED) != flag1) {
                world.setBlock(blockposition, (BlockState)((BlockState)iblockdata.setValue(POWERED, flag1)).setValue(OPEN, flag1), 2);
                if (iblockdata.getValue(OPEN) != flag1) {
                    world.playSound((Entity)null, blockposition, flag1 ? this.type.fenceGateOpen() : this.type.fenceGateClose(), SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.1f + 0.9f);
                    world.gameEvent((Entity)null, flag1 ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, blockposition);
                }
            }
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(FACING, OPEN, POWERED, IN_WALL);
    }

    public static boolean connectsToDirection(BlockState iblockdata, Direction enumdirection) {
        return ((Direction)iblockdata.getValue(FACING)).getAxis() == enumdirection.getClockWise().getAxis();
    }
}

