/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HangingMossBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<HangingMossBlock> CODEC = HangingMossBlock.simpleCodec(HangingMossBlock::new);
    private static final VoxelShape SHAPE_BASE = Block.column(14.0, 0.0, 16.0);
    private static final VoxelShape SHAPE_TIP = Block.column(14.0, 2.0, 16.0);
    public static final BooleanProperty TIP = BlockStateProperties.TIP;

    public MapCodec<HangingMossBlock> codec() {
        return CODEC;
    }

    public HangingMossBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(TIP, true));
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return var0.getValue(TIP) != false ? SHAPE_TIP : SHAPE_BASE;
    }

    @Override
    public void animateTick(BlockState var0, Level var1, BlockPos var2, RandomSource var3) {
        BlockState var4;
        if (var3.nextInt(500) == 0 && ((var4 = var1.getBlockState(var2.above())).is(BlockTags.PALE_OAK_LOGS) || var4.is(Blocks.PALE_OAK_LEAVES))) {
            var1.playLocalSound(var2.getX(), var2.getY(), var2.getZ(), SoundEvents.PALE_HANGING_MOSS_IDLE, SoundSource.AMBIENT, 1.0f, 1.0f, false);
        }
    }

    @Override
    protected boolean propagatesSkylightDown(BlockState var0) {
        return true;
    }

    @Override
    protected boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        return this.canStayAtPosition(var1, var2);
    }

    private boolean canStayAtPosition(BlockGetter var0, BlockPos var1) {
        BlockState var3;
        BlockPos var2 = var1.relative(Direction.UP);
        return MultifaceBlock.canAttachTo(var0, Direction.UP, var2, var3 = var0.getBlockState(var2)) || var3.is(Blocks.PALE_HANGING_MOSS);
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (!this.canStayAtPosition(var1, var3)) {
            var2.scheduleTick(var3, this, 1);
        }
        return (BlockState)var0.setValue(TIP, !var1.getBlockState(var3.below()).is(this));
    }

    @Override
    protected void tick(BlockState var0, ServerLevel var1, BlockPos var2, RandomSource var3) {
        if (!this.canStayAtPosition(var1, var2)) {
            var1.destroyBlock(var2, true);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(TIP);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader var0, BlockPos var1, BlockState var2) {
        return this.canGrowInto(var0.getBlockState(this.getTip(var0, var1).below()));
    }

    private boolean canGrowInto(BlockState var0) {
        return var0.isAir();
    }

    public BlockPos getTip(BlockGetter var0, BlockPos var1) {
        BlockState var3;
        BlockPos.MutableBlockPos var2 = var1.mutable();
        do {
            var2.move(Direction.DOWN);
        } while ((var3 = var0.getBlockState(var2)).is(this));
        return ((BlockPos)var2.relative(Direction.UP)).immutable();
    }

    @Override
    public boolean isBonemealSuccess(Level var0, RandomSource var1, BlockPos var2, BlockState var3) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel var0, RandomSource var1, BlockPos var2, BlockState var3) {
        BlockPos var4 = this.getTip(var0, var2).below();
        if (!this.canGrowInto(var0.getBlockState(var4))) {
            return;
        }
        var0.setBlockAndUpdate(var4, (BlockState)var3.setValue(TIP, true));
    }
}

