/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public class HopperBlock
extends BaseEntityBlock {
    public static final MapCodec<HopperBlock> CODEC = HopperBlock.simpleCodec(HopperBlock::new);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING_HOPPER;
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;
    private final Function<BlockState, VoxelShape> shapes;
    private final Map<Direction, VoxelShape> interactionShapes;

    public MapCodec<HopperBlock> codec() {
        return CODEC;
    }

    public HopperBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.DOWN)).setValue(ENABLED, true));
        VoxelShape var1 = Block.column(12.0, 11.0, 16.0);
        this.shapes = this.makeShapes(var1);
        this.interactionShapes = ImmutableMap.builderWithExpectedSize((int)5).putAll(Shapes.rotateHorizontal(Shapes.or(var1, Block.boxZ(4.0, 8.0, 10.0, 0.0, 4.0)))).put((Object)Direction.DOWN, (Object)var1).build();
    }

    private Function<BlockState, VoxelShape> makeShapes(VoxelShape var0) {
        VoxelShape var1 = Shapes.or(Block.column(16.0, 10.0, 16.0), Block.column(8.0, 4.0, 10.0));
        VoxelShape var22 = Shapes.join(var1, var0, BooleanOp.ONLY_FIRST);
        Map<Direction, VoxelShape> var3 = Shapes.rotateAll(Block.boxZ(4.0, 4.0, 8.0, 0.0, 8.0), new Vec3(8.0, 6.0, 8.0).scale(0.0625));
        return this.getShapeForEachState(var2 -> Shapes.or(var22, Shapes.join((VoxelShape)var3.get(var2.getValue(FACING)), Shapes.block(), BooleanOp.AND)), ENABLED);
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return this.shapes.apply(var0);
    }

    @Override
    protected VoxelShape getInteractionShape(BlockState var0, BlockGetter var1, BlockPos var2) {
        return this.interactionShapes.get(var0.getValue(FACING));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        Direction var1 = var0.getClickedFace().getOpposite();
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, var1.getAxis() == Direction.Axis.Y ? Direction.DOWN : var1)).setValue(ENABLED, true);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos var0, BlockState var1) {
        return new HopperBlockEntity(var0, var1);
    }

    @Override
    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> getTicker(Level var0, BlockState var1, BlockEntityType<T> var2) {
        return var0.isClientSide() ? null : HopperBlock.createTickerHelper(var2, BlockEntityType.HOPPER, HopperBlockEntity::pushItemsTick);
    }

    @Override
    protected void onPlace(BlockState var0, Level var1, BlockPos var2, BlockState var3, boolean var4) {
        if (var3.is(var0.getBlock())) {
            return;
        }
        this.checkPoweredState(var1, var2, var0);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState var0, Level var1, BlockPos var2, Player var3, BlockHitResult var4) {
        BlockEntity blockEntity;
        if (!var1.isClientSide() && (blockEntity = var1.getBlockEntity(var2)) instanceof HopperBlockEntity) {
            HopperBlockEntity var5 = (HopperBlockEntity)blockEntity;
            var3.openMenu(var5);
            var3.awardStat(Stats.INSPECT_HOPPER);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void neighborChanged(BlockState var0, Level var1, BlockPos var2, Block var3, @Nullable Orientation var4, boolean var5) {
        this.checkPoweredState(var1, var2, var0);
    }

    private void checkPoweredState(Level var0, BlockPos var1, BlockState var2) {
        boolean var3;
        boolean bl = var3 = !var0.hasNeighborSignal(var1);
        if (var3 != var2.getValue(ENABLED)) {
            var0.setBlock(var1, (BlockState)var2.setValue(ENABLED, var3), 2);
        }
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState var0, ServerLevel var1, BlockPos var2, boolean var3) {
        Containers.updateNeighboursAfterDestroy(var0, var1, var2);
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState var0, Level var1, BlockPos var2, Direction var3) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity(var1.getBlockEntity(var2));
    }

    @Override
    protected BlockState rotate(BlockState var0, Rotation var1) {
        return (BlockState)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState var0, Mirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(FACING, ENABLED);
    }

    @Override
    protected void entityInside(BlockState var0, Level var1, BlockPos var2, Entity var3, InsideBlockEffectApplier var4, boolean var5) {
        BlockEntity var6 = var1.getBlockEntity(var2);
        if (var6 instanceof HopperBlockEntity) {
            HopperBlockEntity.entityInside(var1, var2, var0, var3, (HopperBlockEntity)var6);
        }
    }

    @Override
    protected boolean isPathfindable(BlockState var0, PathComputationType var1) {
        return false;
    }
}

