/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;

public class HugeMushroomBlock
extends Block {
    public static final MapCodec<HugeMushroomBlock> CODEC = HugeMushroomBlock.simpleCodec(HugeMushroomBlock::new);
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty DOWN = PipeBlock.DOWN;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.PROPERTY_BY_DIRECTION;

    public MapCodec<HugeMushroomBlock> codec() {
        return CODEC;
    }

    public HugeMushroomBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(NORTH, true)).setValue(EAST, true)).setValue(SOUTH, true)).setValue(WEST, true)).setValue(UP, true)).setValue(DOWN, true));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        Level var1 = var0.getLevel();
        BlockPos var2 = var0.getClickedPos();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(DOWN, !var1.getBlockState(var2.below()).is(this))).setValue(UP, !var1.getBlockState(var2.above()).is(this))).setValue(NORTH, !var1.getBlockState(var2.north()).is(this))).setValue(EAST, !var1.getBlockState(var2.east()).is(this))).setValue(SOUTH, !var1.getBlockState(var2.south()).is(this))).setValue(WEST, !var1.getBlockState(var2.west()).is(this));
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var6.is(this)) {
            return (BlockState)var0.setValue(PROPERTY_BY_DIRECTION.get(var4), false);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected BlockState rotate(BlockState var0, Rotation var1) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)var0.setValue(PROPERTY_BY_DIRECTION.get(var1.rotate(Direction.NORTH)), var0.getValue(NORTH))).setValue(PROPERTY_BY_DIRECTION.get(var1.rotate(Direction.SOUTH)), var0.getValue(SOUTH))).setValue(PROPERTY_BY_DIRECTION.get(var1.rotate(Direction.EAST)), var0.getValue(EAST))).setValue(PROPERTY_BY_DIRECTION.get(var1.rotate(Direction.WEST)), var0.getValue(WEST))).setValue(PROPERTY_BY_DIRECTION.get(var1.rotate(Direction.UP)), var0.getValue(UP))).setValue(PROPERTY_BY_DIRECTION.get(var1.rotate(Direction.DOWN)), var0.getValue(DOWN));
    }

    @Override
    protected BlockState mirror(BlockState var0, Mirror var1) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)var0.setValue(PROPERTY_BY_DIRECTION.get(var1.mirror(Direction.NORTH)), var0.getValue(NORTH))).setValue(PROPERTY_BY_DIRECTION.get(var1.mirror(Direction.SOUTH)), var0.getValue(SOUTH))).setValue(PROPERTY_BY_DIRECTION.get(var1.mirror(Direction.EAST)), var0.getValue(EAST))).setValue(PROPERTY_BY_DIRECTION.get(var1.mirror(Direction.WEST)), var0.getValue(WEST))).setValue(PROPERTY_BY_DIRECTION.get(var1.mirror(Direction.UP)), var0.getValue(UP))).setValue(PROPERTY_BY_DIRECTION.get(var1.mirror(Direction.DOWN)), var0.getValue(DOWN));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(UP, DOWN, NORTH, EAST, SOUTH, WEST);
    }
}

