/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.jspecify.annotations.Nullable;

public class IceBlock
extends HalfTransparentBlock {
    public static final MapCodec<IceBlock> CODEC = IceBlock.simpleCodec(IceBlock::new);

    public MapCodec<? extends IceBlock> codec() {
        return CODEC;
    }

    public IceBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
    }

    public static BlockState meltsInto() {
        return Blocks.WATER.defaultBlockState();
    }

    @Override
    public void playerDestroy(Level world, Player entityhuman, BlockPos blockposition, BlockState iblockdata, @Nullable BlockEntity tileentity, ItemStack itemstack) {
        super.playerDestroy(world, entityhuman, blockposition, iblockdata, tileentity, itemstack);
        if (!EnchantmentHelper.hasTag(itemstack, EnchantmentTags.PREVENTS_ICE_MELTING)) {
            if (world.environmentAttributes().getValue(EnvironmentAttributes.WATER_EVAPORATES, blockposition).booleanValue()) {
                world.removeBlock(blockposition, false);
                return;
            }
            BlockState iblockdata1 = world.getBlockState(blockposition.below());
            if (iblockdata1.blocksMotion() || iblockdata1.liquid()) {
                world.setBlockAndUpdate(blockposition, IceBlock.meltsInto());
            }
        }
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (worldserver.getBrightness(LightLayer.BLOCK, blockposition) > 11 - iblockdata.getLightBlock()) {
            this.melt(iblockdata, worldserver, blockposition);
        }
    }

    protected void melt(BlockState iblockdata, Level world, BlockPos blockposition) {
        if (CraftEventFactory.callBlockFadeEvent(world, blockposition, world.environmentAttributes().getValue(EnvironmentAttributes.WATER_EVAPORATES, blockposition) != false ? Blocks.AIR.defaultBlockState() : IceBlock.meltsInto()).isCancelled()) {
            return;
        }
        if (world.environmentAttributes().getValue(EnvironmentAttributes.WATER_EVAPORATES, blockposition).booleanValue()) {
            world.removeBlock(blockposition, false);
        } else {
            world.setBlockAndUpdate(blockposition, IceBlock.meltsInto());
            world.neighborChanged(blockposition, IceBlock.meltsInto().getBlock(), null);
        }
    }
}

