/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gamerules.GameRules;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class InfestedBlock
extends Block {
    public static final MapCodec<InfestedBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("host").forGetter(InfestedBlock::getHostBlock), InfestedBlock.propertiesCodec()).apply((Applicative)instance, InfestedBlock::new));
    private final Block hostBlock;
    private static final Map<Block, Block> BLOCK_BY_HOST_BLOCK = Maps.newIdentityHashMap();
    private static final Map<BlockState, BlockState> HOST_TO_INFESTED_STATES = Maps.newIdentityHashMap();
    private static final Map<BlockState, BlockState> INFESTED_TO_HOST_STATES = Maps.newIdentityHashMap();

    public MapCodec<? extends InfestedBlock> codec() {
        return CODEC;
    }

    public InfestedBlock(Block block, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info.destroyTime(block.defaultDestroyTime() / 2.0f).explosionResistance(0.75f));
        this.hostBlock = block;
        BLOCK_BY_HOST_BLOCK.put(block, this);
    }

    public Block getHostBlock() {
        return this.hostBlock;
    }

    public static boolean isCompatibleHostBlock(BlockState iblockdata) {
        return BLOCK_BY_HOST_BLOCK.containsKey(iblockdata.getBlock());
    }

    private void spawnInfestation(ServerLevel worldserver, BlockPos blockposition) {
        Silverfish entitysilverfish = EntityType.SILVERFISH.create(worldserver, EntitySpawnReason.TRIGGERED);
        if (entitysilverfish != null) {
            entitysilverfish.snapTo((double)blockposition.getX() + 0.5, blockposition.getY(), (double)blockposition.getZ() + 0.5, 0.0f, 0.0f);
            worldserver.addFreshEntity(entitysilverfish, CreatureSpawnEvent.SpawnReason.SILVERFISH_BLOCK);
            entitysilverfish.spawnAnim();
        }
    }

    @Override
    protected void spawnAfterBreak(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, ItemStack itemstack, boolean flag) {
        super.spawnAfterBreak(iblockdata, worldserver, blockposition, itemstack, flag);
        if (worldserver.getGameRules().get(GameRules.BLOCK_DROPS).booleanValue() && !EnchantmentHelper.hasTag(itemstack, EnchantmentTags.PREVENTS_INFESTED_SPAWNS)) {
            this.spawnInfestation(worldserver, blockposition);
        }
    }

    public static BlockState infestedStateByHost(BlockState iblockdata) {
        return InfestedBlock.getNewStateWithProperties(HOST_TO_INFESTED_STATES, iblockdata, () -> BLOCK_BY_HOST_BLOCK.get(iblockdata.getBlock()).defaultBlockState());
    }

    public BlockState hostStateByInfested(BlockState iblockdata) {
        return InfestedBlock.getNewStateWithProperties(INFESTED_TO_HOST_STATES, iblockdata, () -> this.getHostBlock().defaultBlockState());
    }

    private static BlockState getNewStateWithProperties(Map<BlockState, BlockState> map, BlockState iblockdata, Supplier<BlockState> supplier) {
        return map.computeIfAbsent(iblockdata, iblockdata1 -> {
            BlockState iblockdata2 = (BlockState)supplier.get();
            for (Property<?> iblockstate : iblockdata1.getProperties()) {
                iblockdata2 = iblockdata2.hasProperty(iblockstate) ? (BlockState)iblockdata2.setValue(iblockstate, iblockdata1.getValue(iblockstate)) : iblockdata2;
            }
            return iblockdata2;
        });
    }
}

