/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.jspecify.annotations.Nullable;

public class LeverBlock
extends FaceAttachedHorizontalDirectionalBlock {
    public static final MapCodec<LeverBlock> CODEC = LeverBlock.simpleCodec(LeverBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private final Function<BlockState, VoxelShape> shapes;

    public MapCodec<LeverBlock> codec() {
        return CODEC;
    }

    protected LeverBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(POWERED, false)).setValue(FACE, AttachFace.WALL));
        this.shapes = this.makeShapes();
    }

    private Function<BlockState, VoxelShape> makeShapes() {
        Map<AttachFace, Map<Direction, VoxelShape>> map = Shapes.rotateAttachFace(Block.boxZ(6.0, 8.0, 10.0, 16.0));
        return this.getShapeForEachState(iblockdata -> (VoxelShape)((Map)map.get(iblockdata.getValue(FACE))).get(iblockdata.getValue(FACING)), POWERED);
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return this.shapes.apply(iblockdata);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        if (world.isClientSide()) {
            BlockState iblockdata1 = (BlockState)iblockdata.cycle(POWERED);
            if (iblockdata1.getValue(POWERED).booleanValue()) {
                LeverBlock.makeParticle(iblockdata1, world, blockposition, 1.0f);
            }
        } else {
            boolean powered = iblockdata.getValue(POWERED);
            org.bukkit.block.Block block = world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
            int old = powered ? 15 : 0;
            int current = !powered ? 15 : 0;
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
            world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
            if (eventRedstone.getNewCurrent() > 0 != !powered) {
                return InteractionResult.SUCCESS;
            }
            this.pull(iblockdata, world, blockposition, null);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void onExplosionHit(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPos> biconsumer) {
        if (explosion.canTriggerBlocks()) {
            this.pull(iblockdata, worldserver, blockposition, null);
        }
        super.onExplosionHit(iblockdata, worldserver, blockposition, explosion, biconsumer);
    }

    public void pull(BlockState iblockdata, Level world, BlockPos blockposition, @Nullable Player entityhuman) {
        iblockdata = (BlockState)iblockdata.cycle(POWERED);
        world.setBlock(blockposition, iblockdata, 3);
        this.updateNeighbours(iblockdata, world, blockposition);
        LeverBlock.playSound(entityhuman, world, blockposition, iblockdata);
        world.gameEvent((Entity)entityhuman, iblockdata.getValue(POWERED) != false ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE, blockposition);
    }

    protected static void playSound(@Nullable Player entityhuman, LevelAccessor generatoraccess, BlockPos blockposition, BlockState iblockdata) {
        float f = iblockdata.getValue(POWERED) != false ? 0.6f : 0.5f;
        generatoraccess.playSound(entityhuman, blockposition, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, f);
    }

    private static void makeParticle(BlockState iblockdata, LevelAccessor generatoraccess, BlockPos blockposition, float f) {
        Direction enumdirection = ((Direction)iblockdata.getValue(FACING)).getOpposite();
        Direction enumdirection1 = LeverBlock.getConnectedDirection(iblockdata).getOpposite();
        double d0 = (double)blockposition.getX() + 0.5 + 0.1 * (double)enumdirection.getStepX() + 0.2 * (double)enumdirection1.getStepX();
        double d1 = (double)blockposition.getY() + 0.5 + 0.1 * (double)enumdirection.getStepY() + 0.2 * (double)enumdirection1.getStepY();
        double d2 = (double)blockposition.getZ() + 0.5 + 0.1 * (double)enumdirection.getStepZ() + 0.2 * (double)enumdirection1.getStepZ();
        generatoraccess.addParticle(new DustParticleOptions(0xFF0000, f), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    @Override
    public void animateTick(BlockState iblockdata, Level world, BlockPos blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(POWERED).booleanValue() && randomsource.nextFloat() < 0.25f) {
            LeverBlock.makeParticle(iblockdata, world, blockposition, 0.5f);
        }
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, boolean flag) {
        if (!flag && iblockdata.getValue(POWERED).booleanValue()) {
            this.updateNeighbours(iblockdata, worldserver, blockposition);
        }
    }

    @Override
    protected int getSignal(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return iblockdata.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return iblockdata.getValue(POWERED) != false && LeverBlock.getConnectedDirection(iblockdata) == enumdirection ? 15 : 0;
    }

    @Override
    protected boolean isSignalSource(BlockState iblockdata) {
        return true;
    }

    private void updateNeighbours(BlockState iblockdata, Level world, BlockPos blockposition) {
        Direction enumdirection;
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation(world, enumdirection, (enumdirection = LeverBlock.getConnectedDirection(iblockdata).getOpposite()).getAxis().isHorizontal() ? Direction.UP : (Direction)iblockdata.getValue(FACING));
        world.updateNeighborsAt(blockposition, this, orientation);
        world.updateNeighborsAt(blockposition.relative(enumdirection), this, orientation);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(FACE, FACING, POWERED);
    }
}

