/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.jspecify.annotations.Nullable;

public class LiquidBlock
extends Block
implements BucketPickup {
    private static final Codec<FlowingFluid> FLOWING_FLUID = BuiltInRegistries.FLUID.byNameCodec().comapFlatMap(fluidtype -> {
        DataResult dataresult;
        if (fluidtype instanceof FlowingFluid) {
            FlowingFluid fluidtypeflowing = (FlowingFluid)fluidtype;
            dataresult = DataResult.success((Object)fluidtypeflowing);
        } else {
            dataresult = DataResult.error(() -> "Not a flowing fluid: " + String.valueOf(fluidtype));
        }
        return dataresult;
    }, fluidtypeflowing -> fluidtypeflowing);
    public static final MapCodec<LiquidBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FLOWING_FLUID.fieldOf("fluid").forGetter(blockfluids -> blockfluids.fluid), LiquidBlock.propertiesCodec()).apply((Applicative)instance, LiquidBlock::new));
    public static final IntegerProperty LEVEL = BlockStateProperties.LEVEL;
    protected final FlowingFluid fluid;
    private final List<FluidState> stateCache;
    public static final VoxelShape SHAPE_STABLE = Block.column(16.0, 0.0, 8.0);
    public static final ImmutableList<Direction> POSSIBLE_FLOW_DIRECTIONS = ImmutableList.of((Object)Direction.DOWN, (Object)Direction.SOUTH, (Object)Direction.NORTH, (Object)Direction.EAST, (Object)Direction.WEST);

    public MapCodec<LiquidBlock> codec() {
        return CODEC;
    }

    protected LiquidBlock(FlowingFluid fluidtypeflowing, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.fluid = fluidtypeflowing;
        this.stateCache = Lists.newArrayList();
        this.stateCache.add(fluidtypeflowing.getSource(false));
        for (int i = 1; i < 8; ++i) {
            this.stateCache.add(fluidtypeflowing.getFlowing(8 - i, false));
        }
        this.stateCache.add(fluidtypeflowing.getFlowing(8, true));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(LEVEL, 0));
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return voxelshapecollision.alwaysCollideWithFluid() ? Shapes.block() : (voxelshapecollision.isAbove(SHAPE_STABLE, blockposition, true) && iblockdata.getValue(LEVEL) == 0 && voxelshapecollision.canStandOnFluid(iblockaccess.getFluidState(blockposition.above()), iblockdata.getFluidState()) ? SHAPE_STABLE : Shapes.empty());
    }

    @Override
    protected boolean isRandomlyTicking(BlockState iblockdata) {
        return iblockdata.getFluidState().isRandomlyTicking();
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        iblockdata.getFluidState().randomTick(worldserver, blockposition, randomsource);
    }

    @Override
    protected boolean propagatesSkylightDown(BlockState iblockdata) {
        return false;
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        return !this.fluid.is(FluidTags.LAVA);
    }

    @Override
    protected FluidState getFluidState(BlockState iblockdata) {
        int i = iblockdata.getValue(LEVEL);
        return this.stateCache.get(Math.min(i, 8));
    }

    @Override
    protected boolean skipRendering(BlockState iblockdata, BlockState iblockdata1, Direction enumdirection) {
        return iblockdata1.getFluidState().getType().isSame(this.fluid);
    }

    @Override
    protected RenderShape getRenderShape(BlockState iblockdata) {
        return RenderShape.INVISIBLE;
    }

    @Override
    protected List<ItemStack> getDrops(BlockState iblockdata, LootParams.Builder lootparams_a) {
        return Collections.emptyList();
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return Shapes.empty();
    }

    @Override
    protected void onPlace(BlockState iblockdata, Level world, BlockPos blockposition, BlockState iblockdata1, boolean flag) {
        if (this.shouldSpreadLiquid(world, blockposition, iblockdata)) {
            world.scheduleTick(blockposition, iblockdata.getFluidState().getType(), this.fluid.getTickDelay(world));
        }
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        if (iblockdata.getFluidState().isSource() || iblockdata1.getFluidState().isSource()) {
            scheduledtickaccess.scheduleTick(blockposition, iblockdata.getFluidState().getType(), this.fluid.getTickDelay(iworldreader));
        }
        return super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    protected void neighborChanged(BlockState iblockdata, Level world, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        if (this.shouldSpreadLiquid(world, blockposition, iblockdata)) {
            world.scheduleTick(blockposition, iblockdata.getFluidState().getType(), this.fluid.getTickDelay(world));
        }
    }

    private boolean shouldSpreadLiquid(Level world, BlockPos blockposition, BlockState iblockdata) {
        if (this.fluid.is(FluidTags.LAVA)) {
            boolean flag = world.getBlockState(blockposition.below()).is(Blocks.SOUL_SOIL);
            for (Direction enumdirection : POSSIBLE_FLOW_DIRECTIONS) {
                BlockPos blockposition1 = blockposition.relative(enumdirection.getOpposite());
                if (world.getFluidState(blockposition1).is(FluidTags.WATER)) {
                    Block block;
                    Block block2 = block = world.getFluidState(blockposition).isSource() ? Blocks.OBSIDIAN : Blocks.COBBLESTONE;
                    if (CraftEventFactory.handleBlockFormEvent(world, blockposition, block.defaultBlockState())) {
                        this.fizz(world, blockposition);
                    }
                    return false;
                }
                if (!flag || !world.getBlockState(blockposition1).is(Blocks.BLUE_ICE)) continue;
                if (CraftEventFactory.handleBlockFormEvent(world, blockposition, Blocks.BASALT.defaultBlockState())) {
                    this.fizz(world, blockposition);
                }
                return false;
            }
        }
        return true;
    }

    private void fizz(LevelAccessor generatoraccess, BlockPos blockposition) {
        generatoraccess.levelEvent(1501, blockposition, 0);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(LEVEL);
    }

    @Override
    public ItemStack pickupBlock(@Nullable LivingEntity entityliving, LevelAccessor generatoraccess, BlockPos blockposition, BlockState iblockdata) {
        if (iblockdata.getValue(LEVEL) == 0) {
            generatoraccess.setBlock(blockposition, Blocks.AIR.defaultBlockState(), 11);
            return new ItemStack(this.fluid.getBucket());
        }
        return ItemStack.EMPTY;
    }

    @Override
    public Optional<SoundEvent> getPickupSound() {
        return this.fluid.getPickupSound();
    }
}

