/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public class MossyCarpetBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<MossyCarpetBlock> CODEC = MossyCarpetBlock.simpleCodec(MossyCarpetBlock::new);
    public static final BooleanProperty BASE = BlockStateProperties.BOTTOM;
    public static final EnumProperty<WallSide> NORTH = BlockStateProperties.NORTH_WALL;
    public static final EnumProperty<WallSide> EAST = BlockStateProperties.EAST_WALL;
    public static final EnumProperty<WallSide> SOUTH = BlockStateProperties.SOUTH_WALL;
    public static final EnumProperty<WallSide> WEST = BlockStateProperties.WEST_WALL;
    public static final Map<Direction, EnumProperty<WallSide>> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(Direction.NORTH, NORTH, Direction.EAST, EAST, Direction.SOUTH, SOUTH, Direction.WEST, WEST)));
    private final Function<BlockState, VoxelShape> shapes;

    public MapCodec<MossyCarpetBlock> codec() {
        return CODEC;
    }

    public MossyCarpetBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(BASE, true)).setValue(NORTH, WallSide.NONE)).setValue(EAST, WallSide.NONE)).setValue(SOUTH, WallSide.NONE)).setValue(WEST, WallSide.NONE));
        this.shapes = this.makeShapes();
    }

    public Function<BlockState, VoxelShape> makeShapes() {
        Map<Direction, VoxelShape> var0 = Shapes.rotateHorizontal(Block.boxZ(16.0, 0.0, 10.0, 0.0, 1.0));
        Map<Direction, VoxelShape> var1 = Shapes.rotateAll(Block.boxZ(16.0, 0.0, 1.0));
        return this.getShapeForEachState(var2 -> {
            VoxelShape var3 = var2.getValue(BASE) != false ? (VoxelShape)var1.get(Direction.DOWN) : Shapes.empty();
            for (Map.Entry<Direction, EnumProperty<WallSide>> var5 : PROPERTY_BY_DIRECTION.entrySet()) {
                switch ((WallSide)var2.getValue(var5.getValue())) {
                    case NONE: {
                        break;
                    }
                    case LOW: {
                        var3 = Shapes.or(var3, (VoxelShape)var0.get(var5.getKey()));
                        break;
                    }
                    case TALL: {
                        var3 = Shapes.or(var3, (VoxelShape)var1.get(var5.getKey()));
                    }
                }
            }
            return var3.isEmpty() ? Shapes.block() : var3;
        });
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return this.shapes.apply(var0);
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return var0.getValue(BASE) != false ? this.shapes.apply(this.defaultBlockState()) : Shapes.empty();
    }

    @Override
    protected boolean propagatesSkylightDown(BlockState var0) {
        return true;
    }

    @Override
    protected boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        BlockState var3 = var1.getBlockState(var2.below());
        if (var0.getValue(BASE).booleanValue()) {
            return !var3.isAir();
        }
        return var3.is(this) && var3.getValue(BASE) != false;
    }

    private static boolean hasFaces(BlockState var0) {
        if (var0.getValue(BASE).booleanValue()) {
            return true;
        }
        for (EnumProperty<WallSide> var2 : PROPERTY_BY_DIRECTION.values()) {
            if (var0.getValue(var2) == WallSide.NONE) continue;
            return true;
        }
        return false;
    }

    private static boolean canSupportAtFace(BlockGetter var0, BlockPos var1, Direction var2) {
        if (var2 == Direction.UP) {
            return false;
        }
        return MultifaceBlock.canAttachTo(var0, var1, var2);
    }

    private static BlockState getUpdatedState(BlockState var0, BlockGetter var1, BlockPos var2, boolean var3) {
        BlockBehaviour.BlockStateBase var4 = null;
        BlockBehaviour.BlockStateBase var5 = null;
        var3 |= var0.getValue(BASE).booleanValue();
        for (Direction var7 : Direction.Plane.HORIZONTAL) {
            WallSide var9;
            EnumProperty<WallSide> var8 = MossyCarpetBlock.getPropertyForFace(var7);
            WallSide wallSide = MossyCarpetBlock.canSupportAtFace(var1, var2, var7) ? (var3 ? WallSide.LOW : var0.getValue(var8)) : (var9 = WallSide.NONE);
            if (var9 == WallSide.LOW) {
                if (var4 == null) {
                    var4 = var1.getBlockState(var2.above());
                }
                if (var4.is(Blocks.PALE_MOSS_CARPET) && var4.getValue(var8) != WallSide.NONE && !var4.getValue(BASE).booleanValue()) {
                    var9 = WallSide.TALL;
                }
                if (!var0.getValue(BASE).booleanValue()) {
                    if (var5 == null) {
                        var5 = var1.getBlockState(var2.below());
                    }
                    if (var5.is(Blocks.PALE_MOSS_CARPET) && var5.getValue(var8) == WallSide.NONE) {
                        var9 = WallSide.NONE;
                    }
                }
            }
            var0 = (BlockState)var0.setValue(var8, var9);
        }
        return var0;
    }

    @Override
    public @Nullable BlockState getStateForPlacement(BlockPlaceContext var0) {
        return MossyCarpetBlock.getUpdatedState(this.defaultBlockState(), var0.getLevel(), var0.getClickedPos(), true);
    }

    public static void placeAt(LevelAccessor var0, BlockPos var1, RandomSource var2, @Block.UpdateFlags int var3) {
        BlockState var4 = Blocks.PALE_MOSS_CARPET.defaultBlockState();
        BlockState var5 = MossyCarpetBlock.getUpdatedState(var4, var0, var1, true);
        var0.setBlock(var1, var5, var3);
        BlockState var6 = MossyCarpetBlock.createTopperWithSideChance(var0, var1, var2::nextBoolean);
        if (!var6.isAir()) {
            var0.setBlock(var1.above(), var6, var3);
            BlockState var7 = MossyCarpetBlock.getUpdatedState(var5, var0, var1, true);
            var0.setBlock(var1, var7, var3);
        }
    }

    @Override
    public void setPlacedBy(Level var0, BlockPos var1, BlockState var2, @Nullable LivingEntity var3, ItemStack var4) {
        if (var0.isClientSide()) {
            return;
        }
        RandomSource var5 = var0.getRandom();
        BlockState var6 = MossyCarpetBlock.createTopperWithSideChance(var0, var1, var5::nextBoolean);
        if (!var6.isAir()) {
            var0.setBlock(var1.above(), var6, 3);
        }
    }

    private static BlockState createTopperWithSideChance(BlockGetter var0, BlockPos var1, BooleanSupplier var2) {
        BlockPos var3 = var1.above();
        BlockState var4 = var0.getBlockState(var3);
        boolean var5 = var4.is(Blocks.PALE_MOSS_CARPET);
        if (var5 && var4.getValue(BASE).booleanValue() || !var5 && !var4.canBeReplaced()) {
            return Blocks.AIR.defaultBlockState();
        }
        BlockState var6 = (BlockState)Blocks.PALE_MOSS_CARPET.defaultBlockState().setValue(BASE, false);
        BlockState var7 = MossyCarpetBlock.getUpdatedState(var6, var0, var1.above(), true);
        for (Direction var9 : Direction.Plane.HORIZONTAL) {
            EnumProperty<WallSide> var10 = MossyCarpetBlock.getPropertyForFace(var9);
            if (var7.getValue(var10) == WallSide.NONE || var2.getAsBoolean()) continue;
            var7 = (BlockState)var7.setValue(var10, WallSide.NONE);
        }
        if (MossyCarpetBlock.hasFaces(var7) && var7 != var4) {
            return var7;
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (!var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        BlockState var8 = MossyCarpetBlock.getUpdatedState(var0, var1, var3, false);
        if (!MossyCarpetBlock.hasFaces(var8)) {
            return Blocks.AIR.defaultBlockState();
        }
        return var8;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(BASE, NORTH, EAST, SOUTH, WEST);
    }

    @Override
    protected BlockState rotate(BlockState var0, Rotation var1) {
        return switch (var1) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(EAST, var0.getValue(WEST))).setValue(SOUTH, var0.getValue(NORTH))).setValue(WEST, var0.getValue(EAST));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)var0.setValue(NORTH, var0.getValue(EAST))).setValue(EAST, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(WEST))).setValue(WEST, var0.getValue(NORTH));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)var0.setValue(NORTH, var0.getValue(WEST))).setValue(EAST, var0.getValue(NORTH))).setValue(SOUTH, var0.getValue(EAST))).setValue(WEST, var0.getValue(SOUTH));
            default -> var0;
        };
    }

    @Override
    protected BlockState mirror(BlockState var0, Mirror var1) {
        return switch (var1) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(NORTH));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)var0.setValue(EAST, var0.getValue(WEST))).setValue(WEST, var0.getValue(EAST));
            default -> super.mirror(var0, var1);
        };
    }

    public static @Nullable EnumProperty<WallSide> getPropertyForFace(Direction var0) {
        return PROPERTY_BY_DIRECTION.get(var0);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader var0, BlockPos var1, BlockState var2) {
        return var2.getValue(BASE) != false && !MossyCarpetBlock.createTopperWithSideChance(var0, var1, () -> true).isAir();
    }

    @Override
    public boolean isBonemealSuccess(Level var0, RandomSource var1, BlockPos var2, BlockState var3) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel var0, RandomSource var1, BlockPos var2, BlockState var3) {
        BlockState var4 = MossyCarpetBlock.createTopperWithSideChance(var0, var2, () -> true);
        if (!var4.isAir()) {
            var0.setBlock(var2.above(), var4, 3);
        }
    }
}

