/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.level.redstone.DefaultRedstoneWireEvaluator;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.ExperimentalRedstoneWireEvaluator;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.redstone.RedstoneWireEvaluator;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public class RedStoneWireBlock
extends Block {
    public static final MapCodec<RedStoneWireBlock> CODEC = RedStoneWireBlock.simpleCodec(RedStoneWireBlock::new);
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.NORTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.EAST_REDSTONE;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.SOUTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.WEST_REDSTONE;
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final Map<Direction, EnumProperty<RedstoneSide>> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(Direction.NORTH, NORTH, Direction.EAST, EAST, Direction.SOUTH, SOUTH, Direction.WEST, WEST)));
    private static final int[] COLORS = Util.make(new int[16], var0 -> {
        for (int var1 = 0; var1 <= 15; ++var1) {
            float var2;
            float var3 = var2 * 0.6f + ((var2 = (float)var1 / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float var4 = Mth.clamp(var2 * var2 * 0.7f - 0.5f, 0.0f, 1.0f);
            float var5 = Mth.clamp(var2 * var2 * 0.6f - 0.7f, 0.0f, 1.0f);
            var0[var1] = ARGB.colorFromFloat(1.0f, var3, var4, var5);
        }
    });
    private static final float PARTICLE_DENSITY = 0.2f;
    private final Function<BlockState, VoxelShape> shapes;
    private final BlockState crossState;
    private final RedstoneWireEvaluator evaluator = new DefaultRedstoneWireEvaluator(this);
    private boolean shouldSignal = true;

    public MapCodec<RedStoneWireBlock> codec() {
        return CODEC;
    }

    public RedStoneWireBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(NORTH, RedstoneSide.NONE)).setValue(EAST, RedstoneSide.NONE)).setValue(SOUTH, RedstoneSide.NONE)).setValue(WEST, RedstoneSide.NONE)).setValue(POWER, 0));
        this.shapes = this.makeShapes();
        this.crossState = (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(NORTH, RedstoneSide.SIDE)).setValue(EAST, RedstoneSide.SIDE)).setValue(SOUTH, RedstoneSide.SIDE)).setValue(WEST, RedstoneSide.SIDE);
    }

    private Function<BlockState, VoxelShape> makeShapes() {
        boolean var0 = true;
        int var1 = 10;
        VoxelShape var2 = Block.column(10.0, 0.0, 1.0);
        Map<Direction, VoxelShape> var32 = Shapes.rotateHorizontal(Block.boxZ(10.0, 0.0, 1.0, 0.0, 8.0));
        Map<Direction, VoxelShape> var4 = Shapes.rotateHorizontal(Block.boxZ(10.0, 16.0, 0.0, 1.0));
        return this.getShapeForEachState(var3 -> {
            VoxelShape var4 = var2;
            for (Map.Entry<Direction, EnumProperty<RedstoneSide>> var6 : PROPERTY_BY_DIRECTION.entrySet()) {
                var4 = switch ((RedstoneSide)var3.getValue(var6.getValue())) {
                    default -> throw new MatchException(null, null);
                    case RedstoneSide.UP -> Shapes.or(var4, (VoxelShape)var32.get(var6.getKey()), (VoxelShape)var4.get(var6.getKey()));
                    case RedstoneSide.SIDE -> Shapes.or(var4, (VoxelShape)var32.get(var6.getKey()));
                    case RedstoneSide.NONE -> var4;
                };
            }
            return var4;
        }, POWER);
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return this.shapes.apply(var0);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        return this.getConnectionState(var0.getLevel(), this.crossState, var0.getClickedPos());
    }

    private BlockState getConnectionState(BlockGetter var0, BlockState var1, BlockPos var2) {
        boolean var9;
        boolean var3 = RedStoneWireBlock.isDot(var1);
        var1 = this.getMissingConnections(var0, (BlockState)this.defaultBlockState().setValue(POWER, var1.getValue(POWER)), var2);
        if (var3 && RedStoneWireBlock.isDot(var1)) {
            return var1;
        }
        boolean var4 = var1.getValue(NORTH).isConnected();
        boolean var5 = var1.getValue(SOUTH).isConnected();
        boolean var6 = var1.getValue(EAST).isConnected();
        boolean var7 = var1.getValue(WEST).isConnected();
        boolean var8 = !var4 && !var5;
        boolean bl = var9 = !var6 && !var7;
        if (!var7 && var8) {
            var1 = (BlockState)var1.setValue(WEST, RedstoneSide.SIDE);
        }
        if (!var6 && var8) {
            var1 = (BlockState)var1.setValue(EAST, RedstoneSide.SIDE);
        }
        if (!var4 && var9) {
            var1 = (BlockState)var1.setValue(NORTH, RedstoneSide.SIDE);
        }
        if (!var5 && var9) {
            var1 = (BlockState)var1.setValue(SOUTH, RedstoneSide.SIDE);
        }
        return var1;
    }

    private BlockState getMissingConnections(BlockGetter var0, BlockState var1, BlockPos var2) {
        boolean var3 = !var0.getBlockState(var2.above()).isRedstoneConductor(var0, var2);
        for (Direction var5 : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)var1.getValue(PROPERTY_BY_DIRECTION.get(var5))).isConnected()) continue;
            RedstoneSide var6 = this.getConnectingSide(var0, var2, var5, var3);
            var1 = (BlockState)var1.setValue(PROPERTY_BY_DIRECTION.get(var5), var6);
        }
        return var1;
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var4 == Direction.DOWN) {
            if (!this.canSurviveOn(var1, var5, var6)) {
                return Blocks.AIR.defaultBlockState();
            }
            return var0;
        }
        if (var4 == Direction.UP) {
            return this.getConnectionState(var1, var0, var3);
        }
        RedstoneSide var8 = this.getConnectingSide(var1, var3, var4);
        if (var8.isConnected() == ((RedstoneSide)var0.getValue(PROPERTY_BY_DIRECTION.get(var4))).isConnected() && !RedStoneWireBlock.isCross(var0)) {
            return (BlockState)var0.setValue(PROPERTY_BY_DIRECTION.get(var4), var8);
        }
        return this.getConnectionState(var1, (BlockState)((BlockState)this.crossState.setValue(POWER, var0.getValue(POWER))).setValue(PROPERTY_BY_DIRECTION.get(var4), var8), var3);
    }

    private static boolean isCross(BlockState var0) {
        return var0.getValue(NORTH).isConnected() && var0.getValue(SOUTH).isConnected() && var0.getValue(EAST).isConnected() && var0.getValue(WEST).isConnected();
    }

    private static boolean isDot(BlockState var0) {
        return !var0.getValue(NORTH).isConnected() && !var0.getValue(SOUTH).isConnected() && !var0.getValue(EAST).isConnected() && !var0.getValue(WEST).isConnected();
    }

    @Override
    protected void updateIndirectNeighbourShapes(BlockState var0, LevelAccessor var1, BlockPos var2, @Block.UpdateFlags int var3, int var4) {
        BlockPos.MutableBlockPos var5 = new BlockPos.MutableBlockPos();
        for (Direction var7 : Direction.Plane.HORIZONTAL) {
            Object var10;
            RedstoneSide var8 = (RedstoneSide)var0.getValue(PROPERTY_BY_DIRECTION.get(var7));
            if (var8 == RedstoneSide.NONE || var1.getBlockState(var5.setWithOffset((Vec3i)var2, var7)).is(this)) continue;
            var5.move(Direction.DOWN);
            BlockState var9 = var1.getBlockState(var5);
            if (var9.is(this)) {
                var10 = var5.relative(var7.getOpposite());
                var1.neighborShapeChanged(var7.getOpposite(), var5, (BlockPos)var10, var1.getBlockState((BlockPos)var10), var3, var4);
            }
            var5.setWithOffset((Vec3i)var2, var7).move(Direction.UP);
            var10 = var1.getBlockState(var5);
            if (!((BlockBehaviour.BlockStateBase)var10).is(this)) continue;
            Vec3i var11 = var5.relative(var7.getOpposite());
            var1.neighborShapeChanged(var7.getOpposite(), var5, (BlockPos)var11, var1.getBlockState((BlockPos)var11), var3, var4);
        }
    }

    private RedstoneSide getConnectingSide(BlockGetter var0, BlockPos var1, Direction var2) {
        return this.getConnectingSide(var0, var1, var2, !var0.getBlockState(var1.above()).isRedstoneConductor(var0, var1));
    }

    private RedstoneSide getConnectingSide(BlockGetter var0, BlockPos var1, Direction var2, boolean var3) {
        BlockPos var4 = var1.relative(var2);
        BlockState var5 = var0.getBlockState(var4);
        if (var3) {
            boolean var6;
            boolean bl = var6 = var5.getBlock() instanceof TrapDoorBlock || this.canSurviveOn(var0, var4, var5);
            if (var6 && RedStoneWireBlock.shouldConnectTo(var0.getBlockState(var4.above()))) {
                if (var5.isFaceSturdy(var0, var4, var2.getOpposite())) {
                    return RedstoneSide.UP;
                }
                return RedstoneSide.SIDE;
            }
        }
        if (RedStoneWireBlock.shouldConnectTo(var5, var2) || !var5.isRedstoneConductor(var0, var4) && RedStoneWireBlock.shouldConnectTo(var0.getBlockState(var4.below()))) {
            return RedstoneSide.SIDE;
        }
        return RedstoneSide.NONE;
    }

    @Override
    protected boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        BlockPos var3 = var2.below();
        BlockState var4 = var1.getBlockState(var3);
        return this.canSurviveOn(var1, var3, var4);
    }

    private boolean canSurviveOn(BlockGetter var0, BlockPos var1, BlockState var2) {
        return var2.isFaceSturdy(var0, var1, Direction.UP) || var2.is(Blocks.HOPPER);
    }

    private void updatePowerStrength(Level var0, BlockPos var1, BlockState var2, @Nullable Orientation var3, boolean var4) {
        if (RedStoneWireBlock.useExperimentalEvaluator(var0)) {
            new ExperimentalRedstoneWireEvaluator(this).updatePowerStrength(var0, var1, var2, var3, var4);
        } else {
            this.evaluator.updatePowerStrength(var0, var1, var2, var3, var4);
        }
    }

    public int getBlockSignal(Level var0, BlockPos var1) {
        this.shouldSignal = false;
        int var2 = var0.getBestNeighborSignal(var1);
        this.shouldSignal = true;
        return var2;
    }

    private void checkCornerChangeAt(Level var0, BlockPos var1) {
        if (!var0.getBlockState(var1).is(this)) {
            return;
        }
        var0.updateNeighborsAt(var1, this);
        for (Direction var5 : Direction.values()) {
            var0.updateNeighborsAt(var1.relative(var5), this);
        }
    }

    @Override
    protected void onPlace(BlockState var0, Level var1, BlockPos var2, BlockState var3, boolean var4) {
        if (var3.is(var0.getBlock()) || var1.isClientSide()) {
            return;
        }
        this.updatePowerStrength(var1, var2, var0, null, true);
        for (Direction var6 : Direction.Plane.VERTICAL) {
            var1.updateNeighborsAt(var2.relative(var6), this);
        }
        this.updateNeighborsOfNeighboringWires(var1, var2);
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState var0, ServerLevel var1, BlockPos var2, boolean var3) {
        if (var3) {
            return;
        }
        for (Direction var7 : Direction.values()) {
            var1.updateNeighborsAt(var2.relative(var7), this);
        }
        this.updatePowerStrength(var1, var2, var0, null, false);
        this.updateNeighborsOfNeighboringWires(var1, var2);
    }

    private void updateNeighborsOfNeighboringWires(Level var0, BlockPos var1) {
        for (Direction var3 : Direction.Plane.HORIZONTAL) {
            this.checkCornerChangeAt(var0, var1.relative(var3));
        }
        for (Direction var3 : Direction.Plane.HORIZONTAL) {
            BlockPos var4 = var1.relative(var3);
            if (var0.getBlockState(var4).isRedstoneConductor(var0, var4)) {
                this.checkCornerChangeAt(var0, var4.above());
                continue;
            }
            this.checkCornerChangeAt(var0, var4.below());
        }
    }

    @Override
    protected void neighborChanged(BlockState var0, Level var1, BlockPos var2, Block var3, @Nullable Orientation var4, boolean var5) {
        if (var1.isClientSide()) {
            return;
        }
        if (var3 == this && RedStoneWireBlock.useExperimentalEvaluator(var1)) {
            return;
        }
        if (var0.canSurvive(var1, var2)) {
            this.updatePowerStrength(var1, var2, var0, var4, false);
        } else {
            RedStoneWireBlock.dropResources(var0, var1, var2);
            var1.removeBlock(var2, false);
        }
    }

    private static boolean useExperimentalEvaluator(Level var0) {
        return var0.enabledFeatures().contains(FeatureFlags.REDSTONE_EXPERIMENTS);
    }

    @Override
    protected int getDirectSignal(BlockState var0, BlockGetter var1, BlockPos var2, Direction var3) {
        if (!this.shouldSignal) {
            return 0;
        }
        return var0.getSignal(var1, var2, var3);
    }

    @Override
    protected int getSignal(BlockState var0, BlockGetter var1, BlockPos var2, Direction var3) {
        if (!this.shouldSignal || var3 == Direction.DOWN) {
            return 0;
        }
        int var4 = var0.getValue(POWER);
        if (var4 == 0) {
            return 0;
        }
        if (var3 == Direction.UP || ((RedstoneSide)this.getConnectionState(var1, var0, var2).getValue(PROPERTY_BY_DIRECTION.get(var3.getOpposite()))).isConnected()) {
            return var4;
        }
        return 0;
    }

    protected static boolean shouldConnectTo(BlockState var0) {
        return RedStoneWireBlock.shouldConnectTo(var0, null);
    }

    protected static boolean shouldConnectTo(BlockState var0, @Nullable Direction var1) {
        if (var0.is(Blocks.REDSTONE_WIRE)) {
            return true;
        }
        if (var0.is(Blocks.REPEATER)) {
            Direction var2 = (Direction)var0.getValue(RepeaterBlock.FACING);
            return var2 == var1 || var2.getOpposite() == var1;
        }
        if (var0.is(Blocks.OBSERVER)) {
            return var1 == var0.getValue(ObserverBlock.FACING);
        }
        return var0.isSignalSource() && var1 != null;
    }

    @Override
    protected boolean isSignalSource(BlockState var0) {
        return this.shouldSignal;
    }

    public static int getColorForPower(int var0) {
        return COLORS[var0];
    }

    private static void spawnParticlesAlongLine(Level var0, RandomSource var1, BlockPos var2, int var3, Direction var4, Direction var5, float var6, float var7) {
        float var8 = var7 - var6;
        if (var1.nextFloat() >= 0.2f * var8) {
            return;
        }
        float var9 = 0.4375f;
        float var10 = var6 + var8 * var1.nextFloat();
        double var11 = 0.5 + (double)(0.4375f * (float)var4.getStepX()) + (double)(var10 * (float)var5.getStepX());
        double var13 = 0.5 + (double)(0.4375f * (float)var4.getStepY()) + (double)(var10 * (float)var5.getStepY());
        double var15 = 0.5 + (double)(0.4375f * (float)var4.getStepZ()) + (double)(var10 * (float)var5.getStepZ());
        var0.addParticle(new DustParticleOptions(var3, 1.0f), (double)var2.getX() + var11, (double)var2.getY() + var13, (double)var2.getZ() + var15, 0.0, 0.0, 0.0);
    }

    @Override
    public void animateTick(BlockState var0, Level var1, BlockPos var2, RandomSource var3) {
        int var4 = var0.getValue(POWER);
        if (var4 == 0) {
            return;
        }
        block4: for (Direction var6 : Direction.Plane.HORIZONTAL) {
            RedstoneSide var7 = (RedstoneSide)var0.getValue(PROPERTY_BY_DIRECTION.get(var6));
            switch (var7) {
                case UP: {
                    RedStoneWireBlock.spawnParticlesAlongLine(var1, var3, var2, COLORS[var4], var6, Direction.UP, -0.5f, 0.5f);
                }
                case SIDE: {
                    RedStoneWireBlock.spawnParticlesAlongLine(var1, var3, var2, COLORS[var4], Direction.DOWN, var6, 0.0f, 0.5f);
                    continue block4;
                }
            }
            RedStoneWireBlock.spawnParticlesAlongLine(var1, var3, var2, COLORS[var4], Direction.DOWN, var6, 0.0f, 0.3f);
        }
    }

    @Override
    protected BlockState rotate(BlockState var0, Rotation var1) {
        switch (var1) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(EAST, var0.getValue(WEST))).setValue(SOUTH, var0.getValue(NORTH))).setValue(WEST, var0.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)var0.setValue(NORTH, var0.getValue(EAST))).setValue(EAST, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(WEST))).setValue(WEST, var0.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)var0.setValue(NORTH, var0.getValue(WEST))).setValue(EAST, var0.getValue(NORTH))).setValue(SOUTH, var0.getValue(EAST))).setValue(WEST, var0.getValue(SOUTH));
            }
        }
        return var0;
    }

    @Override
    protected BlockState mirror(BlockState var0, Mirror var1) {
        switch (var1) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)var0.setValue(NORTH, var0.getValue(SOUTH))).setValue(SOUTH, var0.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)var0.setValue(EAST, var0.getValue(WEST))).setValue(WEST, var0.getValue(EAST));
            }
        }
        return super.mirror(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(NORTH, EAST, SOUTH, WEST, POWER);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState var0, Level var1, BlockPos var2, Player var3, BlockHitResult var4) {
        if (!var3.getAbilities().mayBuild) {
            return InteractionResult.PASS;
        }
        if (RedStoneWireBlock.isCross(var0) || RedStoneWireBlock.isDot(var0)) {
            BlockState var5 = RedStoneWireBlock.isCross(var0) ? this.defaultBlockState() : this.crossState;
            var5 = (BlockState)var5.setValue(POWER, var0.getValue(POWER));
            if ((var5 = this.getConnectionState(var1, var5, var2)) != var0) {
                var1.setBlock(var2, var5, 3);
                this.updatesOnShapeChange(var1, var2, var0, var5);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void updatesOnShapeChange(Level var0, BlockPos var1, BlockState var2, BlockState var3) {
        Orientation var4 = ExperimentalRedstoneUtils.initialOrientation(var0, null, Direction.UP);
        for (Direction var6 : Direction.Plane.HORIZONTAL) {
            BlockPos var7 = var1.relative(var6);
            if (((RedstoneSide)var2.getValue(PROPERTY_BY_DIRECTION.get(var6))).isConnected() == ((RedstoneSide)var3.getValue(PROPERTY_BY_DIRECTION.get(var6))).isConnected() || !var0.getBlockState(var7).isRedstoneConductor(var0, var7)) continue;
            var0.updateNeighborsAtExceptFromFacing(var7, var3.getBlock(), var6.getOpposite(), ExperimentalRedstoneUtils.withFront(var4, var6));
        }
    }
}

