/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.BlockHitResult;

public class RepeaterBlock
extends DiodeBlock {
    public static final MapCodec<RepeaterBlock> CODEC = RepeaterBlock.simpleCodec(RepeaterBlock::new);
    public static final BooleanProperty LOCKED = BlockStateProperties.LOCKED;
    public static final IntegerProperty DELAY = BlockStateProperties.DELAY;

    public MapCodec<RepeaterBlock> codec() {
        return CODEC;
    }

    protected RepeaterBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(DELAY, 1)).setValue(LOCKED, false)).setValue(POWERED, false));
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState var0, Level var1, BlockPos var2, Player var3, BlockHitResult var4) {
        if (!var3.getAbilities().mayBuild) {
            return InteractionResult.PASS;
        }
        var1.setBlock(var2, (BlockState)var0.cycle(DELAY), 3);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected int getDelay(BlockState var0) {
        return var0.getValue(DELAY) * 2;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        BlockState var1 = super.getStateForPlacement(var0);
        return (BlockState)var1.setValue(LOCKED, this.isLocked(var0.getLevel(), var0.getClickedPos(), var1));
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var4 == Direction.DOWN && !this.canSurviveOn(var1, var5, var6)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (!var1.isClientSide() && var4.getAxis() != ((Direction)var0.getValue(FACING)).getAxis()) {
            return (BlockState)var0.setValue(LOCKED, this.isLocked(var1, var3, var0));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    public boolean isLocked(LevelReader var0, BlockPos var1, BlockState var2) {
        return this.getAlternateSignal(var0, var1, var2) > 0;
    }

    @Override
    protected boolean sideInputDiodesOnly() {
        return true;
    }

    @Override
    public void animateTick(BlockState var0, Level var1, BlockPos var2, RandomSource var3) {
        if (!var0.getValue(POWERED).booleanValue()) {
            return;
        }
        Direction var4 = (Direction)var0.getValue(FACING);
        double var5 = (double)var2.getX() + 0.5 + (var3.nextDouble() - 0.5) * 0.2;
        double var7 = (double)var2.getY() + 0.4 + (var3.nextDouble() - 0.5) * 0.2;
        double var9 = (double)var2.getZ() + 0.5 + (var3.nextDouble() - 0.5) * 0.2;
        float var11 = -5.0f;
        if (var3.nextBoolean()) {
            var11 = var0.getValue(DELAY) * 2 - 1;
        }
        double var12 = (var11 /= 16.0f) * (float)var4.getStepX();
        double var14 = var11 * (float)var4.getStepZ();
        var1.addParticle(DustParticleOptions.REDSTONE, var5 + var12, var7, var9 + var14, 0.0, 0.0, 0.0);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(FACING, DELAY, LOCKED, POWERED);
    }
}

