/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkVeinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.SculkBloomEvent;
import org.jspecify.annotations.Nullable;

public class SculkSpreader {
    public static final int MAX_GROWTH_RATE_RADIUS = 24;
    public static final int MAX_CHARGE = 1000;
    public static final float MAX_DECAY_FACTOR = 0.5f;
    private static final int MAX_CURSORS = 32;
    public static final int SHRIEKER_PLACEMENT_RATE = 11;
    public static final int MAX_CURSOR_DISTANCE = 1024;
    final boolean isWorldGeneration;
    private final TagKey<Block> replaceableBlocks;
    private final int growthSpawnCost;
    private final int noGrowthRadius;
    private final int chargeDecayRate;
    private final int additionalDecayRate;
    private List<ChargeCursor> cursors = new ArrayList<ChargeCursor>();
    public Level level;

    public SculkSpreader(boolean flag, TagKey<Block> tagkey, int i, int j, int k, int l) {
        this.isWorldGeneration = flag;
        this.replaceableBlocks = tagkey;
        this.growthSpawnCost = i;
        this.noGrowthRadius = j;
        this.chargeDecayRate = k;
        this.additionalDecayRate = l;
    }

    public static SculkSpreader createLevelSpreader() {
        return new SculkSpreader(false, BlockTags.SCULK_REPLACEABLE, 10, 4, 10, 5);
    }

    public static SculkSpreader createWorldGenSpreader() {
        return new SculkSpreader(true, BlockTags.SCULK_REPLACEABLE_WORLD_GEN, 50, 1, 5, 10);
    }

    public TagKey<Block> replaceableBlocks() {
        return this.replaceableBlocks;
    }

    public int growthSpawnCost() {
        return this.growthSpawnCost;
    }

    public int noGrowthRadius() {
        return this.noGrowthRadius;
    }

    public int chargeDecayRate() {
        return this.chargeDecayRate;
    }

    public int additionalDecayRate() {
        return this.additionalDecayRate;
    }

    public boolean isWorldGeneration() {
        return this.isWorldGeneration;
    }

    @VisibleForTesting
    public List<ChargeCursor> getCursors() {
        return this.cursors;
    }

    public void clear() {
        this.cursors.clear();
    }

    public void load(ValueInput valueinput) {
        this.cursors.clear();
        valueinput.read("cursors", ChargeCursor.CODEC.sizeLimitedListOf(32)).orElse(List.of()).forEach(this::addCursor);
    }

    public void save(ValueOutput valueoutput) {
        valueoutput.store("cursors", ChargeCursor.CODEC.listOf(), this.cursors);
        if (SharedConstants.DEBUG_SCULK_CATALYST) {
            int i = this.getCursors().stream().map(ChargeCursor::getCharge).reduce(0, Integer::sum);
            int j = this.getCursors().stream().map(sculkspreader_a -> 1).reduce(0, Integer::sum);
            int k = this.getCursors().stream().map(ChargeCursor::getCharge).reduce(0, Math::max);
            valueoutput.putInt("stats.total", i);
            valueoutput.putInt("stats.count", j);
            valueoutput.putInt("stats.max", k);
            valueoutput.putInt("stats.avg", i / (j + 1));
        }
    }

    public void addCursors(BlockPos blockposition, int i) {
        while (i > 0) {
            int j = Math.min(i, 1000);
            this.addCursor(new ChargeCursor(blockposition, j));
            i -= j;
        }
    }

    private void addCursor(ChargeCursor sculkspreader_a) {
        if (this.cursors.size() < 32) {
            if (!this.isWorldGeneration()) {
                CraftBlock bukkitBlock = CraftBlock.at(this.level, sculkspreader_a.pos);
                SculkBloomEvent event = new SculkBloomEvent((org.bukkit.block.Block)bukkitBlock, sculkspreader_a.getCharge());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                sculkspreader_a.charge = event.getCharge();
            }
            this.cursors.add(sculkspreader_a);
        }
    }

    public void updateCursors(LevelAccessor generatoraccess, BlockPos blockposition, RandomSource randomsource, boolean flag) {
        if (!this.cursors.isEmpty()) {
            ArrayList<ChargeCursor> list = new ArrayList<ChargeCursor>();
            HashMap<BlockPos, ChargeCursor> map = new HashMap<BlockPos, ChargeCursor>();
            Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
            for (ChargeCursor sculkspreader_a : this.cursors) {
                if (sculkspreader_a.isPosUnreasonable(blockposition)) continue;
                sculkspreader_a.update(generatoraccess, blockposition, randomsource, this, flag);
                if (sculkspreader_a.charge <= 0) {
                    generatoraccess.levelEvent(3006, sculkspreader_a.getPos(), 0);
                    continue;
                }
                BlockPos blockposition1 = sculkspreader_a.getPos();
                object2intmap.computeInt((Object)blockposition1, (blockposition2, integer) -> (integer == null ? 0 : integer) + sculkspreader_a.charge);
                ChargeCursor sculkspreader_a1 = (ChargeCursor)map.get(blockposition1);
                if (sculkspreader_a1 == null) {
                    map.put(blockposition1, sculkspreader_a);
                    list.add(sculkspreader_a);
                    continue;
                }
                if (!this.isWorldGeneration() && sculkspreader_a.charge + sculkspreader_a1.charge <= 1000) {
                    sculkspreader_a1.mergeWith(sculkspreader_a);
                    continue;
                }
                list.add(sculkspreader_a);
                if (sculkspreader_a.charge >= sculkspreader_a1.charge) continue;
                map.put(blockposition1, sculkspreader_a);
            }
            for (Object2IntMap.Entry object2intmap_entry : object2intmap.object2IntEntrySet()) {
                Set<Direction> collection;
                BlockPos blockposition22 = (BlockPos)object2intmap_entry.getKey();
                int i = object2intmap_entry.getIntValue();
                ChargeCursor sculkspreader_a2 = (ChargeCursor)map.get(blockposition22);
                Set<Direction> set = collection = sculkspreader_a2 == null ? null : sculkspreader_a2.getFacingData();
                if (i <= 0 || collection == null) continue;
                int j = (int)(Math.log1p(i) / (double)2.3f) + 1;
                int k = (j << 6) + MultifaceBlock.pack(collection);
                generatoraccess.levelEvent(3006, blockposition22, k);
            }
            this.cursors = list;
        }
    }

    public static class ChargeCursor {
        private static final ObjectArrayList<Vec3i> NON_CORNER_NEIGHBOURS = Util.make(new ObjectArrayList(18), objectarraylist -> {
            Stream<BlockPos> stream = BlockPos.betweenClosedStream(new BlockPos(-1, -1, -1), new BlockPos(1, 1, 1)).filter(blockposition -> (blockposition.getX() == 0 || blockposition.getY() == 0 || blockposition.getZ() == 0) && !blockposition.equals(BlockPos.ZERO)).map(BlockPos::immutable);
            Objects.requireNonNull(objectarraylist);
            stream.forEach(arg_0 -> ((ObjectArrayList)objectarraylist).add(arg_0));
        });
        public static final int MAX_CURSOR_DECAY_DELAY = 1;
        private BlockPos pos;
        int charge;
        private int updateDelay;
        private int decayDelay;
        private @Nullable Set<Direction> facings;
        private static final Codec<Set<Direction>> DIRECTION_SET = Direction.CODEC.listOf().xmap(list -> Sets.newEnumSet((Iterable)list, Direction.class), Lists::newArrayList);
        public static final Codec<ChargeCursor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(ChargeCursor::getPos), (App)Codec.intRange((int)0, (int)1000).fieldOf("charge").orElse((Object)0).forGetter(ChargeCursor::getCharge), (App)Codec.intRange((int)0, (int)1).fieldOf("decay_delay").orElse((Object)1).forGetter(ChargeCursor::getDecayDelay), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("update_delay").orElse((Object)0).forGetter(sculkspreader_a -> sculkspreader_a.updateDelay), (App)DIRECTION_SET.lenientOptionalFieldOf("facings").forGetter(sculkspreader_a -> Optional.ofNullable(sculkspreader_a.getFacingData()))).apply((Applicative)instance, ChargeCursor::new));

        private ChargeCursor(BlockPos blockposition, int i, int j, int k, Optional<Set<Direction>> optional) {
            this.pos = blockposition;
            this.charge = i;
            this.decayDelay = j;
            this.updateDelay = k;
            this.facings = optional.orElse(null);
        }

        public ChargeCursor(BlockPos blockposition, int i) {
            this(blockposition, i, 1, 0, Optional.empty());
        }

        public BlockPos getPos() {
            return this.pos;
        }

        boolean isPosUnreasonable(BlockPos blockposition) {
            return this.pos.distChessboard(blockposition) > 1024;
        }

        public int getCharge() {
            return this.charge;
        }

        public int getDecayDelay() {
            return this.decayDelay;
        }

        public @Nullable Set<Direction> getFacingData() {
            return this.facings;
        }

        private boolean shouldUpdate(LevelAccessor generatoraccess, BlockPos blockposition, boolean flag) {
            if (this.charge <= 0) {
                return false;
            }
            if (flag) {
                return true;
            }
            if (generatoraccess instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)generatoraccess;
                return worldserver.shouldTickBlocksAt(blockposition);
            }
            return false;
        }

        public void update(LevelAccessor generatoraccess, BlockPos blockposition, RandomSource randomsource, SculkSpreader sculkspreader, boolean flag) {
            if (this.shouldUpdate(generatoraccess, blockposition, sculkspreader.isWorldGeneration)) {
                if (this.updateDelay > 0) {
                    --this.updateDelay;
                } else {
                    BlockState iblockdata = generatoraccess.getBlockState(this.pos);
                    SculkBehaviour sculkbehaviour = ChargeCursor.getBlockBehaviour(iblockdata);
                    if (flag && sculkbehaviour.attemptSpreadVein(generatoraccess, this.pos, iblockdata, this.facings, sculkspreader.isWorldGeneration())) {
                        if (sculkbehaviour.canChangeBlockStateOnSpread()) {
                            iblockdata = generatoraccess.getBlockState(this.pos);
                            sculkbehaviour = ChargeCursor.getBlockBehaviour(iblockdata);
                        }
                        generatoraccess.playSound(null, this.pos, SoundEvents.SCULK_BLOCK_SPREAD, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    this.charge = sculkbehaviour.attemptUseCharge(this, generatoraccess, blockposition, randomsource, sculkspreader, flag);
                    if (this.charge <= 0) {
                        sculkbehaviour.onDischarged(generatoraccess, iblockdata, this.pos, randomsource);
                    } else {
                        BlockPos blockposition1 = ChargeCursor.getValidMovementPos(generatoraccess, this.pos, randomsource);
                        if (blockposition1 != null) {
                            sculkbehaviour.onDischarged(generatoraccess, iblockdata, this.pos, randomsource);
                            this.pos = blockposition1.immutable();
                            if (sculkspreader.isWorldGeneration() && !this.pos.closerThan(new Vec3i(blockposition.getX(), this.pos.getY(), blockposition.getZ()), 15.0)) {
                                this.charge = 0;
                                return;
                            }
                            iblockdata = generatoraccess.getBlockState(blockposition1);
                        }
                        if (iblockdata.getBlock() instanceof SculkBehaviour) {
                            this.facings = MultifaceBlock.availableFaces(iblockdata);
                        }
                        this.decayDelay = sculkbehaviour.updateDecayDelay(this.decayDelay);
                        this.updateDelay = sculkbehaviour.getSculkSpreadDelay();
                    }
                }
            }
        }

        void mergeWith(ChargeCursor sculkspreader_a) {
            this.charge += sculkspreader_a.charge;
            sculkspreader_a.charge = 0;
            this.updateDelay = Math.min(this.updateDelay, sculkspreader_a.updateDelay);
        }

        private static SculkBehaviour getBlockBehaviour(BlockState iblockdata) {
            SculkBehaviour sculkbehaviour1;
            Block block = iblockdata.getBlock();
            SculkBehaviour sculkbehaviour = block instanceof SculkBehaviour ? (sculkbehaviour1 = (SculkBehaviour)((Object)block)) : SculkBehaviour.DEFAULT;
            return sculkbehaviour;
        }

        private static List<Vec3i> getRandomizedNonCornerNeighbourOffsets(RandomSource randomsource) {
            return Util.shuffledCopy(NON_CORNER_NEIGHBOURS, randomsource);
        }

        private static @Nullable BlockPos getValidMovementPos(LevelAccessor generatoraccess, BlockPos blockposition, RandomSource randomsource) {
            BlockPos.MutableBlockPos blockposition_mutableblockposition = blockposition.mutable();
            BlockPos.MutableBlockPos blockposition_mutableblockposition1 = blockposition.mutable();
            for (Vec3i baseblockposition : ChargeCursor.getRandomizedNonCornerNeighbourOffsets(randomsource)) {
                blockposition_mutableblockposition1.setWithOffset((Vec3i)blockposition, baseblockposition);
                BlockState iblockdata = generatoraccess.getBlockState(blockposition_mutableblockposition1);
                if (!(iblockdata.getBlock() instanceof SculkBehaviour) || !ChargeCursor.isMovementUnobstructed(generatoraccess, blockposition, blockposition_mutableblockposition1)) continue;
                blockposition_mutableblockposition.set(blockposition_mutableblockposition1);
                if (!SculkVeinBlock.hasSubstrateAccess(generatoraccess, iblockdata, blockposition_mutableblockposition1)) continue;
                break;
            }
            return blockposition_mutableblockposition.equals(blockposition) ? null : blockposition_mutableblockposition;
        }

        private static boolean isMovementUnobstructed(LevelAccessor generatoraccess, BlockPos blockposition, BlockPos blockposition1) {
            if (blockposition.distManhattan(blockposition1) == 1) {
                return true;
            }
            BlockPos blockposition2 = blockposition1.subtract(blockposition);
            Direction enumdirection = Direction.fromAxisAndDirection(Direction.Axis.X, blockposition2.getX() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE);
            Direction enumdirection1 = Direction.fromAxisAndDirection(Direction.Axis.Y, blockposition2.getY() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE);
            Direction enumdirection2 = Direction.fromAxisAndDirection(Direction.Axis.Z, blockposition2.getZ() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE);
            return blockposition2.getX() == 0 ? ChargeCursor.isUnobstructed(generatoraccess, blockposition, enumdirection1) || ChargeCursor.isUnobstructed(generatoraccess, blockposition, enumdirection2) : (blockposition2.getY() == 0 ? ChargeCursor.isUnobstructed(generatoraccess, blockposition, enumdirection) || ChargeCursor.isUnobstructed(generatoraccess, blockposition, enumdirection2) : ChargeCursor.isUnobstructed(generatoraccess, blockposition, enumdirection) || ChargeCursor.isUnobstructed(generatoraccess, blockposition, enumdirection1));
        }

        private static boolean isUnobstructed(LevelAccessor generatoraccess, BlockPos blockposition, Direction enumdirection) {
            BlockPos blockposition1 = blockposition.relative(enumdirection);
            return !generatoraccess.getBlockState(blockposition1).isFaceSturdy(generatoraccess, blockposition1, enumdirection.getOpposite());
        }
    }
}

