/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public class SeagrassBlock
extends VegetationBlock
implements BonemealableBlock,
LiquidBlockContainer {
    public static final MapCodec<SeagrassBlock> CODEC = SeagrassBlock.simpleCodec(SeagrassBlock::new);
    private static final VoxelShape SHAPE = Block.column(12.0, 0.0, 12.0);

    public MapCodec<SeagrassBlock> codec() {
        return CODEC;
    }

    protected SeagrassBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return SHAPE;
    }

    @Override
    protected boolean mayPlaceOn(BlockState var0, BlockGetter var1, BlockPos var2) {
        return var0.isFaceSturdy(var1, var2, Direction.UP) && !var0.is(Blocks.MAGMA_BLOCK);
    }

    @Override
    public @Nullable BlockState getStateForPlacement(BlockPlaceContext var0) {
        FluidState var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        if (var1.is(FluidTags.WATER) && var1.getAmount() == 8) {
            return super.getStateForPlacement(var0);
        }
        return null;
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        BlockState var8 = super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
        if (!var8.isAir()) {
            var2.scheduleTick(var3, Fluids.WATER, Fluids.WATER.getTickDelay(var1));
        }
        return var8;
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader var0, BlockPos var1, BlockState var2) {
        return var0.getBlockState(var1.above()).is(Blocks.WATER);
    }

    @Override
    public boolean isBonemealSuccess(Level var0, RandomSource var1, BlockPos var2, BlockState var3) {
        return true;
    }

    @Override
    protected FluidState getFluidState(BlockState var0) {
        return Fluids.WATER.getSource(false);
    }

    @Override
    public void performBonemeal(ServerLevel var0, RandomSource var1, BlockPos var2, BlockState var3) {
        BlockState var4 = Blocks.TALL_SEAGRASS.defaultBlockState();
        BlockState var5 = (BlockState)var4.setValue(TallSeagrassBlock.HALF, DoubleBlockHalf.UPPER);
        BlockPos var6 = var2.above();
        var0.setBlock(var2, var4, 2);
        var0.setBlock(var6, var5, 2);
    }

    @Override
    public boolean canPlaceLiquid(@Nullable LivingEntity var0, BlockGetter var1, BlockPos var2, BlockState var3, Fluid var4) {
        return false;
    }

    @Override
    public boolean placeLiquid(LevelAccessor var0, BlockPos var1, BlockState var2, FluidState var3) {
        return false;
    }
}

