/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SlimeBlock
extends HalfTransparentBlock {
    public static final MapCodec<SlimeBlock> CODEC = SlimeBlock.simpleCodec(SlimeBlock::new);

    public MapCodec<SlimeBlock> codec() {
        return CODEC;
    }

    public SlimeBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    @Override
    public void fallOn(Level var0, BlockState var1, BlockPos var2, Entity var3, double var4) {
        if (!var3.isSuppressingBounce()) {
            var3.causeFallDamage(var4, 0.0f, var0.damageSources().fall());
        }
    }

    @Override
    public void updateEntityMovementAfterFallOn(BlockGetter var0, Entity var1) {
        if (var1.isSuppressingBounce()) {
            super.updateEntityMovementAfterFallOn(var0, var1);
        } else {
            this.bounceUp(var1);
        }
    }

    private void bounceUp(Entity var0) {
        Vec3 var1 = var0.getDeltaMovement();
        if (var1.y < 0.0) {
            double var2 = var0 instanceof LivingEntity ? 1.0 : 0.8;
            var0.setDeltaMovement(var1.x, -var1.y * var2, var1.z);
        }
    }

    @Override
    public void stepOn(Level var0, BlockPos var1, BlockState var2, Entity var3) {
        double var4 = Math.abs(var3.getDeltaMovement().y);
        if (var4 < 0.1 && !var3.isSteppingCarefully()) {
            double var6 = 0.4 + var4 * 0.2;
            var3.setDeltaMovement(var3.getDeltaMovement().multiply(var6, 1.0, var6));
        }
        super.stepOn(var0, var1, var2, var3);
    }
}

