/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SporeBlossomBlock
extends Block {
    public static final MapCodec<SporeBlossomBlock> CODEC = SporeBlossomBlock.simpleCodec(SporeBlossomBlock::new);
    private static final VoxelShape SHAPE = Block.column(12.0, 13.0, 16.0);
    private static final int ADD_PARTICLE_ATTEMPTS = 14;
    private static final int PARTICLE_XZ_RADIUS = 10;
    private static final int PARTICLE_Y_MAX = 10;

    public MapCodec<SporeBlossomBlock> codec() {
        return CODEC;
    }

    public SporeBlossomBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    @Override
    protected boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        return Block.canSupportCenter(var1, var2.above(), Direction.DOWN) && !var1.isWaterAt(var2);
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var4 == Direction.UP && !this.canSurvive(var0, var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    public void animateTick(BlockState var0, Level var1, BlockPos var2, RandomSource var3) {
        int var4 = var2.getX();
        int var5 = var2.getY();
        int var6 = var2.getZ();
        double var7 = (double)var4 + var3.nextDouble();
        double var9 = (double)var5 + 0.7;
        double var11 = (double)var6 + var3.nextDouble();
        var1.addParticle(ParticleTypes.FALLING_SPORE_BLOSSOM, var7, var9, var11, 0.0, 0.0, 0.0);
        BlockPos.MutableBlockPos var13 = new BlockPos.MutableBlockPos();
        for (int var14 = 0; var14 < 14; ++var14) {
            var13.set(var4 + Mth.nextInt(var3, -10, 10), var5 - var3.nextInt(10), var6 + Mth.nextInt(var3, -10, 10));
            BlockState var15 = var1.getBlockState(var13);
            if (var15.isCollisionShapeFullBlock(var1, var13)) continue;
            var1.addParticle(ParticleTypes.SPORE_BLOSSOM_AIR, (double)var13.getX() + var3.nextDouble(), (double)var13.getY() + var3.nextDouble(), (double)var13.getZ() + var3.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return SHAPE;
    }
}

