/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TallGrassBlock
extends VegetationBlock
implements BonemealableBlock {
    public static final MapCodec<TallGrassBlock> CODEC = TallGrassBlock.simpleCodec(TallGrassBlock::new);
    private static final VoxelShape SHAPE = Block.column(12.0, 0.0, 13.0);

    public MapCodec<TallGrassBlock> codec() {
        return CODEC;
    }

    protected TallGrassBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return SHAPE;
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader var0, BlockPos var1, BlockState var2) {
        return TallGrassBlock.getGrownBlock(var2).defaultBlockState().canSurvive(var0, var1) && var0.isEmptyBlock(var1.above());
    }

    @Override
    public boolean isBonemealSuccess(Level var0, RandomSource var1, BlockPos var2, BlockState var3) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel var0, RandomSource var1, BlockPos var2, BlockState var3) {
        DoublePlantBlock.placeAt(var0, TallGrassBlock.getGrownBlock(var3).defaultBlockState(), var2, 2);
    }

    private static DoublePlantBlock getGrownBlock(BlockState var0) {
        return (DoublePlantBlock)(var0.is(Blocks.FERN) ? Blocks.LARGE_FERN : Blocks.TALL_GRASS);
    }
}

