/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jspecify.annotations.Nullable;

public class TestInstanceBlock
extends BaseEntityBlock
implements GameMasterBlock {
    public static final MapCodec<TestInstanceBlock> CODEC = TestInstanceBlock.simpleCodec(TestInstanceBlock::new);

    public TestInstanceBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    @Override
    public @Nullable BlockEntity newBlockEntity(BlockPos var0, BlockState var1) {
        return new TestInstanceBlockEntity(var0, var1);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState var0, Level var1, BlockPos var2, Player var3, BlockHitResult var4) {
        BlockEntity var5 = var1.getBlockEntity(var2);
        if (!(var5 instanceof TestInstanceBlockEntity)) {
            return InteractionResult.PASS;
        }
        TestInstanceBlockEntity var6 = (TestInstanceBlockEntity)var5;
        if (!var3.canUseGameMasterBlocks()) {
            return InteractionResult.PASS;
        }
        if (var3.level().isClientSide()) {
            var3.openTestInstanceBlock(var6);
        }
        return InteractionResult.SUCCESS;
    }

    protected MapCodec<TestInstanceBlock> codec() {
        return CODEC;
    }
}

