/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.base.MoreObjects;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TripWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.jspecify.annotations.Nullable;

public class TripWireHookBlock
extends Block {
    public static final MapCodec<TripWireHookBlock> CODEC = TripWireHookBlock.simpleCodec(TripWireHookBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty ATTACHED = BlockStateProperties.ATTACHED;
    protected static final int WIRE_DIST_MIN = 1;
    protected static final int WIRE_DIST_MAX = 42;
    private static final int RECHECK_PERIOD = 10;
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateHorizontal(Block.boxZ(6.0, 0.0, 10.0, 10.0, 16.0));

    public MapCodec<TripWireHookBlock> codec() {
        return CODEC;
    }

    public TripWireHookBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(POWERED, false)).setValue(ATTACHED, false));
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPES.get(iblockdata.getValue(FACING));
    }

    @Override
    protected boolean canSurvive(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        Direction enumdirection = iblockdata.getValue(FACING);
        BlockPos blockposition1 = blockposition.relative(enumdirection.getOpposite());
        BlockState iblockdata1 = iworldreader.getBlockState(blockposition1);
        return enumdirection.getAxis().isHorizontal() && iblockdata1.isFaceSturdy(iworldreader, blockposition1, enumdirection);
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        return enumdirection.getOpposite() == iblockdata.getValue(FACING) && !iblockdata.canSurvive(iworldreader, blockposition) ? Blocks.AIR.defaultBlockState() : super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    public @Nullable BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        Direction[] aenumdirection;
        BlockState iblockdata = (BlockState)((BlockState)this.defaultBlockState().setValue(POWERED, false)).setValue(ATTACHED, false);
        Level iworldreader = blockactioncontext.getLevel();
        BlockPos blockposition = blockactioncontext.getClickedPos();
        for (Direction enumdirection : aenumdirection = blockactioncontext.getNearestLookingDirections()) {
            Direction enumdirection1;
            if (!enumdirection.getAxis().isHorizontal() || !(iblockdata = (BlockState)iblockdata.setValue(FACING, enumdirection1 = enumdirection.getOpposite())).canSurvive(iworldreader, blockposition)) continue;
            return iblockdata;
        }
        return null;
    }

    @Override
    public void setPlacedBy(Level world, BlockPos blockposition, BlockState iblockdata, @Nullable LivingEntity entityliving, ItemStack itemstack) {
        TripWireHookBlock.calculateState(world, blockposition, iblockdata, false, false, -1, null);
    }

    public static void calculateState(Level world, BlockPos blockposition, BlockState iblockdata, boolean flag, boolean flag1, int i, @Nullable BlockState iblockdata1) {
        Optional<Direction> optional = iblockdata.getOptionalValue(FACING);
        if (optional.isPresent()) {
            Direction enumdirection = optional.get();
            boolean flag2 = iblockdata.getOptionalValue(ATTACHED).orElse(false);
            boolean flag3 = iblockdata.getOptionalValue(POWERED).orElse(false);
            Block block = iblockdata.getBlock();
            boolean flag4 = !flag;
            boolean flag5 = false;
            int j = 0;
            BlockState[] aiblockdata = new BlockState[42];
            for (int k = 1; k < 42; ++k) {
                BlockPos blockposition1 = blockposition.relative(enumdirection, k);
                BlockState iblockdata2 = world.getBlockState(blockposition1);
                if (iblockdata2.is(Blocks.TRIPWIRE_HOOK)) {
                    if (iblockdata2.getValue(FACING) != enumdirection.getOpposite()) break;
                    j = k;
                    break;
                }
                if (!iblockdata2.is(Blocks.TRIPWIRE) && k != i) {
                    aiblockdata[k] = null;
                    flag4 = false;
                    continue;
                }
                if (k == i) {
                    iblockdata2 = (BlockState)MoreObjects.firstNonNull((Object)iblockdata1, (Object)iblockdata2);
                }
                boolean flag6 = iblockdata2.getValue(TripWireBlock.DISARMED) == false;
                boolean flag7 = iblockdata2.getValue(TripWireBlock.POWERED);
                flag5 |= flag6 && flag7;
                aiblockdata[k] = iblockdata2;
                if (k != i) continue;
                world.scheduleTick(blockposition, block, 10);
                flag4 &= flag6;
            }
            BlockState iblockdata3 = (BlockState)((BlockState)block.defaultBlockState().trySetValue(ATTACHED, flag4)).trySetValue(POWERED, flag5 &= (flag4 &= j > 1));
            if (j > 0) {
                BlockPos blockposition2 = blockposition.relative(enumdirection, j);
                Direction enumdirection1 = enumdirection.getOpposite();
                world.setBlock(blockposition2, (BlockState)iblockdata3.setValue(FACING, enumdirection1), 3);
                TripWireHookBlock.notifyNeighbors(block, world, blockposition2, enumdirection1);
                TripWireHookBlock.emitState(world, blockposition2, flag4, flag5, flag2, flag3);
            }
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), 15, 0);
            world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
            if (eventRedstone.getNewCurrent() > 0) {
                return;
            }
            TripWireHookBlock.emitState(world, blockposition, flag4, flag5, flag2, flag3);
            if (!flag) {
                world.setBlock(blockposition, (BlockState)iblockdata3.setValue(FACING, enumdirection), 3);
                if (flag1) {
                    TripWireHookBlock.notifyNeighbors(block, world, blockposition, enumdirection);
                }
            }
            if (flag2 != flag4) {
                for (int l = 1; l < j; ++l) {
                    BlockState iblockdata5;
                    BlockPos blockposition3 = blockposition.relative(enumdirection, l);
                    BlockState iblockdata4 = aiblockdata[l];
                    if (iblockdata4 == null || !(iblockdata5 = world.getBlockState(blockposition3)).is(Blocks.TRIPWIRE) && !iblockdata5.is(Blocks.TRIPWIRE_HOOK)) continue;
                    world.setBlock(blockposition3, (BlockState)iblockdata4.trySetValue(ATTACHED, flag4), 3);
                }
            }
        }
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        TripWireHookBlock.calculateState(worldserver, blockposition, iblockdata, false, true, -1, null);
    }

    private static void emitState(Level world, BlockPos blockposition, boolean flag, boolean flag1, boolean flag2, boolean flag3) {
        if (flag1 && !flag3) {
            world.playSound((Entity)null, blockposition, SoundEvents.TRIPWIRE_CLICK_ON, SoundSource.BLOCKS, 0.4f, 0.6f);
            world.gameEvent((Entity)null, GameEvent.BLOCK_ACTIVATE, blockposition);
        } else if (!flag1 && flag3) {
            world.playSound((Entity)null, blockposition, SoundEvents.TRIPWIRE_CLICK_OFF, SoundSource.BLOCKS, 0.4f, 0.5f);
            world.gameEvent((Entity)null, GameEvent.BLOCK_DEACTIVATE, blockposition);
        } else if (flag && !flag2) {
            world.playSound((Entity)null, blockposition, SoundEvents.TRIPWIRE_ATTACH, SoundSource.BLOCKS, 0.4f, 0.7f);
            world.gameEvent((Entity)null, GameEvent.BLOCK_ATTACH, blockposition);
        } else if (!flag && flag2) {
            world.playSound((Entity)null, blockposition, SoundEvents.TRIPWIRE_DETACH, SoundSource.BLOCKS, 0.4f, 1.2f / (world.random.nextFloat() * 0.2f + 0.9f));
            world.gameEvent((Entity)null, GameEvent.BLOCK_DETACH, blockposition);
        }
    }

    private static void notifyNeighbors(Block block, Level world, BlockPos blockposition, Direction enumdirection) {
        Direction enumdirection1 = enumdirection.getOpposite();
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation(world, enumdirection1, Direction.UP);
        world.updateNeighborsAt(blockposition, block, orientation);
        world.updateNeighborsAt(blockposition.relative(enumdirection1), block, orientation);
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, boolean flag) {
        if (!flag) {
            boolean flag1 = iblockdata.getValue(ATTACHED);
            boolean flag2 = iblockdata.getValue(POWERED);
            if (flag1 || flag2) {
                TripWireHookBlock.calculateState(worldserver, blockposition, iblockdata, true, false, -1, null);
            }
            if (flag2) {
                TripWireHookBlock.notifyNeighbors(this, worldserver, blockposition, iblockdata.getValue(FACING));
            }
        }
    }

    @Override
    protected int getSignal(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return iblockdata.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected int getDirectSignal(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return iblockdata.getValue(POWERED) == false ? 0 : (iblockdata.getValue(FACING) == enumdirection ? 15 : 0);
    }

    @Override
    protected boolean isSignalSource(BlockState iblockdata) {
        return true;
    }

    @Override
    protected BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        return (BlockState)iblockdata.setValue(FACING, enumblockrotation.rotate(iblockdata.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState iblockdata, Mirror enumblockmirror) {
        return iblockdata.rotate(enumblockmirror.getRotation(iblockdata.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(FACING, POWERED, ATTACHED);
    }
}

