/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.jspecify.annotations.Nullable;

public class VineBlock
extends Block {
    public static final MapCodec<VineBlock> CODEC = VineBlock.simpleCodec(VineBlock::new);
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(entry -> entry.getKey() != Direction.DOWN).collect(Util.toMap());
    private final Function<BlockState, VoxelShape> shapes;

    public MapCodec<VineBlock> codec() {
        return CODEC;
    }

    public VineBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(UP, false)).setValue(NORTH, false)).setValue(EAST, false)).setValue(SOUTH, false)).setValue(WEST, false));
        this.shapes = this.makeShapes();
    }

    private Function<BlockState, VoxelShape> makeShapes() {
        Map<Direction, VoxelShape> map = Shapes.rotateAll(Block.boxZ(16.0, 0.0, 1.0));
        return this.getShapeForEachState(iblockdata -> {
            VoxelShape voxelshape = Shapes.empty();
            for (Map.Entry<Direction, BooleanProperty> map_entry : PROPERTY_BY_DIRECTION.entrySet()) {
                if (!((Boolean)iblockdata.getValue(map_entry.getValue())).booleanValue()) continue;
                voxelshape = Shapes.or(voxelshape, (VoxelShape)map.get(map_entry.getKey()));
            }
            return voxelshape.isEmpty() ? Shapes.block() : voxelshape;
        });
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return this.shapes.apply(iblockdata);
    }

    @Override
    protected boolean propagatesSkylightDown(BlockState iblockdata) {
        return true;
    }

    @Override
    protected boolean canSurvive(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        return this.hasFaces(this.getUpdatedState(iblockdata, iworldreader, blockposition));
    }

    private boolean hasFaces(BlockState iblockdata) {
        return this.countFaces(iblockdata) > 0;
    }

    private int countFaces(BlockState iblockdata) {
        int i = 0;
        for (BooleanProperty blockstateboolean : PROPERTY_BY_DIRECTION.values()) {
            if (!iblockdata.getValue(blockstateboolean).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean canSupportAtFace(BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        if (enumdirection == Direction.DOWN) {
            return false;
        }
        BlockPos blockposition1 = blockposition.relative(enumdirection);
        if (VineBlock.isAcceptableNeighbour(iblockaccess, blockposition1, enumdirection)) {
            return true;
        }
        if (enumdirection.getAxis() == Direction.Axis.Y) {
            return false;
        }
        BooleanProperty blockstateboolean = PROPERTY_BY_DIRECTION.get(enumdirection);
        BlockState iblockdata = iblockaccess.getBlockState(blockposition.above());
        return iblockdata.is(this) && iblockdata.getValue(blockstateboolean) != false;
    }

    public static boolean isAcceptableNeighbour(BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return MultifaceBlock.canAttachTo(iblockaccess, enumdirection, blockposition, iblockaccess.getBlockState(blockposition));
    }

    private BlockState getUpdatedState(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition) {
        BlockPos blockposition1 = blockposition.above();
        if (iblockdata.getValue(UP).booleanValue()) {
            iblockdata = (BlockState)iblockdata.setValue(UP, VineBlock.isAcceptableNeighbour(iblockaccess, blockposition1, Direction.DOWN));
        }
        BlockBehaviour.BlockStateBase iblockdata1 = null;
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            BooleanProperty blockstateboolean = VineBlock.getPropertyForFace(enumdirection);
            if (!iblockdata.getValue(blockstateboolean).booleanValue()) continue;
            boolean flag = this.canSupportAtFace(iblockaccess, blockposition, enumdirection);
            if (!flag) {
                if (iblockdata1 == null) {
                    iblockdata1 = iblockaccess.getBlockState(blockposition1);
                }
                flag = iblockdata1.is(this) && iblockdata1.getValue(blockstateboolean) != false;
            }
            iblockdata = (BlockState)iblockdata.setValue(blockstateboolean, flag);
        }
        return iblockdata;
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        if (enumdirection == Direction.DOWN) {
            return super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
        }
        BlockState iblockdata2 = this.getUpdatedState(iblockdata, iworldreader, blockposition);
        return !this.hasFaces(iblockdata2) ? Blocks.AIR.defaultBlockState() : iblockdata2;
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (worldserver.getGameRules().get(GameRules.SPREAD_VINES).booleanValue() && randomsource.nextFloat() < (float)worldserver.spigotConfig.vineModifier / 400.0f) {
            Direction enumdirection = Direction.getRandom(randomsource);
            BlockPos blockposition1 = blockposition.above();
            if (enumdirection.getAxis().isHorizontal() && !iblockdata.getValue(VineBlock.getPropertyForFace(enumdirection)).booleanValue()) {
                if (this.canSpread(worldserver, blockposition)) {
                    BlockPos blockposition2 = blockposition.relative(enumdirection);
                    BlockState iblockdata1 = worldserver.getBlockState(blockposition2);
                    if (iblockdata1.isAir()) {
                        Direction enumdirection1 = enumdirection.getClockWise();
                        Direction enumdirection2 = enumdirection.getCounterClockWise();
                        boolean flag = iblockdata.getValue(VineBlock.getPropertyForFace(enumdirection1));
                        boolean flag1 = iblockdata.getValue(VineBlock.getPropertyForFace(enumdirection2));
                        BlockPos blockposition3 = blockposition2.relative(enumdirection1);
                        BlockPos blockposition4 = blockposition2.relative(enumdirection2);
                        BlockPos source = blockposition;
                        if (flag && VineBlock.isAcceptableNeighbour(worldserver, blockposition3, enumdirection1)) {
                            CraftEventFactory.handleBlockSpreadEvent(worldserver, source, blockposition2, (BlockState)this.defaultBlockState().setValue(VineBlock.getPropertyForFace(enumdirection1), true), 2);
                        } else if (flag1 && VineBlock.isAcceptableNeighbour(worldserver, blockposition4, enumdirection2)) {
                            CraftEventFactory.handleBlockSpreadEvent(worldserver, source, blockposition2, (BlockState)this.defaultBlockState().setValue(VineBlock.getPropertyForFace(enumdirection2), true), 2);
                        } else {
                            Direction enumdirection3 = enumdirection.getOpposite();
                            if (flag && worldserver.isEmptyBlock(blockposition3) && VineBlock.isAcceptableNeighbour(worldserver, blockposition.relative(enumdirection1), enumdirection3)) {
                                CraftEventFactory.handleBlockSpreadEvent(worldserver, source, blockposition3, (BlockState)this.defaultBlockState().setValue(VineBlock.getPropertyForFace(enumdirection3), true), 2);
                            } else if (flag1 && worldserver.isEmptyBlock(blockposition4) && VineBlock.isAcceptableNeighbour(worldserver, blockposition.relative(enumdirection2), enumdirection3)) {
                                CraftEventFactory.handleBlockSpreadEvent(worldserver, source, blockposition4, (BlockState)this.defaultBlockState().setValue(VineBlock.getPropertyForFace(enumdirection3), true), 2);
                            } else if ((double)randomsource.nextFloat() < 0.05 && VineBlock.isAcceptableNeighbour(worldserver, blockposition2.above(), Direction.UP)) {
                                CraftEventFactory.handleBlockSpreadEvent(worldserver, source, blockposition2, (BlockState)this.defaultBlockState().setValue(UP, true), 2);
                            }
                        }
                    } else if (VineBlock.isAcceptableNeighbour(worldserver, blockposition2, enumdirection)) {
                        CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, (BlockState)iblockdata.setValue(VineBlock.getPropertyForFace(enumdirection), true), 2);
                    }
                }
            } else {
                BlockState iblockdata5;
                BlockState iblockdata4;
                BlockPos blockposition5;
                BlockState iblockdata3;
                if (enumdirection == Direction.UP && blockposition.getY() < worldserver.getMaxY()) {
                    if (this.canSupportAtFace(worldserver, blockposition, enumdirection)) {
                        CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, (BlockState)iblockdata.setValue(UP, true), 2);
                        return;
                    }
                    if (worldserver.isEmptyBlock(blockposition1)) {
                        if (!this.canSpread(worldserver, blockposition)) {
                            return;
                        }
                        BlockState iblockdata2 = iblockdata;
                        for (Direction enumdirection4 : Direction.Plane.HORIZONTAL) {
                            if (!randomsource.nextBoolean() && VineBlock.isAcceptableNeighbour(worldserver, blockposition1.relative(enumdirection4), enumdirection4)) continue;
                            iblockdata2 = (BlockState)iblockdata2.setValue(VineBlock.getPropertyForFace(enumdirection4), false);
                        }
                        if (this.hasHorizontalConnection(iblockdata2)) {
                            CraftEventFactory.handleBlockSpreadEvent(worldserver, blockposition, blockposition1, iblockdata2, 2);
                        }
                        return;
                    }
                }
                if (blockposition.getY() > worldserver.getMinY() && ((iblockdata3 = worldserver.getBlockState(blockposition5 = blockposition.below())).isAir() || iblockdata3.is(this)) && (iblockdata4 = iblockdata3.isAir() ? this.defaultBlockState() : iblockdata3) != (iblockdata5 = this.copyRandomFaces(iblockdata, iblockdata4, randomsource)) && this.hasHorizontalConnection(iblockdata5)) {
                    CraftEventFactory.handleBlockSpreadEvent(worldserver, blockposition, blockposition5, iblockdata5, 2);
                }
            }
        }
    }

    private BlockState copyRandomFaces(BlockState iblockdata, BlockState iblockdata1, RandomSource randomsource) {
        for (Direction enumdirection : Direction.Plane.HORIZONTAL) {
            BooleanProperty blockstateboolean;
            if (!randomsource.nextBoolean() || !iblockdata.getValue(blockstateboolean = VineBlock.getPropertyForFace(enumdirection)).booleanValue()) continue;
            iblockdata1 = (BlockState)iblockdata1.setValue(blockstateboolean, true);
        }
        return iblockdata1;
    }

    private boolean hasHorizontalConnection(BlockState iblockdata) {
        return iblockdata.getValue(NORTH) != false || iblockdata.getValue(EAST) != false || iblockdata.getValue(SOUTH) != false || iblockdata.getValue(WEST) != false;
    }

    private boolean canSpread(BlockGetter iblockaccess, BlockPos blockposition) {
        int i = 4;
        Iterable<BlockPos> iterable = BlockPos.betweenClosed(blockposition.getX() - 4, blockposition.getY() - 1, blockposition.getZ() - 4, blockposition.getX() + 4, blockposition.getY() + 1, blockposition.getZ() + 4);
        int j = 5;
        for (BlockPos blockposition1 : iterable) {
            if (!iblockaccess.getBlockState(blockposition1).is(this) || --j > 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean canBeReplaced(BlockState iblockdata, BlockPlaceContext blockactioncontext) {
        BlockState iblockdata1 = blockactioncontext.getLevel().getBlockState(blockactioncontext.getClickedPos());
        return iblockdata1.is(this) ? this.countFaces(iblockdata1) < PROPERTY_BY_DIRECTION.size() : super.canBeReplaced(iblockdata, blockactioncontext);
    }

    @Override
    public @Nullable BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        BlockState iblockdata = blockactioncontext.getLevel().getBlockState(blockactioncontext.getClickedPos());
        boolean flag = iblockdata.is(this);
        BlockState iblockdata1 = flag ? iblockdata : this.defaultBlockState();
        for (Direction enumdirection : blockactioncontext.getNearestLookingDirections()) {
            boolean flag1;
            if (enumdirection == Direction.DOWN) continue;
            BooleanProperty blockstateboolean = VineBlock.getPropertyForFace(enumdirection);
            boolean bl = flag1 = flag && iblockdata.getValue(blockstateboolean) != false;
            if (flag1 || !this.canSupportAtFace(blockactioncontext.getLevel(), blockactioncontext.getClickedPos(), enumdirection)) continue;
            return (BlockState)iblockdata1.setValue(blockstateboolean, true);
        }
        return flag ? iblockdata1 : null;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(UP, NORTH, EAST, SOUTH, WEST);
    }

    @Override
    protected BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        switch (enumblockrotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)iblockdata.setValue(NORTH, iblockdata.getValue(SOUTH))).setValue(EAST, iblockdata.getValue(WEST))).setValue(SOUTH, iblockdata.getValue(NORTH))).setValue(WEST, iblockdata.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)iblockdata.setValue(NORTH, iblockdata.getValue(EAST))).setValue(EAST, iblockdata.getValue(SOUTH))).setValue(SOUTH, iblockdata.getValue(WEST))).setValue(WEST, iblockdata.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)iblockdata.setValue(NORTH, iblockdata.getValue(WEST))).setValue(EAST, iblockdata.getValue(NORTH))).setValue(SOUTH, iblockdata.getValue(EAST))).setValue(WEST, iblockdata.getValue(SOUTH));
            }
        }
        return iblockdata;
    }

    @Override
    protected BlockState mirror(BlockState iblockdata, Mirror enumblockmirror) {
        switch (enumblockmirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)iblockdata.setValue(NORTH, iblockdata.getValue(SOUTH))).setValue(SOUTH, iblockdata.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)iblockdata.setValue(EAST, iblockdata.getValue(WEST))).setValue(WEST, iblockdata.getValue(EAST));
            }
        }
        return super.mirror(iblockdata, enumblockmirror);
    }

    public static BooleanProperty getPropertyForFace(Direction enumdirection) {
        return PROPERTY_BY_DIRECTION.get(enumdirection);
    }
}

