/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallBannerBlock
extends AbstractBannerBlock {
    public static final MapCodec<WallBannerBlock> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)DyeColor.CODEC.fieldOf("color").forGetter(AbstractBannerBlock::getColor), WallBannerBlock.propertiesCodec()).apply((Applicative)var0, WallBannerBlock::new));
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateHorizontal(Block.boxZ(16.0, 0.0, 12.5, 14.0, 16.0));

    public MapCodec<WallBannerBlock> codec() {
        return CODEC;
    }

    public WallBannerBlock(DyeColor var0, BlockBehaviour.Properties var1) {
        super(var0, var1);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH));
    }

    @Override
    protected boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        return var1.getBlockState(var2.relative(var0.getValue(FACING).getOpposite())).isSolid();
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var4 == var0.getValue(FACING).getOpposite() && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return SHAPES.get(var0.getValue(FACING));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        Direction[] var4;
        BlockState var1 = this.defaultBlockState();
        Level var2 = var0.getLevel();
        BlockPos var3 = var0.getClickedPos();
        for (Direction var8 : var4 = var0.getNearestLookingDirections()) {
            Direction var9;
            if (!var8.getAxis().isHorizontal() || !(var1 = (BlockState)var1.setValue(FACING, var9 = var8.getOpposite())).canSurvive(var2, var3)) continue;
            return var1;
        }
        return null;
    }

    @Override
    protected BlockState rotate(BlockState var0, Rotation var1) {
        return (BlockState)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState var0, Mirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(FACING);
    }
}

