/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.Nullable;

public abstract class AbstractFurnaceBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeCraftingHolder,
StackedContentsCompatible {
    protected static final int SLOT_INPUT = 0;
    protected static final int SLOT_FUEL = 1;
    protected static final int SLOT_RESULT = 2;
    public static final int DATA_LIT_TIME = 0;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{2, 1};
    private static final int[] SLOTS_FOR_SIDES = new int[]{1};
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;
    private static final Codec<Map<ResourceKey<Recipe<?>>, Integer>> RECIPES_USED_CODEC = Codec.unboundedMap(Recipe.KEY_CODEC, (Codec)Codec.INT);
    private static final short DEFAULT_COOKING_TIMER = 0;
    private static final short DEFAULT_COOKING_TOTAL_TIME = 0;
    private static final short DEFAULT_LIT_TIME_REMAINING = 0;
    private static final short DEFAULT_LIT_TOTAL_TIME = 0;
    protected NonNullList<net.minecraft.world.item.ItemStack> items;
    public int litTimeRemaining;
    int litTotalTime;
    public int cookingTimer;
    public int cookingTotalTime;
    protected final ContainerData dataAccess;
    public final Reference2IntOpenHashMap<ResourceKey<Recipe<?>>> recipesUsed;
    private final RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> quickCheck;
    private int maxStack = 99;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    protected AbstractFurnaceBlockEntity(BlockEntityType<?> tileentitytypes, BlockPos blockposition, BlockState iblockdata, RecipeType<? extends AbstractCookingRecipe> recipes) {
        super(tileentitytypes, blockposition, iblockdata);
        this.items = NonNullList.withSize(3, net.minecraft.world.item.ItemStack.EMPTY);
        this.dataAccess = new ContainerData(){

            @Override
            public int get(int i) {
                switch (i) {
                    case 0: {
                        return AbstractFurnaceBlockEntity.this.litTimeRemaining;
                    }
                    case 1: {
                        return AbstractFurnaceBlockEntity.this.litTotalTime;
                    }
                    case 2: {
                        return AbstractFurnaceBlockEntity.this.cookingTimer;
                    }
                    case 3: {
                        return AbstractFurnaceBlockEntity.this.cookingTotalTime;
                    }
                }
                return 0;
            }

            @Override
            public void set(int i, int j) {
                switch (i) {
                    case 0: {
                        AbstractFurnaceBlockEntity.this.litTimeRemaining = j;
                        break;
                    }
                    case 1: {
                        AbstractFurnaceBlockEntity.this.litTotalTime = j;
                        break;
                    }
                    case 2: {
                        AbstractFurnaceBlockEntity.this.cookingTimer = j;
                        break;
                    }
                    case 3: {
                        AbstractFurnaceBlockEntity.this.cookingTotalTime = j;
                    }
                }
            }

            @Override
            public int getCount() {
                return 4;
            }
        };
        this.recipesUsed = new Reference2IntOpenHashMap();
        this.quickCheck = RecipeManager.createCheck(recipes);
    }

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.items;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    private boolean isLit() {
        return this.litTimeRemaining > 0;
    }

    @Override
    protected void loadAdditional(ValueInput valueinput) {
        super.loadAdditional(valueinput);
        this.items = NonNullList.withSize(this.getContainerSize(), net.minecraft.world.item.ItemStack.EMPTY);
        ContainerHelper.loadAllItems(valueinput, this.items);
        this.cookingTimer = valueinput.getShortOr("cooking_time_spent", (short)0);
        this.cookingTotalTime = valueinput.getShortOr("cooking_total_time", (short)0);
        this.litTimeRemaining = valueinput.getShortOr("lit_time_remaining", (short)0);
        this.litTotalTime = valueinput.getShortOr("lit_total_time", (short)0);
        this.recipesUsed.clear();
        this.recipesUsed.putAll(valueinput.read("RecipesUsed", RECIPES_USED_CODEC).orElse(Map.of()));
    }

    @Override
    protected void saveAdditional(ValueOutput valueoutput) {
        super.saveAdditional(valueoutput);
        valueoutput.putShort("cooking_time_spent", (short)this.cookingTimer);
        valueoutput.putShort("cooking_total_time", (short)this.cookingTotalTime);
        valueoutput.putShort("lit_time_remaining", (short)this.litTimeRemaining);
        valueoutput.putShort("lit_total_time", (short)this.litTotalTime);
        ContainerHelper.saveAllItems(valueoutput, this.items);
        valueoutput.store("RecipesUsed", RECIPES_USED_CODEC, this.recipesUsed);
    }

    public static void serverTick(ServerLevel worldserver, BlockPos blockposition, BlockState iblockdata, AbstractFurnaceBlockEntity tileentityfurnace) {
        boolean flag3;
        boolean flag = tileentityfurnace.isLit();
        boolean flag1 = false;
        if (tileentityfurnace.isLit()) {
            --tileentityfurnace.litTimeRemaining;
        }
        net.minecraft.world.item.ItemStack itemstack = tileentityfurnace.items.get(1);
        net.minecraft.world.item.ItemStack itemstack1 = tileentityfurnace.items.get(0);
        boolean flag2 = !itemstack1.isEmpty();
        boolean bl = flag3 = !itemstack.isEmpty();
        if (tileentityfurnace.isLit() || flag3 && flag2) {
            SingleRecipeInput singlerecipeinput = new SingleRecipeInput(itemstack1);
            RecipeHolder recipeholder = flag2 ? (RecipeHolder)tileentityfurnace.quickCheck.getRecipeFor(singlerecipeinput, worldserver).orElse(null) : null;
            int i = tileentityfurnace.getMaxStackSize();
            if (!tileentityfurnace.isLit() && AbstractFurnaceBlockEntity.canBurn(worldserver.registryAccess(), recipeholder, singlerecipeinput, tileentityfurnace.items, i)) {
                CraftItemStack fuel = CraftItemStack.asCraftMirror(itemstack);
                FurnaceBurnEvent furnaceBurnEvent = new FurnaceBurnEvent((Block)CraftBlock.at(worldserver, blockposition), (ItemStack)fuel, tileentityfurnace.getBurnDuration(worldserver.fuelValues(), itemstack));
                worldserver.getCraftServer().getPluginManager().callEvent((Event)furnaceBurnEvent);
                if (furnaceBurnEvent.isCancelled()) {
                    return;
                }
                tileentityfurnace.litTotalTime = tileentityfurnace.litTimeRemaining = furnaceBurnEvent.getBurnTime();
                if (tileentityfurnace.isLit() && furnaceBurnEvent.isBurning()) {
                    flag1 = true;
                    if (flag3) {
                        Item item = itemstack.getItem();
                        itemstack.shrink(1);
                        if (itemstack.isEmpty()) {
                            tileentityfurnace.items.set(1, item.getCraftingRemainder());
                        }
                    }
                }
            }
            if (tileentityfurnace.isLit() && AbstractFurnaceBlockEntity.canBurn(worldserver.registryAccess(), recipeholder, singlerecipeinput, tileentityfurnace.items, i)) {
                if (recipeholder != null && tileentityfurnace.cookingTimer == 0) {
                    CraftItemStack source = CraftItemStack.asCraftMirror(tileentityfurnace.items.get(0));
                    CookingRecipe recipe = (CookingRecipe)recipeholder.toBukkitRecipe();
                    FurnaceStartSmeltEvent event = new FurnaceStartSmeltEvent((Block)CraftBlock.at(worldserver, blockposition), (ItemStack)source, recipe);
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                    tileentityfurnace.cookingTotalTime = event.getTotalCookTime();
                }
                ++tileentityfurnace.cookingTimer;
                if (tileentityfurnace.cookingTimer == tileentityfurnace.cookingTotalTime) {
                    tileentityfurnace.cookingTimer = 0;
                    tileentityfurnace.cookingTotalTime = AbstractFurnaceBlockEntity.getTotalCookTime(worldserver, tileentityfurnace);
                    if (AbstractFurnaceBlockEntity.burn(tileentityfurnace.level, tileentityfurnace.worldPosition, worldserver.registryAccess(), recipeholder, singlerecipeinput, tileentityfurnace.items, i)) {
                        tileentityfurnace.setRecipeUsed(recipeholder);
                    }
                    flag1 = true;
                }
            } else {
                tileentityfurnace.cookingTimer = 0;
            }
        } else if (!tileentityfurnace.isLit() && tileentityfurnace.cookingTimer > 0) {
            tileentityfurnace.cookingTimer = Mth.clamp(tileentityfurnace.cookingTimer - 2, 0, tileentityfurnace.cookingTotalTime);
        }
        if (flag != tileentityfurnace.isLit()) {
            flag1 = true;
            iblockdata = (BlockState)iblockdata.setValue(AbstractFurnaceBlock.LIT, tileentityfurnace.isLit());
            worldserver.setBlock(blockposition, iblockdata, 3);
        }
        if (flag1) {
            AbstractFurnaceBlockEntity.setChanged(worldserver, blockposition, iblockdata);
        }
    }

    private static boolean canBurn(RegistryAccess iregistrycustom, @Nullable RecipeHolder<? extends AbstractCookingRecipe> recipeholder, SingleRecipeInput singlerecipeinput, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist, int i) {
        if (!nonnulllist.get(0).isEmpty() && recipeholder != null) {
            net.minecraft.world.item.ItemStack itemstack = recipeholder.value().assemble(singlerecipeinput, (HolderLookup.Provider)iregistrycustom);
            if (itemstack.isEmpty()) {
                return false;
            }
            net.minecraft.world.item.ItemStack itemstack1 = nonnulllist.get(2);
            return itemstack1.isEmpty() ? true : (!net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemstack1, itemstack) ? false : (itemstack1.getCount() < i && itemstack1.getCount() < itemstack1.getMaxStackSize() ? true : itemstack1.getCount() < itemstack.getMaxStackSize()));
        }
        return false;
    }

    private static boolean burn(Level world, BlockPos blockposition, RegistryAccess iregistrycustom, @Nullable RecipeHolder<? extends AbstractCookingRecipe> recipeholder, SingleRecipeInput singlerecipeinput, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist, int i) {
        if (recipeholder != null && AbstractFurnaceBlockEntity.canBurn(iregistrycustom, recipeholder, singlerecipeinput, nonnulllist, i)) {
            net.minecraft.world.item.ItemStack itemstack = nonnulllist.get(0);
            net.minecraft.world.item.ItemStack itemstack1 = recipeholder.value().assemble(singlerecipeinput, (HolderLookup.Provider)iregistrycustom);
            net.minecraft.world.item.ItemStack itemstack2 = nonnulllist.get(2);
            CraftItemStack source = CraftItemStack.asCraftMirror(itemstack);
            ItemStack result = CraftItemStack.asBukkitCopy(itemstack1);
            FurnaceSmeltEvent furnaceSmeltEvent = new FurnaceSmeltEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)source, result);
            world.getCraftServer().getPluginManager().callEvent((Event)furnaceSmeltEvent);
            if (furnaceSmeltEvent.isCancelled()) {
                return false;
            }
            result = furnaceSmeltEvent.getResult();
            itemstack1 = CraftItemStack.asNMSCopy(result);
            if (!itemstack1.isEmpty()) {
                if (itemstack2.isEmpty()) {
                    nonnulllist.set(2, itemstack1.copy());
                } else if (CraftItemStack.asCraftMirror(itemstack2).isSimilar(result)) {
                    itemstack2.grow(itemstack1.getCount());
                } else {
                    return false;
                }
            }
            if (itemstack.is(Blocks.WET_SPONGE.asItem()) && !nonnulllist.get(1).isEmpty() && nonnulllist.get(1).is(Items.BUCKET)) {
                nonnulllist.set(1, new net.minecraft.world.item.ItemStack(Items.WATER_BUCKET));
            }
            itemstack.shrink(1);
            return true;
        }
        return false;
    }

    protected int getBurnDuration(FuelValues fuelvalues, net.minecraft.world.item.ItemStack itemstack) {
        return fuelvalues.burnDuration(itemstack);
    }

    private static int getTotalCookTime(ServerLevel worldserver, AbstractFurnaceBlockEntity tileentityfurnace) {
        if (worldserver == null) {
            return 200;
        }
        SingleRecipeInput singlerecipeinput = new SingleRecipeInput(tileentityfurnace.getItem(0));
        return tileentityfurnace.quickCheck.getRecipeFor(singlerecipeinput, worldserver).map(recipeholder -> ((AbstractCookingRecipe)recipeholder.value()).cookingTime()).orElse(200);
    }

    @Override
    public int[] getSlotsForFace(Direction enumdirection) {
        return enumdirection == Direction.DOWN ? SLOTS_FOR_DOWN : (enumdirection == Direction.UP ? SLOTS_FOR_UP : SLOTS_FOR_SIDES);
    }

    @Override
    public boolean canPlaceItemThroughFace(int i, net.minecraft.world.item.ItemStack itemstack, @Nullable Direction enumdirection) {
        return this.canPlaceItem(i, itemstack);
    }

    @Override
    public boolean canTakeItemThroughFace(int i, net.minecraft.world.item.ItemStack itemstack, Direction enumdirection) {
        return enumdirection == Direction.DOWN && i == 1 ? itemstack.is(Items.WATER_BUCKET) || itemstack.is(Items.BUCKET) : true;
    }

    @Override
    public int getContainerSize() {
        return this.items.size();
    }

    @Override
    protected NonNullList<net.minecraft.world.item.ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void setItems(NonNullList<net.minecraft.world.item.ItemStack> nonnulllist) {
        this.items = nonnulllist;
    }

    @Override
    public void setItem(int i, net.minecraft.world.item.ItemStack itemstack) {
        Level world;
        net.minecraft.world.item.ItemStack itemstack1 = this.items.get(i);
        boolean flag = !itemstack.isEmpty() && net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemstack1, itemstack);
        this.items.set(i, itemstack);
        itemstack.limitSize(this.getMaxStackSize(itemstack));
        if (i == 0 && !flag && (world = this.level) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            this.cookingTotalTime = AbstractFurnaceBlockEntity.getTotalCookTime(worldserver, this);
            this.cookingTimer = 0;
            this.setChanged();
        }
    }

    @Override
    public boolean canPlaceItem(int i, net.minecraft.world.item.ItemStack itemstack) {
        if (i == 2) {
            return false;
        }
        if (i != 1) {
            return true;
        }
        net.minecraft.world.item.ItemStack itemstack1 = this.items.get(1);
        return this.level.fuelValues().isFuel(itemstack) || itemstack.is(Items.BUCKET) && !itemstack1.is(Items.BUCKET);
    }

    @Override
    public void setRecipeUsed(@Nullable RecipeHolder<?> recipeholder) {
        if (recipeholder != null) {
            ResourceKey<Recipe<?>> resourcekey = recipeholder.id();
            this.recipesUsed.addTo(resourcekey, 1);
        }
    }

    @Override
    public @Nullable RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    @Override
    public void awardUsedRecipes(Player entityhuman, List<net.minecraft.world.item.ItemStack> list) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience(entityplayer.level(), entityplayer.position(), this.worldPosition, entityplayer, itemstack, amount);
        entityplayer.awardRecipes(list);
        for (RecipeHolder<?> recipeholder : list) {
            entityplayer.triggerRecipeCrafted(recipeholder, this.items);
        }
        this.recipesUsed.clear();
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel worldserver, Vec3 vec3d) {
        return this.getRecipesToAwardAndPopExperience(worldserver, vec3d, this.worldPosition, null, null, 0);
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel worldserver, Vec3 vec3d, BlockPos blockposition, ServerPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        ArrayList list = Lists.newArrayList();
        for (Reference2IntMap.Entry reference2intmap_entry : this.recipesUsed.reference2IntEntrySet()) {
            worldserver.recipeAccess().byKey((ResourceKey)reference2intmap_entry.getKey()).ifPresent(recipeholder -> {
                list.add(recipeholder);
                AbstractFurnaceBlockEntity.createExperience(worldserver, vec3d, reference2intmap_entry.getIntValue(), ((AbstractCookingRecipe)recipeholder.value()).experience(), blockposition, entityplayer, itemstack, amount);
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel worldserver, Vec3 vec3d, int i, float f, BlockPos blockposition, Player entityhuman, net.minecraft.world.item.ItemStack itemstack, int amount) {
        int j = Mth.floor((float)i * f);
        float f1 = Mth.frac((float)i * f);
        if (f1 != 0.0f && worldserver.random.nextFloat() < f1) {
            ++j;
        }
        Object event = amount != 0 ? new FurnaceExtractEvent((org.bukkit.entity.Player)entityhuman.getBukkitEntity(), (Block)CraftBlock.at(worldserver, blockposition), CraftItemType.minecraftToBukkit(itemstack.getItem()), amount, j) : new BlockExpEvent((Block)CraftBlock.at(worldserver, blockposition), j);
        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        j = event.getExpToDrop();
        ExperienceOrb.award(worldserver, vec3d, j);
    }

    @Override
    public void fillStackedContents(StackedItemContents stackeditemcontents) {
        for (net.minecraft.world.item.ItemStack itemstack : this.items) {
            stackeditemcontents.accountStack(itemstack);
        }
    }

    @Override
    public void preRemoveSideEffects(BlockPos blockposition, BlockState iblockdata) {
        super.preRemoveSideEffects(blockposition, iblockdata);
        Level world = this.level;
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            this.getRecipesToAwardAndPopExperience(worldserver, Vec3.atCenterOf(blockposition));
        }
    }
}

