/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CalibratedSculkSensorBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.jspecify.annotations.Nullable;

public class CalibratedSculkSensorBlockEntity
extends SculkSensorBlockEntity {
    public CalibratedSculkSensorBlockEntity(BlockPos var0, BlockState var1) {
        super(BlockEntityType.CALIBRATED_SCULK_SENSOR, var0, var1);
    }

    @Override
    public VibrationSystem.User createVibrationUser() {
        return new VibrationUser(this.getBlockPos());
    }

    protected class VibrationUser
    extends SculkSensorBlockEntity.VibrationUser {
        public VibrationUser(BlockPos var1) {
            super(var1);
        }

        @Override
        public int getListenerRadius() {
            return 16;
        }

        @Override
        public boolean canReceiveVibration(ServerLevel var0, BlockPos var1, Holder<GameEvent> var2, @Nullable GameEvent.Context var3) {
            int var4 = this.getBackSignal(var0, this.blockPos, CalibratedSculkSensorBlockEntity.this.getBlockState());
            if (var4 != 0 && VibrationSystem.getGameEventFrequency(var2) != var4) {
                return false;
            }
            return super.canReceiveVibration(var0, var1, var2, var3);
        }

        private int getBackSignal(Level var0, BlockPos var1, BlockState var2) {
            Direction var3 = var2.getValue(CalibratedSculkSensorBlock.FACING).getOpposite();
            return var0.getSignal(var1.relative(var3), var3);
        }
    }
}

