/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCookEvent;
import org.bukkit.event.block.CampfireStartEvent;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class CampfireBlockEntity
extends BlockEntity
implements Clearable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int BURN_COOL_SPEED = 2;
    private static final int NUM_SLOTS = 4;
    private final NonNullList<net.minecraft.world.item.ItemStack> items = NonNullList.withSize(4, net.minecraft.world.item.ItemStack.EMPTY);
    public final int[] cookingProgress = new int[4];
    public final int[] cookingTime = new int[4];

    public CampfireBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        super(BlockEntityType.CAMPFIRE, blockposition, iblockdata);
    }

    public static void cookTick(ServerLevel worldserver, BlockPos blockposition, BlockState iblockdata, CampfireBlockEntity tileentitycampfire, RecipeManager.CachedCheck<SingleRecipeInput, CampfireCookingRecipe> craftingmanager_a) {
        boolean flag = false;
        for (int i = 0; i < tileentitycampfire.items.size(); ++i) {
            SingleRecipeInput singlerecipeinput;
            net.minecraft.world.item.ItemStack itemstack1;
            net.minecraft.world.item.ItemStack itemstack = tileentitycampfire.items.get(i);
            if (itemstack.isEmpty()) continue;
            flag = true;
            int n = i;
            tileentitycampfire.cookingProgress[n] = tileentitycampfire.cookingProgress[n] + 1;
            if (tileentitycampfire.cookingProgress[i] < tileentitycampfire.cookingTime[i] || !(itemstack1 = craftingmanager_a.getRecipeFor(singlerecipeinput = new SingleRecipeInput(itemstack), worldserver).map(recipeholder -> ((CampfireCookingRecipe)recipeholder.value()).assemble(singlerecipeinput, (HolderLookup.Provider)worldserver.registryAccess())).orElse(itemstack)).isItemEnabled(worldserver.enabledFeatures())) continue;
            CraftItemStack source = CraftItemStack.asCraftMirror(itemstack);
            ItemStack result = CraftItemStack.asBukkitCopy(itemstack1);
            BlockCookEvent blockCookEvent = new BlockCookEvent((Block)CraftBlock.at(worldserver, blockposition), (ItemStack)source, result);
            worldserver.getCraftServer().getPluginManager().callEvent((Event)blockCookEvent);
            if (blockCookEvent.isCancelled()) {
                return;
            }
            result = blockCookEvent.getResult();
            itemstack1 = CraftItemStack.asNMSCopy(result);
            Containers.dropItemStack(worldserver, blockposition.getX(), blockposition.getY(), blockposition.getZ(), itemstack1);
            tileentitycampfire.items.set(i, net.minecraft.world.item.ItemStack.EMPTY);
            worldserver.sendBlockUpdated(blockposition, iblockdata, iblockdata, 3);
            worldserver.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.Context.of(iblockdata));
        }
        if (flag) {
            CampfireBlockEntity.setChanged(worldserver, blockposition, iblockdata);
        }
    }

    public static void cooldownTick(Level world, BlockPos blockposition, BlockState iblockdata, CampfireBlockEntity tileentitycampfire) {
        boolean flag = false;
        for (int i = 0; i < tileentitycampfire.items.size(); ++i) {
            if (tileentitycampfire.cookingProgress[i] <= 0) continue;
            flag = true;
            tileentitycampfire.cookingProgress[i] = Mth.clamp(tileentitycampfire.cookingProgress[i] - 2, 0, tileentitycampfire.cookingTime[i]);
        }
        if (flag) {
            CampfireBlockEntity.setChanged(world, blockposition, iblockdata);
        }
    }

    public static void particleTick(Level world, BlockPos blockposition, BlockState iblockdata, CampfireBlockEntity tileentitycampfire) {
        RandomSource randomsource = world.random;
        if (randomsource.nextFloat() < 0.11f) {
            for (int i = 0; i < randomsource.nextInt(2) + 2; ++i) {
                CampfireBlock.makeParticles(world, blockposition, iblockdata.getValue(CampfireBlock.SIGNAL_FIRE), false);
            }
        }
        int j = iblockdata.getValue(CampfireBlock.FACING).get2DDataValue();
        for (int k = 0; k < tileentitycampfire.items.size(); ++k) {
            if (tileentitycampfire.items.get(k).isEmpty() || !(randomsource.nextFloat() < 0.2f)) continue;
            Direction enumdirection = Direction.from2DDataValue(Math.floorMod(k + j, 4));
            float f = 0.3125f;
            double d0 = (double)blockposition.getX() + 0.5 - (double)((float)enumdirection.getStepX() * 0.3125f) + (double)((float)enumdirection.getClockWise().getStepX() * 0.3125f);
            double d1 = (double)blockposition.getY() + 0.5;
            double d2 = (double)blockposition.getZ() + 0.5 - (double)((float)enumdirection.getStepZ() * 0.3125f) + (double)((float)enumdirection.getClockWise().getStepZ() * 0.3125f);
            for (int l = 0; l < 4; ++l) {
                world.addParticle(ParticleTypes.SMOKE, d0, d1, d2, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public NonNullList<net.minecraft.world.item.ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void loadAdditional(ValueInput valueinput) {
        super.loadAdditional(valueinput);
        this.items.clear();
        ContainerHelper.loadAllItems(valueinput, this.items);
        valueinput.getIntArray("CookingTimes").ifPresentOrElse(aint -> System.arraycopy(aint, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, ((int[])aint).length)), () -> Arrays.fill(this.cookingProgress, 0));
        valueinput.getIntArray("CookingTotalTimes").ifPresentOrElse(aint -> System.arraycopy(aint, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, ((int[])aint).length)), () -> Arrays.fill(this.cookingTime, 0));
    }

    @Override
    protected void saveAdditional(ValueOutput valueoutput) {
        super.saveAdditional(valueoutput);
        ContainerHelper.saveAllItems(valueoutput, this.items, true);
        valueoutput.putIntArray("CookingTimes", this.cookingProgress);
        valueoutput.putIntArray("CookingTotalTimes", this.cookingTime);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider holderlookup_a) {
        try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(this.problemPath(), LOGGER);){
            TagValueOutput tagvalueoutput = TagValueOutput.createWithContext(problemreporter_j, holderlookup_a);
            ContainerHelper.saveAllItems(tagvalueoutput, this.items, true);
            CompoundTag compoundTag = tagvalueoutput.buildResult();
            return compoundTag;
        }
    }

    public boolean placeFood(ServerLevel worldserver, @Nullable LivingEntity entityliving, net.minecraft.world.item.ItemStack itemstack) {
        for (int i = 0; i < this.items.size(); ++i) {
            net.minecraft.world.item.ItemStack itemstack1 = this.items.get(i);
            if (!itemstack1.isEmpty()) continue;
            Optional<RecipeHolder<CampfireCookingRecipe>> optional = worldserver.recipeAccess().getRecipeFor(RecipeType.CAMPFIRE_COOKING, new SingleRecipeInput(itemstack), worldserver);
            if (optional.isEmpty()) {
                return false;
            }
            CampfireStartEvent event = new CampfireStartEvent((Block)CraftBlock.at(this.level, this.worldPosition), (ItemStack)CraftItemStack.asCraftMirror(itemstack), (CampfireRecipe)optional.get().toBukkitRecipe());
            this.level.getCraftServer().getPluginManager().callEvent((Event)event);
            this.cookingTime[i] = event.getTotalCookTime();
            this.cookingProgress[i] = 0;
            this.items.set(i, itemstack.consumeAndReturn(1, entityliving));
            worldserver.gameEvent(GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of(entityliving, this.getBlockState()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    @Override
    public void clearContent() {
        this.items.clear();
    }

    @Override
    public void preRemoveSideEffects(BlockPos blockposition, BlockState iblockdata) {
        if (this.level != null) {
            Containers.dropContents(this.level, blockposition, this.getItems());
        }
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter datacomponentgetter) {
        super.applyImplicitComponents(datacomponentgetter);
        datacomponentgetter.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY).copyInto(this.getItems());
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder datacomponentmap_a) {
        super.collectImplicitComponents(datacomponentmap_a);
        datacomponentmap_a.set(DataComponents.CONTAINER, ItemContainerContents.fromItems(this.getItems()));
    }

    @Override
    public void removeComponentsFromTag(ValueOutput valueoutput) {
        valueoutput.discard("Items");
    }
}

