/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;

public abstract class ContainerOpenersCounter {
    private static final int CHECK_TICK_DELAY = 5;
    private int openCount;
    private double maxInteractionRange;
    public boolean opened;

    protected abstract void onOpen(Level var1, BlockPos var2, BlockState var3);

    protected abstract void onClose(Level var1, BlockPos var2, BlockState var3);

    protected abstract void openerCountChanged(Level var1, BlockPos var2, BlockState var3, int var4, int var5);

    public void onAPIOpen(Level world, BlockPos blockposition, BlockState iblockdata) {
        this.onOpen(world, blockposition, iblockdata);
    }

    public void onAPIClose(Level world, BlockPos blockposition, BlockState iblockdata) {
        this.onClose(world, blockposition, iblockdata);
    }

    public void openerAPICountChanged(Level world, BlockPos blockposition, BlockState iblockdata, int i, int j) {
        this.openerCountChanged(world, blockposition, iblockdata, i, j);
    }

    public abstract boolean isOwnContainer(Player var1);

    public void incrementOpeners(LivingEntity entityliving, Level world, BlockPos blockposition, BlockState iblockdata, double d0) {
        int newPower;
        int oldPower = Math.max(0, Math.min(15, this.openCount));
        int i = this.openCount++;
        if (world.getBlockState(blockposition).is(Blocks.TRAPPED_CHEST) && oldPower != (newPower = Math.max(0, Math.min(15, this.openCount)))) {
            CraftEventFactory.callRedstoneChange(world, blockposition, oldPower, newPower);
        }
        if (i == 0) {
            this.onOpen(world, blockposition, iblockdata);
            world.gameEvent((Entity)entityliving, GameEvent.CONTAINER_OPEN, blockposition);
            ContainerOpenersCounter.scheduleRecheck(world, blockposition, iblockdata);
        }
        this.openerCountChanged(world, blockposition, iblockdata, i, this.openCount);
        this.maxInteractionRange = Math.max(d0, this.maxInteractionRange);
    }

    public void decrementOpeners(LivingEntity entityliving, Level world, BlockPos blockposition, BlockState iblockdata) {
        int newPower;
        int oldPower = Math.max(0, Math.min(15, this.openCount));
        int i = this.openCount--;
        if (world.getBlockState(blockposition).is(Blocks.TRAPPED_CHEST) && oldPower != (newPower = Math.max(0, Math.min(15, this.openCount)))) {
            CraftEventFactory.callRedstoneChange(world, blockposition, oldPower, newPower);
        }
        if (this.openCount == 0) {
            this.onClose(world, blockposition, iblockdata);
            world.gameEvent((Entity)entityliving, GameEvent.CONTAINER_CLOSE, blockposition);
            this.maxInteractionRange = 0.0;
        }
        this.openerCountChanged(world, blockposition, iblockdata, i, this.openCount);
    }

    public List<ContainerUser> getEntitiesWithContainerOpen(Level world, BlockPos blockposition) {
        double d0 = this.maxInteractionRange + 4.0;
        AABB axisalignedbb = new AABB(blockposition).inflate(d0);
        return world.getEntities((Entity)null, axisalignedbb, entity -> this.hasContainerOpen((Entity)entity, blockposition)).stream().map(entity -> (ContainerUser)((Object)entity)).collect(Collectors.toList());
    }

    private boolean hasContainerOpen(Entity entity, BlockPos blockposition) {
        ContainerUser containeruser;
        if (entity instanceof ContainerUser && !(containeruser = (ContainerUser)((Object)entity)).getLivingEntity().isSpectator()) {
            return containeruser.hasContainerOpen(this, blockposition);
        }
        return false;
    }

    public void recheckOpeners(Level world, BlockPos blockposition, BlockState iblockdata) {
        int j;
        List<ContainerUser> list = this.getEntitiesWithContainerOpen(world, blockposition);
        this.maxInteractionRange = 0.0;
        for (ContainerUser containeruser : list) {
            this.maxInteractionRange = Math.max(containeruser.getContainerInteractionRange(), this.maxInteractionRange);
        }
        int i = list.size();
        if (this.opened) {
            ++i;
        }
        if ((j = this.openCount) != i) {
            boolean flag1;
            boolean flag = i != 0;
            boolean bl = flag1 = j != 0;
            if (flag && !flag1) {
                this.onOpen(world, blockposition, iblockdata);
                world.gameEvent((Entity)null, GameEvent.CONTAINER_OPEN, blockposition);
            } else if (!flag) {
                this.onClose(world, blockposition, iblockdata);
                world.gameEvent((Entity)null, GameEvent.CONTAINER_CLOSE, blockposition);
            }
            this.openCount = i;
        }
        this.openerCountChanged(world, blockposition, iblockdata, j, i);
        if (i > 0) {
            ContainerOpenersCounter.scheduleRecheck(world, blockposition, iblockdata);
        }
    }

    public int getOpenerCount() {
        return this.openCount;
    }

    private static void scheduleRecheck(Level world, BlockPos blockposition, BlockState iblockdata) {
        world.scheduleTick(blockposition, iblockdata.getBlock(), 5);
    }
}

