/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;

public class PistonStructureResolver {
    public static final int MAX_PUSH_DEPTH = 12;
    private final Level level;
    private final BlockPos pistonPos;
    private final boolean extending;
    private final BlockPos startPos;
    private final Direction pushDirection;
    private final List<BlockPos> toPush = Lists.newArrayList();
    private final List<BlockPos> toDestroy = Lists.newArrayList();
    private final Direction pistonDirection;

    public PistonStructureResolver(Level var0, BlockPos var1, Direction var2, boolean var3) {
        this.level = var0;
        this.pistonPos = var1;
        this.pistonDirection = var2;
        this.extending = var3;
        if (var3) {
            this.pushDirection = var2;
            this.startPos = var1.relative(var2);
        } else {
            this.pushDirection = var2.getOpposite();
            this.startPos = var1.relative(var2, 2);
        }
    }

    public boolean resolve() {
        this.toPush.clear();
        this.toDestroy.clear();
        BlockState var0 = this.level.getBlockState(this.startPos);
        if (!PistonBaseBlock.isPushable(var0, this.level, this.startPos, this.pushDirection, false, this.pistonDirection)) {
            if (this.extending && var0.getPistonPushReaction() == PushReaction.DESTROY) {
                this.toDestroy.add(this.startPos);
                return true;
            }
            return false;
        }
        if (!this.addBlockLine(this.startPos, this.pushDirection)) {
            return false;
        }
        for (int var1 = 0; var1 < this.toPush.size(); ++var1) {
            BlockPos var2 = this.toPush.get(var1);
            if (!PistonStructureResolver.isSticky(this.level.getBlockState(var2)) || this.addBranchingBlocks(var2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSticky(BlockState var0) {
        return var0.is(Blocks.SLIME_BLOCK) || var0.is(Blocks.HONEY_BLOCK);
    }

    private static boolean canStickToEachOther(BlockState var0, BlockState var1) {
        if (var0.is(Blocks.HONEY_BLOCK) && var1.is(Blocks.SLIME_BLOCK)) {
            return false;
        }
        if (var0.is(Blocks.SLIME_BLOCK) && var1.is(Blocks.HONEY_BLOCK)) {
            return false;
        }
        return PistonStructureResolver.isSticky(var0) || PistonStructureResolver.isSticky(var1);
    }

    private boolean addBlockLine(BlockPos var0, Direction var1) {
        int var5;
        BlockState var2 = this.level.getBlockState(var0);
        if (var2.isAir()) {
            return true;
        }
        if (!PistonBaseBlock.isPushable(var2, this.level, var0, this.pushDirection, false, var1)) {
            return true;
        }
        if (var0.equals(this.pistonPos)) {
            return true;
        }
        if (this.toPush.contains(var0)) {
            return true;
        }
        int var3 = 1;
        if (var3 + this.toPush.size() > 12) {
            return false;
        }
        while (PistonStructureResolver.isSticky(var2)) {
            BlockPos var4 = var0.relative(this.pushDirection.getOpposite(), var3);
            BlockState var52 = var2;
            var2 = this.level.getBlockState(var4);
            if (var2.isAir() || !PistonStructureResolver.canStickToEachOther(var52, var2) || !PistonBaseBlock.isPushable(var2, this.level, var4, this.pushDirection, false, this.pushDirection.getOpposite()) || var4.equals(this.pistonPos)) break;
            if (++var3 + this.toPush.size() <= 12) continue;
            return false;
        }
        int var4 = 0;
        for (var5 = var3 - 1; var5 >= 0; --var5) {
            this.toPush.add(var0.relative(this.pushDirection.getOpposite(), var5));
            ++var4;
        }
        var5 = 1;
        while (true) {
            BlockPos var6;
            int var7;
            if ((var7 = this.toPush.indexOf(var6 = var0.relative(this.pushDirection, var5))) > -1) {
                this.reorderListAtCollision(var4, var7);
                for (int var8 = 0; var8 <= var7 + var4; ++var8) {
                    BlockPos var9 = this.toPush.get(var8);
                    if (!PistonStructureResolver.isSticky(this.level.getBlockState(var9)) || this.addBranchingBlocks(var9)) continue;
                    return false;
                }
                return true;
            }
            var2 = this.level.getBlockState(var6);
            if (var2.isAir()) {
                return true;
            }
            if (!PistonBaseBlock.isPushable(var2, this.level, var6, this.pushDirection, true, this.pushDirection) || var6.equals(this.pistonPos)) {
                return false;
            }
            if (var2.getPistonPushReaction() == PushReaction.DESTROY) {
                this.toDestroy.add(var6);
                return true;
            }
            if (this.toPush.size() >= 12) {
                return false;
            }
            this.toPush.add(var6);
            ++var4;
            ++var5;
        }
    }

    private void reorderListAtCollision(int var0, int var1) {
        ArrayList var2 = Lists.newArrayList();
        ArrayList var3 = Lists.newArrayList();
        ArrayList var4 = Lists.newArrayList();
        var2.addAll(this.toPush.subList(0, var1));
        var3.addAll(this.toPush.subList(this.toPush.size() - var0, this.toPush.size()));
        var4.addAll(this.toPush.subList(var1, this.toPush.size() - var0));
        this.toPush.clear();
        this.toPush.addAll(var2);
        this.toPush.addAll(var3);
        this.toPush.addAll(var4);
    }

    private boolean addBranchingBlocks(BlockPos var0) {
        BlockState var1 = this.level.getBlockState(var0);
        for (Direction var5 : Direction.values()) {
            BlockPos var6;
            BlockState var7;
            if (var5.getAxis() == this.pushDirection.getAxis() || !PistonStructureResolver.canStickToEachOther(var7 = this.level.getBlockState(var6 = var0.relative(var5)), var1) || this.addBlockLine(var6, var5)) continue;
            return false;
        }
        return true;
    }

    public Direction getPushDirection() {
        return this.pushDirection;
    }

    public List<BlockPos> getToPush() {
        return this.toPush;
    }

    public List<BlockPos> getToDestroy() {
        return this.toDestroy;
    }
}

