/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.SpigotWorldConfig;

public class ChunkGeneratorStructureState {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final RandomState randomState;
    private final BiomeSource biomeSource;
    private final long levelSeed;
    private final long concentricRingsSeed;
    private final Map<Structure, List<StructurePlacement>> placementsForStructure = new Object2ObjectOpenHashMap();
    private final Map<ConcentricRingsStructurePlacement, CompletableFuture<List<ChunkPos>>> ringPositions = new Object2ObjectArrayMap();
    private boolean hasGeneratedPositions;
    private final List<Holder<StructureSet>> possibleStructureSets;

    public static ChunkGeneratorStructureState createForFlat(RandomState randomstate, long i, BiomeSource worldchunkmanager, Stream<Holder<StructureSet>> stream, SpigotWorldConfig conf) {
        List<Holder<StructureSet>> list = stream.filter(holder -> ChunkGeneratorStructureState.hasBiomesForStructureSet((StructureSet)holder.value(), worldchunkmanager)).toList();
        return new ChunkGeneratorStructureState(randomstate, worldchunkmanager, i, 0L, ChunkGeneratorStructureState.injectSpigot(list, conf));
    }

    public static ChunkGeneratorStructureState createForNormal(RandomState randomstate, long i, BiomeSource worldchunkmanager, HolderLookup<StructureSet> holderlookup, SpigotWorldConfig conf) {
        List<Holder<StructureSet>> list = holderlookup.listElements().filter(holder_c -> ChunkGeneratorStructureState.hasBiomesForStructureSet((StructureSet)holder_c.value(), worldchunkmanager)).collect(Collectors.toUnmodifiableList());
        return new ChunkGeneratorStructureState(randomstate, worldchunkmanager, i, i, ChunkGeneratorStructureState.injectSpigot(list, conf));
    }

    private static List<Holder<StructureSet>> injectSpigot(List<Holder<StructureSet>> list, SpigotWorldConfig conf) {
        return list.stream().map(holder -> {
            StructureSet structureset = (StructureSet)holder.value();
            StructurePlacement patt0$temp = structureset.placement();
            if (patt0$temp instanceof RandomSpreadStructurePlacement) {
                RandomSpreadStructurePlacement randomConfig = (RandomSpreadStructurePlacement)patt0$temp;
                String name = holder.unwrapKey().orElseThrow().identifier().getPath();
                int seed = randomConfig.salt;
                switch (name) {
                    case "desert_pyramids": {
                        seed = conf.desertSeed;
                        break;
                    }
                    case "end_cities": {
                        seed = conf.endCitySeed;
                        break;
                    }
                    case "nether_complexes": {
                        seed = conf.netherSeed;
                        break;
                    }
                    case "igloos": {
                        seed = conf.iglooSeed;
                        break;
                    }
                    case "jungle_temples": {
                        seed = conf.jungleSeed;
                        break;
                    }
                    case "woodland_mansions": {
                        seed = conf.mansionSeed;
                        break;
                    }
                    case "ocean_monuments": {
                        seed = conf.monumentSeed;
                        break;
                    }
                    case "nether_fossils": {
                        seed = conf.fossilSeed;
                        break;
                    }
                    case "ocean_ruins": {
                        seed = conf.oceanSeed;
                        break;
                    }
                    case "pillager_outposts": {
                        seed = conf.outpostSeed;
                        break;
                    }
                    case "ruined_portals": {
                        seed = conf.portalSeed;
                        break;
                    }
                    case "shipwrecks": {
                        seed = conf.shipwreckSeed;
                        break;
                    }
                    case "swamp_huts": {
                        seed = conf.swampSeed;
                        break;
                    }
                    case "villages": {
                        seed = conf.villageSeed;
                    }
                }
                structureset = new StructureSet(structureset.structures(), (StructurePlacement)new RandomSpreadStructurePlacement(randomConfig.locateOffset, randomConfig.frequencyReductionMethod, randomConfig.frequency, seed, randomConfig.exclusionZone, randomConfig.spacing(), randomConfig.separation(), randomConfig.spreadType()));
            }
            return Holder.direct(structureset);
        }).collect(Collectors.toUnmodifiableList());
    }

    private static boolean hasBiomesForStructureSet(StructureSet structureset, BiomeSource worldchunkmanager) {
        Stream stream = structureset.structures().stream().flatMap(structureset_a -> {
            Structure structure = structureset_a.structure().value();
            return structure.biomes().stream();
        });
        Set<Holder<Biome>> set = worldchunkmanager.possibleBiomes();
        Objects.requireNonNull(set);
        return stream.anyMatch(set::contains);
    }

    private ChunkGeneratorStructureState(RandomState randomstate, BiomeSource worldchunkmanager, long i, long j, List<Holder<StructureSet>> list) {
        this.randomState = randomstate;
        this.levelSeed = i;
        this.biomeSource = worldchunkmanager;
        this.concentricRingsSeed = j;
        this.possibleStructureSets = list;
    }

    public List<Holder<StructureSet>> possibleStructureSets() {
        return this.possibleStructureSets;
    }

    private void generatePositions() {
        Set<Holder<Biome>> set = this.biomeSource.possibleBiomes();
        this.possibleStructureSets().forEach(holder -> {
            StructurePlacement structureplacement;
            StructureSet structureset = (StructureSet)holder.value();
            boolean flag = false;
            for (StructureSet.StructureSelectionEntry structureset_a : structureset.structures()) {
                Structure structure = structureset_a.structure().value();
                Stream<Holder<Biome>> stream = structure.biomes().stream();
                Objects.requireNonNull(set);
                if (!stream.anyMatch(set::contains)) continue;
                this.placementsForStructure.computeIfAbsent(structure, structure1 -> new ArrayList()).add(structureset.placement());
                flag = true;
            }
            if (flag && (structureplacement = structureset.placement()) instanceof ConcentricRingsStructurePlacement) {
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)structureplacement;
                this.ringPositions.put(concentricringsstructureplacement, this.generateRingPositions((Holder<StructureSet>)holder, concentricringsstructureplacement));
            }
        });
    }

    private CompletableFuture<List<ChunkPos>> generateRingPositions(Holder<StructureSet> holder, ConcentricRingsStructurePlacement concentricringsstructureplacement) {
        if (concentricringsstructureplacement.count() == 0) {
            return CompletableFuture.completedFuture(List.of());
        }
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.TICKER);
        int i = concentricringsstructureplacement.distance();
        int j = concentricringsstructureplacement.count();
        ArrayList<CompletableFuture<ChunkPos>> list = new ArrayList<CompletableFuture<ChunkPos>>(j);
        int k = concentricringsstructureplacement.spread();
        HolderSet<Biome> holderset = concentricringsstructureplacement.preferredBiomes();
        RandomSource randomsource = RandomSource.create();
        randomsource.setSeed(this.concentricRingsSeed);
        double d0 = randomsource.nextDouble() * Math.PI * 2.0;
        int l = 0;
        int i1 = 0;
        for (int j1 = 0; j1 < j; ++j1) {
            double d1 = (double)(4 * i + i * i1 * 6) + (randomsource.nextDouble() - 0.5) * (double)i * 2.5;
            int k1 = (int)Math.round(Math.cos(d0) * d1);
            int l1 = (int)Math.round(Math.sin(d0) * d1);
            RandomSource randomsource1 = randomsource.fork();
            list.add(CompletableFuture.supplyAsync(() -> {
                BiomeSource worldchunkmanager = this.biomeSource;
                int i2 = SectionPos.sectionToBlockCoord(k1, 8);
                int j2 = SectionPos.sectionToBlockCoord(l1, 8);
                Objects.requireNonNull(holderset);
                Pair<BlockPos, Holder<Biome>> pair = worldchunkmanager.findBiomeHorizontal(i2, 0, j2, 112, holderset::contains, randomsource1, this.randomState.sampler());
                if (pair != null) {
                    BlockPos blockposition = (BlockPos)pair.getFirst();
                    return new ChunkPos(SectionPos.blockToSectionCoord(blockposition.getX()), SectionPos.blockToSectionCoord(blockposition.getZ()));
                }
                return new ChunkPos(k1, l1);
            }, Util.backgroundExecutor().forName("structureRings")));
            d0 += Math.PI * 2 / (double)k;
            if (++l != k) continue;
            l = 0;
            k += 2 * k / (++i1 + 1);
            k = Math.min(k, j - j1);
            d0 += randomsource.nextDouble() * Math.PI * 2.0;
        }
        return Util.sequence(list).thenApply(list1 -> {
            double d2 = (double)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            LOGGER.debug("Calculation for {} took {}s", (Object)holder, (Object)d2);
            return list1;
        });
    }

    public void ensureStructuresGenerated() {
        if (!this.hasGeneratedPositions) {
            this.generatePositions();
            this.hasGeneratedPositions = true;
        }
    }

    public @Nullable List<ChunkPos> getRingPositionsFor(ConcentricRingsStructurePlacement concentricringsstructureplacement) {
        this.ensureStructuresGenerated();
        CompletableFuture<List<ChunkPos>> completablefuture = this.ringPositions.get(concentricringsstructureplacement);
        return completablefuture != null ? completablefuture.join() : null;
    }

    public List<StructurePlacement> getPlacementsForStructure(Holder<Structure> holder) {
        this.ensureStructuresGenerated();
        return this.placementsForStructure.getOrDefault(holder.value(), List.of());
    }

    public RandomState randomState() {
        return this.randomState;
    }

    public boolean hasStructureChunkInRange(Holder<StructureSet> holder, int i, int j, int k) {
        StructurePlacement structureplacement = holder.value().placement();
        for (int l = i - k; l <= i + k; ++l) {
            for (int i1 = j - k; i1 <= j + k; ++i1) {
                if (!structureplacement.isStructureChunk(this, l, i1)) continue;
                return true;
            }
        }
        return false;
    }

    public long getLevelSeed() {
        return this.levelSeed;
    }
}

