/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.function.BooleanSupplier;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.jspecify.annotations.Nullable;

public abstract class ChunkSource
implements LightChunkGetter,
AutoCloseable {
    public @Nullable LevelChunk getChunk(int var0, int var1, boolean var2) {
        return (LevelChunk)this.getChunk(var0, var1, ChunkStatus.FULL, var2);
    }

    public @Nullable LevelChunk getChunkNow(int var0, int var1) {
        return this.getChunk(var0, var1, false);
    }

    @Override
    public @Nullable LightChunk getChunkForLighting(int var0, int var1) {
        return this.getChunk(var0, var1, ChunkStatus.EMPTY, false);
    }

    public boolean hasChunk(int var0, int var1) {
        return this.getChunk(var0, var1, ChunkStatus.FULL, false) != null;
    }

    public abstract @Nullable ChunkAccess getChunk(int var1, int var2, ChunkStatus var3, boolean var4);

    public abstract void tick(BooleanSupplier var1, boolean var2);

    public void onSectionEmptinessChanged(int var0, int var1, int var2, boolean var3) {
    }

    public abstract String gatherStats();

    public abstract int getLoadedChunksCount();

    @Override
    public void close() throws IOException {
    }

    public abstract LevelLightEngine getLightEngine();

    public void setSpawnSettings(boolean var0) {
    }

    public boolean updateChunkForced(ChunkPos var0, boolean var1) {
        return false;
    }

    public LongSet getForceLoadedChunks() {
        return LongSet.of();
    }
}

