/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.function.Predicate;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;

public class GlobalPalette<T>
implements Palette<T> {
    private final IdMap<T> registry;

    public GlobalPalette(IdMap<T> var0) {
        this.registry = var0;
    }

    @Override
    public int idFor(T var0, PaletteResize<T> var1) {
        int var2 = this.registry.getId(var0);
        return var2 == -1 ? 0 : var2;
    }

    @Override
    public boolean maybeHas(Predicate<T> var0) {
        return true;
    }

    @Override
    public T valueFor(int var0) {
        T var1 = this.registry.byId(var0);
        if (var1 == null) {
            throw new MissingPaletteEntryException(var0);
        }
        return var1;
    }

    @Override
    public void read(FriendlyByteBuf var0, IdMap<T> var1) {
    }

    @Override
    public void write(FriendlyByteBuf var0, IdMap<T> var1) {
    }

    @Override
    public int getSerializedSize(IdMap<T> var0) {
        return 0;
    }

    @Override
    public int getSize() {
        return this.registry.size();
    }

    @Override
    public Palette<T> copy() {
        return this;
    }
}

