/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.util.CrudeIncrementalIntIdentityHashBiMap;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;

public class HashMapPalette<T>
implements Palette<T> {
    private final CrudeIncrementalIntIdentityHashBiMap<T> values;
    private final int bits;

    public HashMapPalette(int var0, List<T> var1) {
        this(var0);
        var1.forEach(this.values::add);
    }

    public HashMapPalette(int var0) {
        this(var0, CrudeIncrementalIntIdentityHashBiMap.create(1 << var0));
    }

    private HashMapPalette(int var0, CrudeIncrementalIntIdentityHashBiMap<T> var1) {
        this.bits = var0;
        this.values = var1;
    }

    public static <A> Palette<A> create(int var0, List<A> var1) {
        return new HashMapPalette<A>(var0, var1);
    }

    @Override
    public int idFor(T var0, PaletteResize<T> var1) {
        int var2 = this.values.getId(var0);
        if (var2 == -1 && (var2 = this.values.add(var0)) >= 1 << this.bits) {
            var2 = var1.onResize(this.bits + 1, var0);
        }
        return var2;
    }

    @Override
    public boolean maybeHas(Predicate<T> var0) {
        for (int var1 = 0; var1 < this.getSize(); ++var1) {
            if (!var0.test(this.values.byId(var1))) continue;
            return true;
        }
        return false;
    }

    @Override
    public T valueFor(int var0) {
        T var1 = this.values.byId(var0);
        if (var1 == null) {
            throw new MissingPaletteEntryException(var0);
        }
        return var1;
    }

    @Override
    public void read(FriendlyByteBuf var0, IdMap<T> var1) {
        this.values.clear();
        int var2 = var0.readVarInt();
        for (int var3 = 0; var3 < var2; ++var3) {
            this.values.add(var1.byIdOrThrow(var0.readVarInt()));
        }
    }

    @Override
    public void write(FriendlyByteBuf var0, IdMap<T> var1) {
        int var2 = this.getSize();
        var0.writeVarInt(var2);
        for (int var3 = 0; var3 < var2; ++var3) {
            var0.writeVarInt(var1.getId(this.values.byId(var3)));
        }
    }

    @Override
    public int getSerializedSize(IdMap<T> var0) {
        int var1 = VarInt.getByteSize(this.getSize());
        for (int var2 = 0; var2 < this.getSize(); ++var2) {
            var1 += VarInt.getByteSize(var0.getId(this.values.byId(var2)));
        }
        return var1;
    }

    public List<T> getEntries() {
        ArrayList var0 = new ArrayList();
        this.values.iterator().forEachRemaining(var0::add);
        return var0;
    }

    @Override
    public int getSize() {
        return this.values.size();
    }

    @Override
    public Palette<T> copy() {
        return new HashMapPalette<T>(this.bits, this.values.copy());
    }
}

