/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.BitStorage;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.util.ThreadingDetector;
import net.minecraft.util.ZeroBitStorage;
import net.minecraft.world.level.chunk.Configuration;
import net.minecraft.world.level.chunk.HashMapPalette;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.Strategy;
import org.jspecify.annotations.Nullable;

public class PalettedContainer<T>
implements PaletteResize<T>,
PalettedContainerRO<T> {
    private static final int MIN_PALETTE_BITS = 0;
    private volatile Data<T> data;
    private final Strategy<T> strategy;
    private final ThreadingDetector threadingDetector = new ThreadingDetector("PalettedContainer");

    public void acquire() {
        this.threadingDetector.checkAndLock();
    }

    public void release() {
        this.threadingDetector.checkAndUnlock();
    }

    public static <T> Codec<PalettedContainer<T>> codecRW(Codec<T> var0, Strategy<T> var1, T var2) {
        PalettedContainerRO.Unpacker var3 = PalettedContainer::unpack;
        return PalettedContainer.codec(var0, var1, var2, var3);
    }

    public static <T> Codec<PalettedContainerRO<T>> codecRO(Codec<T> var0, Strategy<T> var12, T var2) {
        PalettedContainerRO.Unpacker var3 = (var02, var1) -> PalettedContainer.unpack(var02, var1).map(var0 -> var0);
        return PalettedContainer.codec(var0, var12, var2, var3);
    }

    private static <T, C extends PalettedContainerRO<T>> Codec<C> codec(Codec<T> var0, Strategy<T> var12, T var22, PalettedContainerRO.Unpacker<T, C> var3) {
        return RecordCodecBuilder.create(var2 -> var2.group((App)var0.mapResult(ExtraCodecs.orElsePartial(var22)).listOf().fieldOf("palette").forGetter(PalettedContainerRO.PackedData::paletteEntries), (App)Codec.LONG_STREAM.lenientOptionalFieldOf("data").forGetter(PalettedContainerRO.PackedData::storage)).apply((Applicative)var2, PalettedContainerRO.PackedData::new)).comapFlatMap(var2 -> var3.read(var12, (PalettedContainerRO.PackedData)var2), var1 -> var1.pack(var12));
    }

    private PalettedContainer(Strategy<T> var0, Configuration var1, BitStorage var2, Palette<T> var3) {
        this.strategy = var0;
        this.data = new Data<T>(var1, var2, var3);
    }

    private PalettedContainer(PalettedContainer<T> var0) {
        this.strategy = var0.strategy;
        this.data = var0.data.copy();
    }

    public PalettedContainer(T var0, Strategy<T> var1) {
        this.strategy = var1;
        this.data = this.createOrReuseData(null, 0);
        this.data.palette.idFor(var0, this);
    }

    private Data<T> createOrReuseData(@Nullable Data<T> var0, int var1) {
        Configuration var2 = this.strategy.getConfigurationForBitCount(var1);
        if (var0 != null && var2.equals(var0.configuration())) {
            return var0;
        }
        BitStorage var3 = var2.bitsInMemory() == 0 ? new ZeroBitStorage(this.strategy.entryCount()) : new SimpleBitStorage(var2.bitsInMemory(), this.strategy.entryCount());
        Palette<T> var4 = var2.createPalette(this.strategy, List.of());
        return new Data<T>(var2, var3, var4);
    }

    @Override
    public int onResize(int var0, T var1) {
        Data<T> var2 = this.data;
        Data var3 = this.createOrReuseData(var2, var0);
        var3.copyFrom(var2.palette, var2.storage);
        this.data = var3;
        return var3.palette.idFor(var1, PaletteResize.noResizeExpected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getAndSet(int var0, int var1, int var2, T var3) {
        this.acquire();
        try {
            T t = this.getAndSet(this.strategy.getIndex(var0, var1, var2), var3);
            return t;
        }
        finally {
            this.release();
        }
    }

    public T getAndSetUnchecked(int var0, int var1, int var2, T var3) {
        return this.getAndSet(this.strategy.getIndex(var0, var1, var2), var3);
    }

    private T getAndSet(int var0, T var1) {
        int var2 = this.data.palette.idFor(var1, this);
        int var3 = this.data.storage.getAndSet(var0, var2);
        return this.data.palette.valueFor(var3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(int var0, int var1, int var2, T var3) {
        this.acquire();
        try {
            this.set(this.strategy.getIndex(var0, var1, var2), var3);
        }
        finally {
            this.release();
        }
    }

    private void set(int var0, T var1) {
        int var2 = this.data.palette.idFor(var1, this);
        this.data.storage.set(var0, var2);
    }

    @Override
    public T get(int var0, int var1, int var2) {
        return this.get(this.strategy.getIndex(var0, var1, var2));
    }

    protected T get(int var0) {
        Data<T> var1 = this.data;
        return var1.palette.valueFor(var1.storage.get(var0));
    }

    @Override
    public void getAll(Consumer<T> var0) {
        Palette var1 = this.data.palette();
        IntArraySet var22 = new IntArraySet();
        this.data.storage.getAll(arg_0 -> ((IntSet)var22).add(arg_0));
        var22.forEach(var2 -> var0.accept(var1.valueFor(var2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(FriendlyByteBuf var0) {
        this.acquire();
        try {
            byte var1 = var0.readByte();
            Data<T> var2 = this.createOrReuseData(this.data, var1);
            var2.palette.read(var0, this.strategy.globalMap());
            var0.readFixedSizeLongArray(var2.storage.getRaw());
            this.data = var2;
        }
        finally {
            this.release();
        }
    }

    @Override
    public void write(FriendlyByteBuf var0) {
        this.acquire();
        try {
            this.data.write(var0, this.strategy.globalMap());
        }
        finally {
            this.release();
        }
    }

    @VisibleForTesting
    public static <T> DataResult<PalettedContainer<T>> unpack(Strategy<T> var0, PalettedContainerRO.PackedData<T> var1) {
        BitStorage var6;
        Palette<T> var7;
        List<T> var2 = var1.paletteEntries();
        int var3 = var0.entryCount();
        Configuration var4 = var0.getConfigurationForPaletteSize(var2.size());
        int var5 = var4.bitsInStorage();
        if (var1.bitsPerEntry() != -1 && var5 != var1.bitsPerEntry()) {
            return DataResult.error(() -> "Invalid bit count, calculated " + var5 + ", but container declared " + var1.bitsPerEntry());
        }
        if (var4.bitsInMemory() == 0) {
            var7 = var4.createPalette(var0, var2);
            var6 = new ZeroBitStorage(var3);
        } else {
            Optional<LongStream> var8 = var1.storage();
            if (var8.isEmpty()) {
                return DataResult.error(() -> "Missing values for non-zero storage");
            }
            long[] var9 = var8.get().toArray();
            try {
                if (var4.alwaysRepack() || var4.bitsInMemory() != var5) {
                    HashMapPalette<T> var10 = new HashMapPalette<T>(var5, var2);
                    SimpleBitStorage var11 = new SimpleBitStorage(var5, var3, var9);
                    Palette<T> var12 = var4.createPalette(var0, var2);
                    int[] var13 = PalettedContainer.reencodeContents(var11, var10, var12);
                    var7 = var12;
                    var6 = new SimpleBitStorage(var4.bitsInMemory(), var3, var13);
                } else {
                    var7 = var4.createPalette(var0, var2);
                    var6 = new SimpleBitStorage(var4.bitsInMemory(), var3, var9);
                }
            }
            catch (SimpleBitStorage.InitializationException var10) {
                return DataResult.error(() -> "Failed to read PalettedContainer: " + var10.getMessage());
            }
        }
        return DataResult.success(new PalettedContainer<T>(var0, var4, var6, var7));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PalettedContainerRO.PackedData<T> pack(Strategy<T> var0) {
        this.acquire();
        try {
            Optional<LongStream> var7;
            BitStorage var1 = this.data.storage;
            Palette var2 = this.data.palette;
            HashMapPalette var3 = new HashMapPalette(var1.getBits());
            int var4 = var0.entryCount();
            int[] var5 = PalettedContainer.reencodeContents(var1, var2, var3);
            Configuration var6 = var0.getConfigurationForPaletteSize(var3.getSize());
            int var8 = var6.bitsInStorage();
            if (var8 != 0) {
                SimpleBitStorage var9 = new SimpleBitStorage(var8, var4, var5);
                var7 = Optional.of(Arrays.stream(var9.getRaw()));
            } else {
                var7 = Optional.empty();
            }
            PalettedContainerRO.PackedData packedData = new PalettedContainerRO.PackedData(var3.getEntries(), var7, var8);
            return packedData;
        }
        finally {
            this.release();
        }
    }

    private static <T> int[] reencodeContents(BitStorage var0, Palette<T> var1, Palette<T> var2) {
        int[] var3 = new int[var0.getSize()];
        var0.unpack(var3);
        PaletteResize var4 = PaletteResize.noResizeExpected();
        int var5 = -1;
        int var6 = -1;
        for (int var7 = 0; var7 < var3.length; ++var7) {
            int var8 = var3[var7];
            if (var8 != var5) {
                var5 = var8;
                var6 = var2.idFor(var1.valueFor(var8), var4);
            }
            var3[var7] = var6;
        }
        return var3;
    }

    @Override
    public int getSerializedSize() {
        return this.data.getSerializedSize(this.strategy.globalMap());
    }

    @Override
    public int bitsPerEntry() {
        return this.data.storage().getBits();
    }

    @Override
    public boolean maybeHas(Predicate<T> var0) {
        return this.data.palette.maybeHas(var0);
    }

    @Override
    public PalettedContainer<T> copy() {
        return new PalettedContainer<T>(this);
    }

    @Override
    public PalettedContainer<T> recreate() {
        return new PalettedContainer(this.data.palette.valueFor(0), this.strategy);
    }

    @Override
    public void count(CountConsumer<T> var0) {
        if (this.data.palette.getSize() == 1) {
            var0.accept(this.data.palette.valueFor(0), this.data.storage.getSize());
            return;
        }
        Int2IntOpenHashMap var12 = new Int2IntOpenHashMap();
        this.data.storage.getAll((int var1) -> var12.addTo(var1, 1));
        var12.int2IntEntrySet().forEach(var1 -> var0.accept(this.data.palette.valueFor(var1.getIntKey()), var1.getIntValue()));
    }

    static final class Data<T>
    extends Record {
        private final Configuration configuration;
        final BitStorage storage;
        final Palette<T> palette;

        Data(Configuration var0, BitStorage var1, Palette<T> var2) {
            this.configuration = var0;
            this.storage = var1;
            this.palette = var2;
        }

        public void copyFrom(Palette<T> var0, BitStorage var1) {
            PaletteResize var2 = PaletteResize.noResizeExpected();
            for (int var3 = 0; var3 < var1.getSize(); ++var3) {
                T var4 = var0.valueFor(var1.get(var3));
                this.storage.set(var3, this.palette.idFor(var4, var2));
            }
        }

        public int getSerializedSize(IdMap<T> var0) {
            return 1 + this.palette.getSerializedSize(var0) + this.storage.getRaw().length * 8;
        }

        public void write(FriendlyByteBuf var0, IdMap<T> var1) {
            var0.writeByte(this.storage.getBits());
            this.palette.write(var0, var1);
            var0.writeFixedSizeLongArray(this.storage.getRaw());
        }

        public Data<T> copy() {
            return new Data<T>(this.configuration, this.storage.copy(), this.palette.copy());
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Data.class, "configuration;storage;palette", "configuration", "storage", "palette"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Data.class, "configuration;storage;palette", "configuration", "storage", "palette"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Data.class, "configuration;storage;palette", "configuration", "storage", "palette"}, this, var0);
        }

        public Configuration configuration() {
            return this.configuration;
        }

        public BitStorage storage() {
            return this.storage;
        }

        public Palette<T> palette() {
            return this.palette;
        }
    }

    @FunctionalInterface
    public static interface CountConsumer<T> {
        public void accept(T var1, int var2);
    }
}

