/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.thread.ConsecutiveExecutor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import net.minecraft.world.level.entity.ChunkEntities;
import net.minecraft.world.level.entity.EntityPersistentStorage;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import org.slf4j.Logger;

public class EntityStorage
implements EntityPersistentStorage<Entity> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String ENTITIES_TAG = "Entities";
    private static final String POSITION_TAG = "Position";
    public final ServerLevel level;
    private final SimpleRegionStorage simpleRegionStorage;
    private final LongSet emptyChunks = new LongOpenHashSet();
    public final ConsecutiveExecutor entityDeserializerQueue;

    public EntityStorage(SimpleRegionStorage var0, ServerLevel var1, Executor var2) {
        this.simpleRegionStorage = var0;
        this.level = var1;
        this.entityDeserializerQueue = new ConsecutiveExecutor(var2, "entity-deserializer");
    }

    @Override
    public CompletableFuture<ChunkEntities<Entity>> loadEntities(ChunkPos var0) {
        if (this.emptyChunks.contains(var0.toLong())) {
            return CompletableFuture.completedFuture(EntityStorage.emptyChunk(var0));
        }
        CompletableFuture<Optional<CompoundTag>> var12 = this.simpleRegionStorage.read(var0);
        this.reportLoadFailureIfPresent(var12, var0);
        return var12.thenApplyAsync(var1 -> {
            Object var2;
            if (var1.isEmpty()) {
                this.emptyChunks.add(var0.toLong());
                return EntityStorage.emptyChunk(var0);
            }
            try {
                var2 = ((CompoundTag)var1.get()).read(POSITION_TAG, ChunkPos.CODEC).orElseThrow();
                if (!Objects.equals(var0, var2)) {
                    LOGGER.error("Chunk file at {} is in the wrong location. (Expected {}, got {})", new Object[]{var0, var0, var2});
                    this.level.getServer().reportMisplacedChunk((ChunkPos)var2, var0, this.simpleRegionStorage.storageInfo());
                }
            }
            catch (Exception var22) {
                LOGGER.warn("Failed to parse chunk {} position info", (Object)var0, (Object)var22);
                this.level.getServer().reportChunkLoadFailure(var22, this.simpleRegionStorage.storageInfo(), var0);
            }
            var2 = this.simpleRegionStorage.upgradeChunkTag((CompoundTag)var1.get(), -1);
            try (ProblemReporter.ScopedCollector var3 = new ProblemReporter.ScopedCollector(ChunkAccess.problemPath(var0), LOGGER);){
                ValueInput var4 = TagValueInput.create((ProblemReporter)var3, (HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)var2);
                ValueInput.ValueInputList var5 = var4.childrenListOrEmpty(ENTITIES_TAG);
                List<Entity> var6 = EntityType.loadEntitiesRecursive(var5, this.level, EntitySpawnReason.LOAD).toList();
                ChunkEntities<Entity> chunkEntities = new ChunkEntities<Entity>(var0, var6);
                return chunkEntities;
            }
        }, this.entityDeserializerQueue::schedule);
    }

    private static ChunkEntities<Entity> emptyChunk(ChunkPos var0) {
        return new ChunkEntities<Entity>(var0, List.of());
    }

    @Override
    public void storeEntities(ChunkEntities<Entity> var0) {
        ChunkPos var1 = var0.getPos();
        if (var0.isEmpty()) {
            if (this.emptyChunks.add(var1.toLong())) {
                this.reportSaveFailureIfPresent(this.simpleRegionStorage.write(var1, IOWorker.STORE_EMPTY), var1);
            }
            return;
        }
        try (ProblemReporter.ScopedCollector var22 = new ProblemReporter.ScopedCollector(ChunkAccess.problemPath(var1), LOGGER);){
            ListTag var3 = new ListTag();
            var0.getEntities().forEach(var2 -> {
                TagValueOutput var3 = TagValueOutput.createWithContext(var22.forChild(var2.problemPath()), var2.registryAccess());
                if (var2.save(var3)) {
                    CompoundTag var4 = var3.buildResult();
                    var3.add(var4);
                }
            });
            CompoundTag var4 = NbtUtils.addCurrentDataVersion(new CompoundTag());
            var4.put(ENTITIES_TAG, var3);
            var4.store(POSITION_TAG, ChunkPos.CODEC, var1);
            this.reportSaveFailureIfPresent(this.simpleRegionStorage.write(var1, var4), var1);
            this.emptyChunks.remove(var1.toLong());
        }
    }

    private void reportSaveFailureIfPresent(CompletableFuture<?> var0, ChunkPos var12) {
        var0.exceptionally(var1 -> {
            LOGGER.error("Failed to store entity chunk {}", (Object)var12, var1);
            this.level.getServer().reportChunkSaveFailure((Throwable)var1, this.simpleRegionStorage.storageInfo(), var12);
            return null;
        });
    }

    private void reportLoadFailureIfPresent(CompletableFuture<?> var0, ChunkPos var12) {
        var0.exceptionally(var1 -> {
            LOGGER.error("Failed to load entity chunk {}", (Object)var12, var1);
            this.level.getServer().reportChunkLoadFailure((Throwable)var1, this.simpleRegionStorage.storageInfo(), var12);
            return null;
        });
    }

    @Override
    public void flush(boolean var0) {
        this.simpleRegionStorage.synchronize(var0).join();
        this.entityDeserializerQueue.runAll();
    }

    @Override
    public void close() throws IOException {
        this.simpleRegionStorage.close();
    }
}

