/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.LegacyTagFixer;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.apache.commons.io.FileUtils;

public class RecreatingSimpleRegionStorage
extends SimpleRegionStorage {
    private final IOWorker writeWorker;
    private final Path writeFolder;

    public RecreatingSimpleRegionStorage(RegionStorageInfo var0, Path var1, RegionStorageInfo var2, Path var3, DataFixer var4, boolean var5, DataFixTypes var6, Supplier<LegacyTagFixer> var7) {
        super(var0, var1, var4, var5, var6, var7);
        this.writeFolder = var3;
        this.writeWorker = new IOWorker(var2, var3, var5);
    }

    @Override
    public CompletableFuture<Void> write(ChunkPos var0, Supplier<CompoundTag> var1) {
        this.markChunkDone(var0);
        return this.writeWorker.store(var0, var1);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.writeWorker.close();
        if (this.writeFolder.toFile().exists()) {
            FileUtils.deleteDirectory((File)this.writeFolder.toFile());
        }
    }
}

