/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.ExceptionCollector;
import net.minecraft.util.FileUtil;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.jspecify.annotations.Nullable;

public final class RegionFileStorage
implements AutoCloseable {
    public static final String ANVIL_EXTENSION = ".mca";
    private static final int MAX_CACHE_SIZE = 256;
    public final Long2ObjectLinkedOpenHashMap<RegionFile> regionCache = new Long2ObjectLinkedOpenHashMap();
    private final RegionStorageInfo info;
    private final Path folder;
    private final boolean sync;

    RegionFileStorage(RegionStorageInfo regionstorageinfo, Path path, boolean flag) {
        this.folder = path;
        this.sync = flag;
        this.info = regionstorageinfo;
    }

    private RegionFile getRegionFile(ChunkPos chunkcoordintpair, boolean existingOnly) throws IOException {
        long i = ChunkPos.asLong(chunkcoordintpair.getRegionX(), chunkcoordintpair.getRegionZ());
        RegionFile regionfile = (RegionFile)this.regionCache.getAndMoveToFirst(i);
        if (regionfile != null) {
            return regionfile;
        }
        if (this.regionCache.size() >= 256) {
            ((RegionFile)this.regionCache.removeLast()).close();
        }
        FileUtil.createDirectoriesSafe(this.folder);
        Path path = this.folder;
        int j = chunkcoordintpair.getRegionX();
        Path path1 = path.resolve("r." + j + "." + chunkcoordintpair.getRegionZ() + ANVIL_EXTENSION);
        if (existingOnly && !Files.exists(path1, new LinkOption[0])) {
            return null;
        }
        RegionFile regionfile1 = new RegionFile(this.info, path1, this.folder, this.sync);
        this.regionCache.putAndMoveToFirst(i, (Object)regionfile1);
        return regionfile1;
    }

    public @Nullable CompoundTag read(ChunkPos chunkcoordintpair) throws IOException {
        RegionFile regionfile = this.getRegionFile(chunkcoordintpair, true);
        if (regionfile == null) {
            return null;
        }
        try (DataInputStream datainputstream = regionfile.getChunkDataInputStream(chunkcoordintpair);){
            if (datainputstream == null) {
                CompoundTag compoundTag = null;
                return compoundTag;
            }
            CompoundTag compoundTag = NbtIo.read(datainputstream);
            return compoundTag;
        }
    }

    public void scanChunk(ChunkPos chunkcoordintpair, StreamTagVisitor streamtagvisitor) throws IOException {
        RegionFile regionfile = this.getRegionFile(chunkcoordintpair, true);
        if (regionfile == null) {
            return;
        }
        try (DataInputStream datainputstream = regionfile.getChunkDataInputStream(chunkcoordintpair);){
            if (datainputstream != null) {
                NbtIo.parse(datainputstream, streamtagvisitor, NbtAccounter.unlimitedHeap());
            }
        }
    }

    protected void write(ChunkPos chunkcoordintpair, @Nullable CompoundTag nbttagcompound) throws IOException {
        if (!SharedConstants.DEBUG_DONT_SAVE_WORLD) {
            RegionFile regionfile = this.getRegionFile(chunkcoordintpair, false);
            if (nbttagcompound == null) {
                regionfile.clear(chunkcoordintpair);
            } else {
                try (DataOutputStream dataoutputstream = regionfile.getChunkDataOutputStream(chunkcoordintpair);){
                    NbtIo.write(nbttagcompound, dataoutputstream);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        ExceptionCollector<IOException> exceptionsuppressor = new ExceptionCollector<IOException>();
        for (RegionFile regionfile : this.regionCache.values()) {
            try {
                regionfile.close();
            }
            catch (IOException ioexception) {
                exceptionsuppressor.add(ioexception);
            }
        }
        exceptionsuppressor.throwIfPresent();
    }

    public void flush() throws IOException {
        for (RegionFile regionfile : this.regionCache.values()) {
            regionfile.flush();
        }
    }

    public RegionStorageInfo info() {
        return this.info;
    }
}

