/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension.end;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.SpikeConfiguration;
import org.bukkit.event.entity.EntityRemoveEvent;

public enum DragonRespawnAnimation {
    START{

        @Override
        public void tick(ServerLevel worldserver, EndDragonFight enderdragonbattle, List<EndCrystal> list, int i, BlockPos blockposition) {
            BlockPos blockposition1 = new BlockPos(0, 128, 0);
            for (EndCrystal entityendercrystal : list) {
                entityendercrystal.setBeamTarget(blockposition1);
            }
            enderdragonbattle.setRespawnStage(PREPARING_TO_SUMMON_PILLARS);
        }
    }
    ,
    PREPARING_TO_SUMMON_PILLARS{

        @Override
        public void tick(ServerLevel worldserver, EndDragonFight enderdragonbattle, List<EndCrystal> list, int i, BlockPos blockposition) {
            if (i < 100) {
                if (i == 0 || i == 50 || i == 51 || i == 52 || i >= 95) {
                    worldserver.levelEvent(3001, new BlockPos(0, 128, 0), 0);
                }
            } else {
                enderdragonbattle.setRespawnStage(SUMMONING_PILLARS);
            }
        }
    }
    ,
    SUMMONING_PILLARS{

        @Override
        public void tick(ServerLevel worldserver, EndDragonFight enderdragonbattle, List<EndCrystal> list, int i, BlockPos blockposition) {
            boolean flag1;
            int j = 40;
            boolean flag = i % 40 == 0;
            boolean bl = flag1 = i % 40 == 39;
            if (flag || flag1) {
                int k = i / 40;
                List<SpikeFeature.EndSpike> list1 = SpikeFeature.getSpikesForLevel(worldserver);
                if (k < list1.size()) {
                    SpikeFeature.EndSpike worldgenender_spike = list1.get(k);
                    if (flag) {
                        for (EndCrystal entityendercrystal : list) {
                            entityendercrystal.setBeamTarget(new BlockPos(worldgenender_spike.getCenterX(), worldgenender_spike.getHeight() + 1, worldgenender_spike.getCenterZ()));
                        }
                    } else {
                        int l = 10;
                        for (BlockPos blockposition1 : BlockPos.betweenClosed(new BlockPos(worldgenender_spike.getCenterX() - 10, worldgenender_spike.getHeight() - 10, worldgenender_spike.getCenterZ() - 10), new BlockPos(worldgenender_spike.getCenterX() + 10, worldgenender_spike.getHeight() + 10, worldgenender_spike.getCenterZ() + 10))) {
                            worldserver.removeBlock(blockposition1, false);
                        }
                        worldserver.explode(null, (float)worldgenender_spike.getCenterX() + 0.5f, worldgenender_spike.getHeight(), (float)worldgenender_spike.getCenterZ() + 0.5f, 5.0f, Level.ExplosionInteraction.BLOCK);
                        SpikeConfiguration worldgenfeatureendspikeconfiguration = new SpikeConfiguration(true, (List<SpikeFeature.EndSpike>)ImmutableList.of((Object)worldgenender_spike), new BlockPos(0, 128, 0));
                        Feature.END_SPIKE.place(worldgenfeatureendspikeconfiguration, worldserver, worldserver.getChunkSource().getGenerator(), RandomSource.create(), new BlockPos(worldgenender_spike.getCenterX(), 45, worldgenender_spike.getCenterZ()));
                    }
                } else if (flag) {
                    enderdragonbattle.setRespawnStage(SUMMONING_DRAGON);
                }
            }
        }
    }
    ,
    SUMMONING_DRAGON{

        @Override
        public void tick(ServerLevel worldserver, EndDragonFight enderdragonbattle, List<EndCrystal> list, int i, BlockPos blockposition) {
            if (i >= 100) {
                enderdragonbattle.setRespawnStage(END);
                enderdragonbattle.resetSpikeCrystals();
                for (EndCrystal entityendercrystal : list) {
                    entityendercrystal.setBeamTarget(null);
                    worldserver.explode(entityendercrystal, entityendercrystal.getX(), entityendercrystal.getY(), entityendercrystal.getZ(), 6.0f, Level.ExplosionInteraction.NONE);
                    entityendercrystal.discard(EntityRemoveEvent.Cause.EXPLODE);
                }
            } else if (i >= 80) {
                worldserver.levelEvent(3001, new BlockPos(0, 128, 0), 0);
            } else if (i == 0) {
                for (EndCrystal entityendercrystal1 : list) {
                    entityendercrystal1.setBeamTarget(new BlockPos(0, 128, 0));
                }
            } else if (i < 5) {
                worldserver.levelEvent(3001, new BlockPos(0, 128, 0), 0);
            }
        }
    }
    ,
    END{

        @Override
        public void tick(ServerLevel worldserver, EndDragonFight enderdragonbattle, List<EndCrystal> list, int i, BlockPos blockposition) {
        }
    };


    public abstract void tick(ServerLevel var1, EndDragonFight var2, List<EndCrystal> var3, int var4, BlockPos var5);
}

