/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gamerules;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.gamerules.GameRule;
import net.minecraft.world.level.gamerules.GameRuleCategory;
import net.minecraft.world.level.gamerules.GameRuleMap;
import net.minecraft.world.level.gamerules.GameRuleType;
import net.minecraft.world.level.gamerules.GameRuleTypeVisitor;
import org.jspecify.annotations.Nullable;

public class GameRules {
    public static final GameRule<Boolean> ADVANCE_TIME = GameRules.registerBoolean("advance_time", GameRuleCategory.UPDATES, !SharedConstants.DEBUG_WORLD_RECREATE);
    public static final GameRule<Boolean> ADVANCE_WEATHER = GameRules.registerBoolean("advance_weather", GameRuleCategory.UPDATES, !SharedConstants.DEBUG_WORLD_RECREATE);
    public static final GameRule<Boolean> ALLOW_ENTERING_NETHER_USING_PORTALS = GameRules.registerBoolean("allow_entering_nether_using_portals", GameRuleCategory.MISC, true);
    public static final GameRule<Boolean> BLOCK_DROPS = GameRules.registerBoolean("block_drops", GameRuleCategory.DROPS, true);
    public static final GameRule<Boolean> BLOCK_EXPLOSION_DROP_DECAY = GameRules.registerBoolean("block_explosion_drop_decay", GameRuleCategory.DROPS, true);
    public static final GameRule<Boolean> COMMAND_BLOCKS_WORK = GameRules.registerBoolean("command_blocks_work", GameRuleCategory.MISC, true);
    public static final GameRule<Boolean> COMMAND_BLOCK_OUTPUT = GameRules.registerBoolean("command_block_output", GameRuleCategory.CHAT, true);
    public static final GameRule<Boolean> DROWNING_DAMAGE = GameRules.registerBoolean("drowning_damage", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> ELYTRA_MOVEMENT_CHECK = GameRules.registerBoolean("elytra_movement_check", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> ENDER_PEARLS_VANISH_ON_DEATH = GameRules.registerBoolean("ender_pearls_vanish_on_death", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> ENTITY_DROPS = GameRules.registerBoolean("entity_drops", GameRuleCategory.DROPS, true);
    public static final GameRule<Boolean> FALL_DAMAGE = GameRules.registerBoolean("fall_damage", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> FIRE_DAMAGE = GameRules.registerBoolean("fire_damage", GameRuleCategory.PLAYER, true);
    public static final GameRule<Integer> FIRE_SPREAD_RADIUS_AROUND_PLAYER = GameRules.registerInteger("fire_spread_radius_around_player", GameRuleCategory.UPDATES, 128, -1);
    public static final GameRule<Boolean> FORGIVE_DEAD_PLAYERS = GameRules.registerBoolean("forgive_dead_players", GameRuleCategory.MOBS, true);
    public static final GameRule<Boolean> FREEZE_DAMAGE = GameRules.registerBoolean("freeze_damage", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> GLOBAL_SOUND_EVENTS = GameRules.registerBoolean("global_sound_events", GameRuleCategory.MISC, true);
    public static final GameRule<Boolean> IMMEDIATE_RESPAWN = GameRules.registerBoolean("immediate_respawn", GameRuleCategory.PLAYER, false);
    public static final GameRule<Boolean> KEEP_INVENTORY = GameRules.registerBoolean("keep_inventory", GameRuleCategory.PLAYER, false);
    public static final GameRule<Boolean> LAVA_SOURCE_CONVERSION = GameRules.registerBoolean("lava_source_conversion", GameRuleCategory.UPDATES, false);
    public static final GameRule<Boolean> LIMITED_CRAFTING = GameRules.registerBoolean("limited_crafting", GameRuleCategory.PLAYER, false);
    public static final GameRule<Boolean> LOCATOR_BAR = GameRules.registerBoolean("locator_bar", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> LOG_ADMIN_COMMANDS = GameRules.registerBoolean("log_admin_commands", GameRuleCategory.CHAT, true);
    public static final GameRule<Integer> MAX_BLOCK_MODIFICATIONS = GameRules.registerInteger("max_block_modifications", GameRuleCategory.MISC, 32768, 1);
    public static final GameRule<Integer> MAX_COMMAND_FORKS = GameRules.registerInteger("max_command_forks", GameRuleCategory.MISC, 65536, 0);
    public static final GameRule<Integer> MAX_COMMAND_SEQUENCE_LENGTH = GameRules.registerInteger("max_command_sequence_length", GameRuleCategory.MISC, 65536, 0);
    public static final GameRule<Integer> MAX_ENTITY_CRAMMING = GameRules.registerInteger("max_entity_cramming", GameRuleCategory.MOBS, 24, 0);
    public static final GameRule<Integer> MAX_MINECART_SPEED = GameRules.registerInteger("max_minecart_speed", GameRuleCategory.MISC, 8, 1, 1000, FeatureFlagSet.of(FeatureFlags.MINECART_IMPROVEMENTS));
    public static final GameRule<Integer> MAX_SNOW_ACCUMULATION_HEIGHT = GameRules.registerInteger("max_snow_accumulation_height", GameRuleCategory.UPDATES, 1, 0, 8);
    public static final GameRule<Boolean> MOB_DROPS = GameRules.registerBoolean("mob_drops", GameRuleCategory.DROPS, true);
    public static final GameRule<Boolean> MOB_EXPLOSION_DROP_DECAY = GameRules.registerBoolean("mob_explosion_drop_decay", GameRuleCategory.DROPS, true);
    public static final GameRule<Boolean> MOB_GRIEFING = GameRules.registerBoolean("mob_griefing", GameRuleCategory.MOBS, true);
    public static final GameRule<Boolean> NATURAL_HEALTH_REGENERATION = GameRules.registerBoolean("natural_health_regeneration", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> PLAYER_MOVEMENT_CHECK = GameRules.registerBoolean("player_movement_check", GameRuleCategory.PLAYER, true);
    public static final GameRule<Integer> PLAYERS_NETHER_PORTAL_CREATIVE_DELAY = GameRules.registerInteger("players_nether_portal_creative_delay", GameRuleCategory.PLAYER, 0, 0);
    public static final GameRule<Integer> PLAYERS_NETHER_PORTAL_DEFAULT_DELAY = GameRules.registerInteger("players_nether_portal_default_delay", GameRuleCategory.PLAYER, 80, 0);
    public static final GameRule<Integer> PLAYERS_SLEEPING_PERCENTAGE = GameRules.registerInteger("players_sleeping_percentage", GameRuleCategory.PLAYER, 100, 0);
    public static final GameRule<Boolean> PROJECTILES_CAN_BREAK_BLOCKS = GameRules.registerBoolean("projectiles_can_break_blocks", GameRuleCategory.DROPS, true);
    public static final GameRule<Boolean> PVP = GameRules.registerBoolean("pvp", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> RAIDS = GameRules.registerBoolean("raids", GameRuleCategory.MOBS, true);
    public static final GameRule<Integer> RANDOM_TICK_SPEED = GameRules.registerInteger("random_tick_speed", GameRuleCategory.UPDATES, 3, 0);
    public static final GameRule<Boolean> REDUCED_DEBUG_INFO = GameRules.registerBoolean("reduced_debug_info", GameRuleCategory.MISC, false);
    public static final GameRule<Integer> RESPAWN_RADIUS = GameRules.registerInteger("respawn_radius", GameRuleCategory.PLAYER, 10, 0);
    public static final GameRule<Boolean> SEND_COMMAND_FEEDBACK = GameRules.registerBoolean("send_command_feedback", GameRuleCategory.CHAT, true);
    public static final GameRule<Boolean> SHOW_ADVANCEMENT_MESSAGES = GameRules.registerBoolean("show_advancement_messages", GameRuleCategory.CHAT, true);
    public static final GameRule<Boolean> SHOW_DEATH_MESSAGES = GameRules.registerBoolean("show_death_messages", GameRuleCategory.CHAT, true);
    public static final GameRule<Boolean> SPAWNER_BLOCKS_WORK = GameRules.registerBoolean("spawner_blocks_work", GameRuleCategory.MISC, true);
    public static final GameRule<Boolean> SPAWN_MOBS = GameRules.registerBoolean("spawn_mobs", GameRuleCategory.SPAWNING, true);
    public static final GameRule<Boolean> SPAWN_MONSTERS = GameRules.registerBoolean("spawn_monsters", GameRuleCategory.SPAWNING, true);
    public static final GameRule<Boolean> SPAWN_PATROLS = GameRules.registerBoolean("spawn_patrols", GameRuleCategory.SPAWNING, true);
    public static final GameRule<Boolean> SPAWN_PHANTOMS = GameRules.registerBoolean("spawn_phantoms", GameRuleCategory.SPAWNING, true);
    public static final GameRule<Boolean> SPAWN_WANDERING_TRADERS = GameRules.registerBoolean("spawn_wandering_traders", GameRuleCategory.SPAWNING, true);
    public static final GameRule<Boolean> SPAWN_WARDENS = GameRules.registerBoolean("spawn_wardens", GameRuleCategory.SPAWNING, true);
    public static final GameRule<Boolean> SPECTATORS_GENERATE_CHUNKS = GameRules.registerBoolean("spectators_generate_chunks", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> SPREAD_VINES = GameRules.registerBoolean("spread_vines", GameRuleCategory.UPDATES, true);
    public static final GameRule<Boolean> TNT_EXPLODES = GameRules.registerBoolean("tnt_explodes", GameRuleCategory.MISC, true);
    public static final GameRule<Boolean> TNT_EXPLOSION_DROP_DECAY = GameRules.registerBoolean("tnt_explosion_drop_decay", GameRuleCategory.DROPS, false);
    public static final GameRule<Boolean> UNIVERSAL_ANGER = GameRules.registerBoolean("universal_anger", GameRuleCategory.MOBS, false);
    public static final GameRule<Boolean> WATER_SOURCE_CONVERSION = GameRules.registerBoolean("water_source_conversion", GameRuleCategory.UPDATES, true);
    private final GameRuleMap rules;

    public static Codec<GameRules> codec(FeatureFlagSet featureflagset) {
        return GameRuleMap.CODEC.xmap(gamerulemap -> new GameRules(featureflagset, (GameRuleMap)gamerulemap), gamerules -> gamerules.rules);
    }

    public GameRules(FeatureFlagSet featureflagset, GameRuleMap gamerulemap) {
        this(featureflagset);
        GameRuleMap gamerulemap1 = this.rules;
        GameRuleMap gamerulemap2 = this.rules;
        Objects.requireNonNull(this.rules);
        gamerulemap1.setFromIf(gamerulemap, gamerulemap2::has);
    }

    public GameRules(FeatureFlagSet featureflagset) {
        this.rules = GameRuleMap.of(BuiltInRegistries.GAME_RULE.filterFeatures(featureflagset).listElements().map(Holder::value));
    }

    public Stream<GameRule<?>> availableRules() {
        return this.rules.keySet().stream();
    }

    public <T> T get(GameRule<T> gamerule) {
        T t0 = this.rules.get(gamerule);
        if (t0 == null) {
            throw new IllegalArgumentException("Tried to access invalid game rule");
        }
        return t0;
    }

    public <T> void set(GameRule<T> gamerule, T t0, @Nullable ServerLevel minecraftserver) {
        if (!this.rules.has(gamerule)) {
            throw new IllegalArgumentException("Tried to set invalid game rule");
        }
        this.rules.set(gamerule, t0);
        if (minecraftserver != null) {
            MinecraftServer.onGameRuleChanged(gamerule, t0, minecraftserver);
        }
    }

    public GameRules copy(FeatureFlagSet featureflagset) {
        return new GameRules(featureflagset, this.rules);
    }

    public void setAll(GameRules gamerules, @Nullable ServerLevel minecraftserver) {
        this.setAll(gamerules.rules, minecraftserver);
    }

    public void setAll(GameRuleMap gamerulemap, @Nullable ServerLevel minecraftserver) {
        gamerulemap.keySet().forEach(gamerule -> this.setFromOther(gamerulemap, (GameRule)gamerule, minecraftserver));
    }

    private <T> void setFromOther(GameRuleMap gamerulemap, GameRule<T> gamerule, @Nullable ServerLevel minecraftserver) {
        this.set(gamerule, Objects.requireNonNull(gamerulemap.get(gamerule)), minecraftserver);
    }

    public void visitGameRuleTypes(GameRuleTypeVisitor gameruletypevisitor) {
        this.rules.keySet().forEach(gamerule -> {
            gameruletypevisitor.visit(gamerule);
            gamerule.callVisitor(gameruletypevisitor);
        });
    }

    private static GameRule<Boolean> registerBoolean(String s, GameRuleCategory gamerulecategory, boolean flag) {
        return GameRules.register(s, gamerulecategory, GameRuleType.BOOL, BoolArgumentType.bool(), Codec.BOOL, flag, FeatureFlagSet.of(), GameRuleTypeVisitor::visitBoolean, obool -> obool != false ? 1 : 0);
    }

    private static GameRule<Integer> registerInteger(String s, GameRuleCategory gamerulecategory, int i, int j) {
        return GameRules.registerInteger(s, gamerulecategory, i, j, Integer.MAX_VALUE, FeatureFlagSet.of());
    }

    private static GameRule<Integer> registerInteger(String s, GameRuleCategory gamerulecategory, int i, int j, int k) {
        return GameRules.registerInteger(s, gamerulecategory, i, j, k, FeatureFlagSet.of());
    }

    private static GameRule<Integer> registerInteger(String s, GameRuleCategory gamerulecategory, int i, int j, int k, FeatureFlagSet featureflagset) {
        return GameRules.register(s, gamerulecategory, GameRuleType.INT, IntegerArgumentType.integer((int)j, (int)k), Codec.intRange((int)j, (int)k), i, featureflagset, GameRuleTypeVisitor::visitInteger, integer -> integer);
    }

    private static <T> GameRule<T> register(String s, GameRuleCategory gamerulecategory, GameRuleType gameruletype, ArgumentType<T> argumenttype, Codec<T> codec, T t0, FeatureFlagSet featureflagset, VisitorCaller<T> gamerules_a, ToIntFunction<T> tointfunction) {
        return Registry.register(BuiltInRegistries.GAME_RULE, s, new GameRule<T>(gamerulecategory, gameruletype, argumenttype, gamerules_a, codec, tointfunction, t0, featureflagset));
    }

    public static GameRule<?> bootstrap(Registry<GameRule<?>> iregistry) {
        return ADVANCE_TIME;
    }

    public <T> String getAsString(GameRule<T> gamerule) {
        return gamerule.serialize(this.get(gamerule));
    }

    public static interface VisitorCaller<T> {
        public void call(GameRuleTypeVisitor var1, GameRule<T> var2);
    }
}

