/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.jspecify.annotations.Nullable;

public interface Aquifer {
    public static Aquifer create(NoiseChunk var0, ChunkPos var1, NoiseRouter var2, PositionalRandomFactory var3, int var4, int var5, FluidPicker var6) {
        return new NoiseBasedAquifer(var0, var1, var2, var3, var4, var5, var6);
    }

    public static Aquifer createDisabled(final FluidPicker var0) {
        return new Aquifer(){

            @Override
            public @Nullable BlockState computeSubstance(DensityFunction.FunctionContext var02, double var1) {
                if (var1 > 0.0) {
                    return null;
                }
                return var0.computeFluid(var02.blockX(), var02.blockY(), var02.blockZ()).at(var02.blockY());
            }

            @Override
            public boolean shouldScheduleFluidUpdate() {
                return false;
            }
        };
    }

    public @Nullable BlockState computeSubstance(DensityFunction.FunctionContext var1, double var2);

    public boolean shouldScheduleFluidUpdate();

    public static class NoiseBasedAquifer
    implements Aquifer {
        private static final int X_RANGE = 10;
        private static final int Y_RANGE = 9;
        private static final int Z_RANGE = 10;
        private static final int X_SEPARATION = 6;
        private static final int Y_SEPARATION = 3;
        private static final int Z_SEPARATION = 6;
        private static final int X_SPACING = 16;
        private static final int Y_SPACING = 12;
        private static final int Z_SPACING = 16;
        private static final int X_SPACING_SHIFT = 4;
        private static final int Z_SPACING_SHIFT = 4;
        private static final int MAX_REASONABLE_DISTANCE_TO_AQUIFER_CENTER = 11;
        private static final double FLOWING_UPDATE_SIMULARITY = NoiseBasedAquifer.similarity(Mth.square(10), Mth.square(12));
        private static final int SAMPLE_OFFSET_X = -5;
        private static final int SAMPLE_OFFSET_Y = 1;
        private static final int SAMPLE_OFFSET_Z = -5;
        private static final int MIN_CELL_SAMPLE_X = 0;
        private static final int MIN_CELL_SAMPLE_Y = -1;
        private static final int MIN_CELL_SAMPLE_Z = 0;
        private static final int MAX_CELL_SAMPLE_X = 1;
        private static final int MAX_CELL_SAMPLE_Y = 1;
        private static final int MAX_CELL_SAMPLE_Z = 1;
        private final NoiseChunk noiseChunk;
        private final DensityFunction barrierNoise;
        private final DensityFunction fluidLevelFloodednessNoise;
        private final DensityFunction fluidLevelSpreadNoise;
        private final DensityFunction lavaNoise;
        private final PositionalRandomFactory positionalRandomFactory;
        private final @Nullable FluidStatus[] aquiferCache;
        private final long[] aquiferLocationCache;
        private final FluidPicker globalFluidPicker;
        private final DensityFunction erosion;
        private final DensityFunction depth;
        private boolean shouldScheduleFluidUpdate;
        private final int skipSamplingAboveY;
        private final int minGridX;
        private final int minGridY;
        private final int minGridZ;
        private final int gridSizeX;
        private final int gridSizeZ;
        private static final int[][] SURFACE_SAMPLING_OFFSETS_IN_CHUNKS = new int[][]{{0, 0}, {-2, -1}, {-1, -1}, {0, -1}, {1, -1}, {-3, 0}, {-2, 0}, {-1, 0}, {1, 0}, {-2, 1}, {-1, 1}, {0, 1}, {1, 1}};

        NoiseBasedAquifer(NoiseChunk var0, ChunkPos var1, NoiseRouter var2, PositionalRandomFactory var3, int var4, int var5, FluidPicker var6) {
            this.noiseChunk = var0;
            this.barrierNoise = var2.barrierNoise();
            this.fluidLevelFloodednessNoise = var2.fluidLevelFloodednessNoise();
            this.fluidLevelSpreadNoise = var2.fluidLevelSpreadNoise();
            this.lavaNoise = var2.lavaNoise();
            this.erosion = var2.erosion();
            this.depth = var2.depth();
            this.positionalRandomFactory = var3;
            this.minGridX = NoiseBasedAquifer.gridX(var1.getMinBlockX() + -5) + 0;
            this.globalFluidPicker = var6;
            int var7 = NoiseBasedAquifer.gridX(var1.getMaxBlockX() + -5) + 1;
            this.gridSizeX = var7 - this.minGridX + 1;
            this.minGridY = NoiseBasedAquifer.gridY(var4 + 1) + -1;
            int var8 = NoiseBasedAquifer.gridY(var4 + var5 + 1) + 1;
            int var9 = var8 - this.minGridY + 1;
            this.minGridZ = NoiseBasedAquifer.gridZ(var1.getMinBlockZ() + -5) + 0;
            int var10 = NoiseBasedAquifer.gridZ(var1.getMaxBlockZ() + -5) + 1;
            this.gridSizeZ = var10 - this.minGridZ + 1;
            int var11 = this.gridSizeX * var9 * this.gridSizeZ;
            this.aquiferCache = new FluidStatus[var11];
            this.aquiferLocationCache = new long[var11];
            Arrays.fill(this.aquiferLocationCache, Long.MAX_VALUE);
            int var12 = this.adjustSurfaceLevel(var0.maxPreliminarySurfaceLevel(NoiseBasedAquifer.fromGridX(this.minGridX, 0), NoiseBasedAquifer.fromGridZ(this.minGridZ, 0), NoiseBasedAquifer.fromGridX(var7, 9), NoiseBasedAquifer.fromGridZ(var10, 9)));
            int var13 = NoiseBasedAquifer.gridY(var12 + 12) - -1;
            this.skipSamplingAboveY = NoiseBasedAquifer.fromGridY(var13, 11) - 1;
        }

        private int getIndex(int var0, int var1, int var2) {
            int var3 = var0 - this.minGridX;
            int var4 = var1 - this.minGridY;
            int var5 = var2 - this.minGridZ;
            return (var4 * this.gridSizeZ + var5) * this.gridSizeX + var3;
        }

        @Override
        public @Nullable BlockState computeSubstance(DensityFunction.FunctionContext var0, double var1) {
            boolean var34;
            double var32;
            double var30;
            BlockState var22;
            if (var1 > 0.0) {
                this.shouldScheduleFluidUpdate = false;
                return null;
            }
            int var3 = var0.blockX();
            int var4 = var0.blockY();
            int var5 = var0.blockZ();
            FluidStatus var6 = this.globalFluidPicker.computeFluid(var3, var4, var5);
            if (var4 > this.skipSamplingAboveY) {
                this.shouldScheduleFluidUpdate = false;
                return var6.at(var4);
            }
            if (var6.at(var4).is(Blocks.LAVA)) {
                this.shouldScheduleFluidUpdate = false;
                return SharedConstants.DEBUG_DISABLE_FLUID_GENERATION ? Blocks.AIR.defaultBlockState() : Blocks.LAVA.defaultBlockState();
            }
            int var7 = NoiseBasedAquifer.gridX(var3 + -5);
            int var8 = NoiseBasedAquifer.gridY(var4 + 1);
            int var9 = NoiseBasedAquifer.gridZ(var5 + -5);
            int var10 = Integer.MAX_VALUE;
            int var11 = Integer.MAX_VALUE;
            int var12 = Integer.MAX_VALUE;
            int var13 = Integer.MAX_VALUE;
            int var14 = 0;
            int var15 = 0;
            int var16 = 0;
            int var17 = 0;
            for (int var18 = 0; var18 <= 1; ++var18) {
                for (int var19 = -1; var19 <= 1; ++var19) {
                    for (int var20 = 0; var20 <= 1; ++var20) {
                        long var25;
                        int var21 = var7 + var18;
                        int var222 = var8 + var19;
                        int var23 = var9 + var20;
                        int var24 = this.getIndex(var21, var222, var23);
                        long var27 = this.aquiferLocationCache[var24];
                        if (var27 != Long.MAX_VALUE) {
                            var25 = var27;
                        } else {
                            RandomSource var29 = this.positionalRandomFactory.at(var21, var222, var23);
                            this.aquiferLocationCache[var24] = var25 = BlockPos.asLong(NoiseBasedAquifer.fromGridX(var21, var29.nextInt(10)), NoiseBasedAquifer.fromGridY(var222, var29.nextInt(9)), NoiseBasedAquifer.fromGridZ(var23, var29.nextInt(10)));
                        }
                        int var29 = BlockPos.getX(var25) - var3;
                        int var302 = BlockPos.getY(var25) - var4;
                        int var31 = BlockPos.getZ(var25) - var5;
                        int var322 = var29 * var29 + var302 * var302 + var31 * var31;
                        if (var10 >= var322) {
                            var17 = var16;
                            var16 = var15;
                            var15 = var14;
                            var14 = var24;
                            var13 = var12;
                            var12 = var11;
                            var11 = var10;
                            var10 = var322;
                            continue;
                        }
                        if (var11 >= var322) {
                            var17 = var16;
                            var16 = var15;
                            var15 = var24;
                            var13 = var12;
                            var12 = var11;
                            var11 = var322;
                            continue;
                        }
                        if (var12 >= var322) {
                            var17 = var16;
                            var16 = var24;
                            var13 = var12;
                            var12 = var322;
                            continue;
                        }
                        if (var13 < var322) continue;
                        var17 = var24;
                        var13 = var322;
                    }
                }
            }
            FluidStatus var18 = this.getAquiferStatus(var14);
            double var19 = NoiseBasedAquifer.similarity(var10, var11);
            BlockState var21 = var18.at(var4);
            BlockState blockState = var22 = SharedConstants.DEBUG_DISABLE_FLUID_GENERATION ? Blocks.AIR.defaultBlockState() : var21;
            if (var19 <= 0.0) {
                FluidStatus var23;
                this.shouldScheduleFluidUpdate = var19 >= FLOWING_UPDATE_SIMULARITY ? !var18.equals(var23 = this.getAquiferStatus(var15)) : false;
                return var22;
            }
            if (var21.is(Blocks.WATER) && this.globalFluidPicker.computeFluid(var3, var4 - 1, var5).at(var4 - 1).is(Blocks.LAVA)) {
                this.shouldScheduleFluidUpdate = true;
                return var22;
            }
            MutableDouble var23 = new MutableDouble(Double.NaN);
            FluidStatus var24 = this.getAquiferStatus(var15);
            double var25 = var19 * this.calculatePressure(var0, var23, var18, var24);
            if (var1 + var25 > 0.0) {
                this.shouldScheduleFluidUpdate = false;
                return null;
            }
            FluidStatus var27 = this.getAquiferStatus(var16);
            double var28 = NoiseBasedAquifer.similarity(var10, var12);
            if (var28 > 0.0 && var1 + (var30 = var19 * var28 * this.calculatePressure(var0, var23, var18, var27)) > 0.0) {
                this.shouldScheduleFluidUpdate = false;
                return null;
            }
            double var303 = NoiseBasedAquifer.similarity(var11, var12);
            if (var303 > 0.0 && var1 + (var32 = var19 * var303 * this.calculatePressure(var0, var23, var24, var27)) > 0.0) {
                this.shouldScheduleFluidUpdate = false;
                return null;
            }
            boolean var323 = !var18.equals(var24);
            boolean var33 = var303 >= FLOWING_UPDATE_SIMULARITY && !var24.equals(var27);
            boolean bl = var34 = var28 >= FLOWING_UPDATE_SIMULARITY && !var18.equals(var27);
            this.shouldScheduleFluidUpdate = var323 || var33 || var34 ? true : var28 >= FLOWING_UPDATE_SIMULARITY && NoiseBasedAquifer.similarity(var10, var13) >= FLOWING_UPDATE_SIMULARITY && !var18.equals(this.getAquiferStatus(var17));
            return var22;
        }

        @Override
        public boolean shouldScheduleFluidUpdate() {
            return this.shouldScheduleFluidUpdate;
        }

        private static double similarity(int var0, int var1) {
            double var2 = 25.0;
            return 1.0 - (double)(var1 - var0) / 25.0;
        }

        private double calculatePressure(DensityFunction.FunctionContext var0, MutableDouble var1, FluidStatus var2, FluidStatus var3) {
            double var32;
            double var30;
            int var4 = var0.blockY();
            BlockState var5 = var2.at(var4);
            BlockState var6 = var3.at(var4);
            if (var5.is(Blocks.LAVA) && var6.is(Blocks.WATER) || var5.is(Blocks.WATER) && var6.is(Blocks.LAVA)) {
                return 2.0;
            }
            int var7 = Math.abs(var2.fluidLevel - var3.fluidLevel);
            if (var7 == 0) {
                return 0.0;
            }
            double var8 = 0.5 * (double)(var2.fluidLevel + var3.fluidLevel);
            double var10 = (double)var4 + 0.5 - var8;
            double var12 = (double)var7 / 2.0;
            double var14 = 0.0;
            double var16 = 2.5;
            double var18 = 1.5;
            double var20 = 3.0;
            double var22 = 10.0;
            double var24 = 3.0;
            double var26 = var12 - Math.abs(var10);
            double var28 = var10 > 0.0 ? ((var30 = 0.0 + var26) > 0.0 ? var30 / 1.5 : var30 / 2.5) : ((var30 = 3.0 + var26) > 0.0 ? var30 / 3.0 : var30 / 10.0);
            var30 = 2.0;
            if (var28 < -2.0 || var28 > 2.0) {
                var32 = 0.0;
            } else {
                double var34 = var1.doubleValue();
                if (Double.isNaN(var34)) {
                    double var36 = this.barrierNoise.compute(var0);
                    var1.setValue(var36);
                    var32 = var36;
                } else {
                    var32 = var34;
                }
            }
            return 2.0 * (var32 + var28);
        }

        private static int gridX(int var0) {
            return var0 >> 4;
        }

        private static int fromGridX(int var0, int var1) {
            return (var0 << 4) + var1;
        }

        private static int gridY(int var0) {
            return Math.floorDiv(var0, 12);
        }

        private static int fromGridY(int var0, int var1) {
            return var0 * 12 + var1;
        }

        private static int gridZ(int var0) {
            return var0 >> 4;
        }

        private static int fromGridZ(int var0, int var1) {
            return (var0 << 4) + var1;
        }

        private FluidStatus getAquiferStatus(int var0) {
            FluidStatus var4;
            FluidStatus var1 = this.aquiferCache[var0];
            if (var1 != null) {
                return var1;
            }
            long var2 = this.aquiferLocationCache[var0];
            this.aquiferCache[var0] = var4 = this.computeFluid(BlockPos.getX(var2), BlockPos.getY(var2), BlockPos.getZ(var2));
            return var4;
        }

        private FluidStatus computeFluid(int var0, int var1, int var2) {
            FluidStatus var3 = this.globalFluidPicker.computeFluid(var0, var1, var2);
            int var4 = Integer.MAX_VALUE;
            int var5 = var1 + 12;
            int var6 = var1 - 12;
            boolean var7 = false;
            for (int[] var11 : SURFACE_SAMPLING_OFFSETS_IN_CHUNKS) {
                FluidStatus var18;
                boolean var17;
                boolean var16;
                int var12 = var0 + SectionPos.sectionToBlockCoord(var11[0]);
                int var13 = var2 + SectionPos.sectionToBlockCoord(var11[1]);
                int var14 = this.noiseChunk.preliminarySurfaceLevel(var12, var13);
                int var15 = this.adjustSurfaceLevel(var14);
                boolean bl = var16 = var11[0] == 0 && var11[1] == 0;
                if (var16 && var6 > var15) {
                    return var3;
                }
                boolean bl2 = var17 = var5 > var15;
                if ((var17 || var16) && !(var18 = this.globalFluidPicker.computeFluid(var12, var15, var13)).at(var15).isAir()) {
                    if (var16) {
                        var7 = true;
                    }
                    if (var17) {
                        return var18;
                    }
                }
                var4 = Math.min(var4, var14);
            }
            int var8 = this.computeSurfaceLevel(var0, var1, var2, var3, var4, var7);
            return new FluidStatus(var8, this.computeFluidType(var0, var1, var2, var3, var8));
        }

        private int adjustSurfaceLevel(int var0) {
            return var0 + 8;
        }

        private int computeSurfaceLevel(int var0, int var1, int var2, FluidStatus var3, int var4, boolean var5) {
            int var11;
            double var9;
            double var7;
            DensityFunction.SinglePointContext var6 = new DensityFunction.SinglePointContext(var0, var1, var2);
            if (OverworldBiomeBuilder.isDeepDarkRegion(this.erosion, this.depth, var6)) {
                var7 = -1.0;
                var9 = -1.0;
            } else {
                var11 = var4 + 8 - var1;
                int var12 = 64;
                double var13 = var5 ? Mth.clampedMap((double)var11, 0.0, 64.0, 1.0, 0.0) : 0.0;
                double var15 = Mth.clamp(this.fluidLevelFloodednessNoise.compute(var6), -1.0, 1.0);
                double var17 = Mth.map(var13, 1.0, 0.0, -0.3, 0.8);
                double var19 = Mth.map(var13, 1.0, 0.0, -0.8, 0.4);
                var7 = var15 - var19;
                var9 = var15 - var17;
            }
            var11 = var9 > 0.0 ? var3.fluidLevel : (var7 > 0.0 ? this.computeRandomizedFluidSurfaceLevel(var0, var1, var2, var4) : DimensionType.WAY_BELOW_MIN_Y);
            return var11;
        }

        private int computeRandomizedFluidSurfaceLevel(int var0, int var1, int var2, int var3) {
            int var4 = 16;
            int var5 = 40;
            int var6 = Math.floorDiv(var0, 16);
            int var7 = Math.floorDiv(var1, 40);
            int var8 = Math.floorDiv(var2, 16);
            int var9 = var7 * 40 + 20;
            int var10 = 10;
            double var11 = this.fluidLevelSpreadNoise.compute(new DensityFunction.SinglePointContext(var6, var7, var8)) * 10.0;
            int var13 = Mth.quantize(var11, 3);
            int var14 = var9 + var13;
            return Math.min(var3, var14);
        }

        private BlockState computeFluidType(int var0, int var1, int var2, FluidStatus var3, int var4) {
            BlockState var5 = var3.fluidType;
            if (var4 <= -10 && var4 != DimensionType.WAY_BELOW_MIN_Y && var3.fluidType != Blocks.LAVA.defaultBlockState()) {
                int var10;
                int var9;
                int var6 = 64;
                int var7 = 40;
                int var8 = Math.floorDiv(var0, 64);
                double var11 = this.lavaNoise.compute(new DensityFunction.SinglePointContext(var8, var9 = Math.floorDiv(var1, 40), var10 = Math.floorDiv(var2, 64)));
                if (Math.abs(var11) > 0.3) {
                    var5 = Blocks.LAVA.defaultBlockState();
                }
            }
            return var5;
        }
    }

    public static interface FluidPicker {
        public FluidStatus computeFluid(int var1, int var2, int var3);
    }

    public static final class FluidStatus
    extends Record {
        final int fluidLevel;
        final BlockState fluidType;

        public FluidStatus(int var0, BlockState var1) {
            this.fluidLevel = var0;
            this.fluidType = var1;
        }

        public BlockState at(int var0) {
            return var0 < this.fluidLevel ? this.fluidType : Blocks.AIR.defaultBlockState();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FluidStatus.class, "fluidLevel;fluidType", "fluidLevel", "fluidType"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FluidStatus.class, "fluidLevel;fluidType", "fluidLevel", "fluidType"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FluidStatus.class, "fluidLevel;fluidType", "fluidLevel", "fluidType"}, this, var0);
        }

        public int fluidLevel() {
            return this.fluidLevel;
        }

        public BlockState fluidType() {
            return this.fluidType;
        }
    }
}

