/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.Util;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.jspecify.annotations.Nullable;

public class Beardifier
implements DensityFunctions.BeardifierOrMarker {
    public static final int BEARD_KERNEL_RADIUS = 12;
    private static final int BEARD_KERNEL_SIZE = 24;
    private static final float[] BEARD_KERNEL = Util.make(new float[13824], var0 -> {
        for (int var1 = 0; var1 < 24; ++var1) {
            for (int var2 = 0; var2 < 24; ++var2) {
                for (int var3 = 0; var3 < 24; ++var3) {
                    var0[var1 * 24 * 24 + var2 * 24 + var3] = (float)Beardifier.computeBeardContribution(var2 - 12, var3 - 12, var1 - 12);
                }
            }
        }
    });
    public static final Beardifier EMPTY = new Beardifier(List.of(), List.of(), null);
    private final List<Rigid> pieces;
    private final List<JigsawJunction> junctions;
    private final @Nullable BoundingBox affectedBox;

    public static Beardifier forStructuresInChunk(StructureManager var02, ChunkPos var1) {
        List<StructureStart> var2 = var02.startsForStructure(var1, var0 -> var0.terrainAdaptation() != TerrainAdjustment.NONE);
        if (var2.isEmpty()) {
            return EMPTY;
        }
        int var3 = var1.getMinBlockX();
        int var4 = var1.getMinBlockZ();
        ArrayList<Rigid> var5 = new ArrayList<Rigid>();
        ArrayList<JigsawJunction> var6 = new ArrayList<JigsawJunction>();
        BoundingBox var7 = null;
        for (StructureStart var9 : var2) {
            TerrainAdjustment var10 = var9.getStructure().terrainAdaptation();
            for (StructurePiece var12 : var9.getPieces()) {
                if (!var12.isCloseToChunk(var1, 12)) continue;
                if (var12 instanceof PoolElementStructurePiece) {
                    PoolElementStructurePiece var13 = (PoolElementStructurePiece)var12;
                    StructureTemplatePool.Projection var14 = var13.getElement().getProjection();
                    if (var14 == StructureTemplatePool.Projection.RIGID) {
                        var5.add(new Rigid(var13.getBoundingBox(), var10, var13.getGroundLevelDelta()));
                        var7 = Beardifier.includeBoundingBox(var7, var12.getBoundingBox());
                    }
                    for (JigsawJunction var16 : var13.getJunctions()) {
                        int var17 = var16.getSourceX();
                        int var18 = var16.getSourceZ();
                        if (var17 <= var3 - 12 || var18 <= var4 - 12 || var17 >= var3 + 15 + 12 || var18 >= var4 + 15 + 12) continue;
                        var6.add(var16);
                        BoundingBox var19 = new BoundingBox(new BlockPos(var17, var16.getSourceGroundY(), var18));
                        var7 = Beardifier.includeBoundingBox(var7, var19);
                    }
                    continue;
                }
                var5.add(new Rigid(var12.getBoundingBox(), var10, 0));
                var7 = Beardifier.includeBoundingBox(var7, var12.getBoundingBox());
            }
        }
        if (var7 == null) {
            return EMPTY;
        }
        BoundingBox var8 = var7.inflatedBy(24);
        return new Beardifier(List.copyOf(var5), List.copyOf(var6), var8);
    }

    private static BoundingBox includeBoundingBox(@Nullable BoundingBox var0, BoundingBox var1) {
        if (var0 == null) {
            return var1;
        }
        return BoundingBox.encapsulating(var0, var1);
    }

    @VisibleForTesting
    public Beardifier(List<Rigid> var0, List<JigsawJunction> var1, @Nullable BoundingBox var2) {
        this.pieces = var0;
        this.junctions = var1;
        this.affectedBox = var2;
    }

    @Override
    public void fillArray(double[] var0, DensityFunction.ContextProvider var1) {
        if (this.affectedBox == null) {
            Arrays.fill(var0, 0.0);
        } else {
            DensityFunctions.BeardifierOrMarker.super.fillArray(var0, var1);
        }
    }

    @Override
    public double compute(DensityFunction.FunctionContext var0) {
        int var10;
        int var9;
        int var3;
        int var2;
        if (this.affectedBox == null) {
            return 0.0;
        }
        int var1 = var0.blockX();
        if (!this.affectedBox.isInside(var1, var2 = var0.blockY(), var3 = var0.blockZ())) {
            return 0.0;
        }
        double var4 = 0.0;
        for (Rigid rigid : this.pieces) {
            BoundingBox var8 = rigid.box();
            var9 = rigid.groundLevelDelta();
            var10 = Math.max(0, Math.max(var8.minX() - var1, var1 - var8.maxX()));
            int var11 = Math.max(0, Math.max(var8.minZ() - var3, var3 - var8.maxZ()));
            int var12 = var8.minY() + var9;
            int var13 = var2 - var12;
            int var14 = switch (rigid.terrainAdjustment()) {
                default -> throw new MatchException(null, null);
                case TerrainAdjustment.NONE -> 0;
                case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN -> var13;
                case TerrainAdjustment.BEARD_BOX -> Math.max(0, Math.max(var12 - var2, var2 - var8.maxY()));
                case TerrainAdjustment.ENCAPSULATE -> Math.max(0, Math.max(var8.minY() - var2, var2 - var8.maxY()));
            };
            var4 += (switch (rigid.terrainAdjustment()) {
                default -> throw new MatchException(null, null);
                case TerrainAdjustment.NONE -> 0.0;
                case TerrainAdjustment.BURY -> Beardifier.getBuryContribution(var10, (double)var14 / 2.0, var11);
                case TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> Beardifier.getBeardContribution(var10, var14, var11, var13) * 0.8;
                case TerrainAdjustment.ENCAPSULATE -> Beardifier.getBuryContribution((double)var10 / 2.0, (double)var14 / 2.0, (double)var11 / 2.0) * 0.8;
            });
        }
        for (JigsawJunction jigsawJunction : this.junctions) {
            int var8 = var1 - jigsawJunction.getSourceX();
            var9 = var2 - jigsawJunction.getSourceGroundY();
            var10 = var3 - jigsawJunction.getSourceZ();
            var4 += Beardifier.getBeardContribution(var8, var9, var10, var9) * 0.4;
        }
        return var4;
    }

    @Override
    public double minValue() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double maxValue() {
        return Double.POSITIVE_INFINITY;
    }

    private static double getBuryContribution(double var0, double var2, double var4) {
        double var6 = Mth.length(var0, var2, var4);
        return Mth.clampedMap(var6, 0.0, 6.0, 1.0, 0.0);
    }

    private static double getBeardContribution(int var0, int var1, int var2, int var3) {
        int var4 = var0 + 12;
        int var5 = var1 + 12;
        int var6 = var2 + 12;
        if (!(Beardifier.isInKernelRange(var4) && Beardifier.isInKernelRange(var5) && Beardifier.isInKernelRange(var6))) {
            return 0.0;
        }
        double var7 = (double)var3 + 0.5;
        double var9 = Mth.lengthSquared((double)var0, var7, (double)var2);
        double var11 = -var7 * Mth.fastInvSqrt(var9 / 2.0) / 2.0;
        return var11 * (double)BEARD_KERNEL[var6 * 24 * 24 + var4 * 24 + var5];
    }

    private static boolean isInKernelRange(int var0) {
        return var0 >= 0 && var0 < 24;
    }

    private static double computeBeardContribution(int var0, int var1, int var2) {
        return Beardifier.computeBeardContribution(var0, (double)var1 + 0.5, var2);
    }

    private static double computeBeardContribution(int var0, double var1, int var3) {
        double var4 = Mth.lengthSquared((double)var0, var1, (double)var3);
        double var6 = Math.pow(Math.E, -var4 / 16.0);
        return var6;
    }

    @VisibleForTesting
    public record Rigid(BoundingBox box, TerrainAdjustment terrainAdjustment, int groundLevelDelta) {
    }
}

