/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BambooLeaves;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;

public class BambooFeature
extends Feature<ProbabilityFeatureConfiguration> {
    private static final BlockState BAMBOO_TRUNK = (BlockState)((BlockState)((BlockState)Blocks.BAMBOO.defaultBlockState().setValue(BambooStalkBlock.AGE, 1)).setValue(BambooStalkBlock.LEAVES, BambooLeaves.NONE)).setValue(BambooStalkBlock.STAGE, 0);
    private static final BlockState BAMBOO_FINAL_LARGE = (BlockState)((BlockState)BAMBOO_TRUNK.setValue(BambooStalkBlock.LEAVES, BambooLeaves.LARGE)).setValue(BambooStalkBlock.STAGE, 1);
    private static final BlockState BAMBOO_TOP_LARGE = (BlockState)BAMBOO_TRUNK.setValue(BambooStalkBlock.LEAVES, BambooLeaves.LARGE);
    private static final BlockState BAMBOO_TOP_SMALL = (BlockState)BAMBOO_TRUNK.setValue(BambooStalkBlock.LEAVES, BambooLeaves.SMALL);

    public BambooFeature(Codec<ProbabilityFeatureConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<ProbabilityFeatureConfiguration> var0) {
        int var1 = 0;
        BlockPos var2 = var0.origin();
        WorldGenLevel var3 = var0.level();
        RandomSource var4 = var0.random();
        ProbabilityFeatureConfiguration var5 = var0.config();
        BlockPos.MutableBlockPos var6 = var2.mutable();
        BlockPos.MutableBlockPos var7 = var2.mutable();
        if (var3.isEmptyBlock(var6)) {
            if (Blocks.BAMBOO.defaultBlockState().canSurvive(var3, var6)) {
                int var9;
                int var8 = var4.nextInt(12) + 5;
                if (var4.nextFloat() < var5.probability) {
                    var9 = var4.nextInt(4) + 1;
                    for (int var10 = var2.getX() - var9; var10 <= var2.getX() + var9; ++var10) {
                        for (int var11 = var2.getZ() - var9; var11 <= var2.getZ() + var9; ++var11) {
                            int var13;
                            int var12 = var10 - var2.getX();
                            if (var12 * var12 + (var13 = var11 - var2.getZ()) * var13 > var9 * var9) continue;
                            var7.set(var10, var3.getHeight(Heightmap.Types.WORLD_SURFACE, var10, var11) - 1, var11);
                            if (!BambooFeature.isDirt(var3.getBlockState(var7))) continue;
                            var3.setBlock(var7, Blocks.PODZOL.defaultBlockState(), 2);
                        }
                    }
                }
                for (var9 = 0; var9 < var8 && var3.isEmptyBlock(var6); ++var9) {
                    var3.setBlock(var6, BAMBOO_TRUNK, 2);
                    var6.move(Direction.UP, 1);
                }
                if (var6.getY() - var2.getY() >= 3) {
                    var3.setBlock(var6, BAMBOO_FINAL_LARGE, 2);
                    var3.setBlock(var6.move(Direction.DOWN, 1), BAMBOO_TOP_LARGE, 2);
                    var3.setBlock(var6.move(Direction.DOWN, 1), BAMBOO_TOP_SMALL, 2);
                }
            }
            ++var1;
        }
        return var1 > 0;
    }
}

