/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BasaltPillarFeature
extends Feature<NoneFeatureConfiguration> {
    public BasaltPillarFeature(Codec<NoneFeatureConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> var0) {
        BlockPos var1 = var0.origin();
        WorldGenLevel var2 = var0.level();
        RandomSource var3 = var0.random();
        if (!var2.isEmptyBlock(var1) || var2.isEmptyBlock(var1.above())) {
            return false;
        }
        BlockPos.MutableBlockPos var4 = var1.mutable();
        BlockPos.MutableBlockPos var5 = var1.mutable();
        boolean var6 = true;
        boolean var7 = true;
        boolean var8 = true;
        boolean var9 = true;
        while (var2.isEmptyBlock(var4)) {
            if (var2.isOutsideBuildHeight(var4)) {
                return true;
            }
            var2.setBlock(var4, Blocks.BASALT.defaultBlockState(), 2);
            var6 = var6 && this.placeHangOff(var2, var3, var5.setWithOffset((Vec3i)var4, Direction.NORTH));
            var7 = var7 && this.placeHangOff(var2, var3, var5.setWithOffset((Vec3i)var4, Direction.SOUTH));
            var8 = var8 && this.placeHangOff(var2, var3, var5.setWithOffset((Vec3i)var4, Direction.WEST));
            var9 = var9 && this.placeHangOff(var2, var3, var5.setWithOffset((Vec3i)var4, Direction.EAST));
            var4.move(Direction.DOWN);
        }
        var4.move(Direction.UP);
        this.placeBaseHangOff(var2, var3, var5.setWithOffset((Vec3i)var4, Direction.NORTH));
        this.placeBaseHangOff(var2, var3, var5.setWithOffset((Vec3i)var4, Direction.SOUTH));
        this.placeBaseHangOff(var2, var3, var5.setWithOffset((Vec3i)var4, Direction.WEST));
        this.placeBaseHangOff(var2, var3, var5.setWithOffset((Vec3i)var4, Direction.EAST));
        var4.move(Direction.DOWN);
        BlockPos.MutableBlockPos var10 = new BlockPos.MutableBlockPos();
        for (int var11 = -3; var11 < 4; ++var11) {
            for (int var12 = -3; var12 < 4; ++var12) {
                int var13 = Mth.abs(var11) * Mth.abs(var12);
                if (var3.nextInt(10) >= 10 - var13) continue;
                var10.set(var4.offset(var11, 0, var12));
                int var14 = 3;
                while (var2.isEmptyBlock(var5.setWithOffset((Vec3i)var10, Direction.DOWN))) {
                    var10.move(Direction.DOWN);
                    if (--var14 > 0) continue;
                }
                if (var2.isEmptyBlock(var5.setWithOffset((Vec3i)var10, Direction.DOWN))) continue;
                var2.setBlock(var10, Blocks.BASALT.defaultBlockState(), 2);
            }
        }
        return true;
    }

    private void placeBaseHangOff(LevelAccessor var0, RandomSource var1, BlockPos var2) {
        if (var1.nextBoolean()) {
            var0.setBlock(var2, Blocks.BASALT.defaultBlockState(), 2);
        }
    }

    private boolean placeHangOff(LevelAccessor var0, RandomSource var1, BlockPos var2) {
        if (var1.nextInt(10) != 0) {
            var0.setBlock(var2, Blocks.BASALT.defaultBlockState(), 2);
            return true;
        }
        return false;
    }
}

