/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockPileConfiguration;

public class BlockPileFeature
extends Feature<BlockPileConfiguration> {
    public BlockPileFeature(Codec<BlockPileConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<BlockPileConfiguration> var0) {
        BlockPos var1 = var0.origin();
        WorldGenLevel var2 = var0.level();
        RandomSource var3 = var0.random();
        BlockPileConfiguration var4 = var0.config();
        if (var1.getY() < var2.getMinY() + 5) {
            return false;
        }
        int var5 = 2 + var3.nextInt(2);
        int var6 = 2 + var3.nextInt(2);
        for (BlockPos var8 : BlockPos.betweenClosed(var1.offset(-var5, 0, -var6), var1.offset(var5, 1, var6))) {
            int var10;
            int var9 = var1.getX() - var8.getX();
            if ((float)(var9 * var9 + (var10 = var1.getZ() - var8.getZ()) * var10) <= var3.nextFloat() * 10.0f - var3.nextFloat() * 6.0f) {
                this.tryPlaceBlock(var2, var8, var3, var4);
                continue;
            }
            if (!((double)var3.nextFloat() < 0.031)) continue;
            this.tryPlaceBlock(var2, var8, var3, var4);
        }
        return true;
    }

    private boolean mayPlaceOn(LevelAccessor var0, BlockPos var1, RandomSource var2) {
        BlockPos var3 = var1.below();
        BlockState var4 = var0.getBlockState(var3);
        if (var4.is(Blocks.DIRT_PATH)) {
            return var2.nextBoolean();
        }
        return var4.isFaceSturdy(var0, var3, Direction.UP);
    }

    private void tryPlaceBlock(LevelAccessor var0, BlockPos var1, RandomSource var2, BlockPileConfiguration var3) {
        if (var0.isEmptyBlock(var1) && this.mayPlaceOn(var0, var1, var2)) {
            var0.setBlock(var1, var3.stateProvider.getState(var2, var1), 260);
        }
    }
}

