/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BlueIceFeature
extends Feature<NoneFeatureConfiguration> {
    public BlueIceFeature(Codec<NoneFeatureConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> var0) {
        BlockPos var1 = var0.origin();
        WorldGenLevel var2 = var0.level();
        RandomSource var3 = var0.random();
        if (var1.getY() > var2.getSeaLevel() - 1) {
            return false;
        }
        if (!var2.getBlockState(var1).is(Blocks.WATER) && !var2.getBlockState(var1.below()).is(Blocks.WATER)) {
            return false;
        }
        boolean var4 = false;
        for (Direction direction : Direction.values()) {
            if (direction == Direction.DOWN || !var2.getBlockState(var1.relative(direction)).is(Blocks.PACKED_ICE)) continue;
            var4 = true;
            break;
        }
        if (!var4) {
            return false;
        }
        var2.setBlock(var1, Blocks.BLUE_ICE.defaultBlockState(), 2);
        block1: for (int var5 = 0; var5 < 200; ++var5) {
            BlockPos blockPos;
            BlockState var9;
            int var6 = var3.nextInt(5) - var3.nextInt(6);
            int var7 = 3;
            if (var6 < 2) {
                var7 += var6 / 2;
            }
            if (var7 < 1 || !(var9 = var2.getBlockState(blockPos = var1.offset(var3.nextInt(var7) - var3.nextInt(var7), var6, var3.nextInt(var7) - var3.nextInt(var7)))).isAir() && !var9.is(Blocks.WATER) && !var9.is(Blocks.PACKED_ICE) && !var9.is(Blocks.ICE)) continue;
            for (Direction var13 : Direction.values()) {
                BlockState var14 = var2.getBlockState(blockPos.relative(var13));
                if (!var14.is(Blocks.BLUE_ICE)) continue;
                var2.setBlock(blockPos, Blocks.BLUE_ICE.defaultBlockState(), 2);
                continue block1;
            }
        }
        return true;
    }
}

