/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.DiskConfiguration;

public class DiskFeature
extends Feature<DiskConfiguration> {
    public DiskFeature(Codec<DiskConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<DiskConfiguration> var0) {
        DiskConfiguration var1 = var0.config();
        BlockPos var2 = var0.origin();
        WorldGenLevel var3 = var0.level();
        RandomSource var4 = var0.random();
        boolean var5 = false;
        int var6 = var2.getY();
        int var7 = var6 + var1.halfHeight();
        int var8 = var6 - var1.halfHeight() - 1;
        int var9 = var1.radius().sample(var4);
        BlockPos.MutableBlockPos var10 = new BlockPos.MutableBlockPos();
        for (BlockPos var12 : BlockPos.betweenClosed(var2.offset(-var9, 0, -var9), var2.offset(var9, 0, var9))) {
            int var14;
            int var13 = var12.getX() - var2.getX();
            if (var13 * var13 + (var14 = var12.getZ() - var2.getZ()) * var14 > var9 * var9) continue;
            var5 |= this.placeColumn(var1, var3, var4, var7, var8, var10.set(var12));
        }
        return var5;
    }

    protected boolean placeColumn(DiskConfiguration var0, WorldGenLevel var1, RandomSource var2, int var3, int var4, BlockPos.MutableBlockPos var5) {
        boolean var6 = false;
        boolean var7 = false;
        for (int var8 = var3; var8 > var4; --var8) {
            var5.setY(var8);
            if (var0.target().test(var1, var5)) {
                BlockState var9 = var0.stateProvider().getState(var1, var2, var5);
                var1.setBlock(var5, var9, 2);
                if (!var7) {
                    this.markAboveForPostProcessing(var1, var5);
                }
                var6 = true;
                var7 = true;
                continue;
            }
            var7 = false;
        }
        return var6;
    }
}

