/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class EndPodiumFeature
extends Feature<NoneFeatureConfiguration> {
    public static final int PODIUM_RADIUS = 4;
    public static final int PODIUM_PILLAR_HEIGHT = 4;
    public static final int RIM_RADIUS = 1;
    public static final float CORNER_ROUNDING = 0.5f;
    private static final BlockPos END_PODIUM_LOCATION = BlockPos.ZERO;
    private final boolean active;

    public static BlockPos getLocation(BlockPos var0) {
        return END_PODIUM_LOCATION.offset(var0);
    }

    public EndPodiumFeature(boolean var0) {
        super(NoneFeatureConfiguration.CODEC);
        this.active = var0;
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> var0) {
        BlockPos var1 = var0.origin();
        WorldGenLevel var2 = var0.level();
        for (BlockPos var4 : BlockPos.betweenClosed(new BlockPos(var1.getX() - 4, var1.getY() - 1, var1.getZ() - 4), new BlockPos(var1.getX() + 4, var1.getY() + 32, var1.getZ() + 4))) {
            boolean var5 = var4.closerThan(var1, 2.5);
            if (!var5 && !var4.closerThan(var1, 3.5)) continue;
            if (var4.getY() < var1.getY()) {
                if (var5) {
                    this.setBlock(var2, var4, Blocks.BEDROCK.defaultBlockState());
                    continue;
                }
                if (var4.getY() >= var1.getY()) continue;
                if (this.active) {
                    this.dropPreviousAndSetBlock(var2, var4, Blocks.END_STONE);
                    continue;
                }
                this.setBlock(var2, var4, Blocks.END_STONE.defaultBlockState());
                continue;
            }
            if (var4.getY() > var1.getY()) {
                if (this.active) {
                    this.dropPreviousAndSetBlock(var2, var4, Blocks.AIR);
                    continue;
                }
                this.setBlock(var2, var4, Blocks.AIR.defaultBlockState());
                continue;
            }
            if (!var5) {
                this.setBlock(var2, var4, Blocks.BEDROCK.defaultBlockState());
                continue;
            }
            if (this.active) {
                this.dropPreviousAndSetBlock(var2, new BlockPos(var4), Blocks.END_PORTAL);
                continue;
            }
            this.setBlock(var2, new BlockPos(var4), Blocks.AIR.defaultBlockState());
        }
        for (int var3 = 0; var3 < 4; ++var3) {
            this.setBlock(var2, var1.above(var3), Blocks.BEDROCK.defaultBlockState());
        }
        BlockPos var3 = var1.above(2);
        for (Direction var5 : Direction.Plane.HORIZONTAL) {
            this.setBlock(var2, var3.relative(var5), (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue(WallTorchBlock.FACING, var5));
        }
        return true;
    }

    private void dropPreviousAndSetBlock(WorldGenLevel var0, BlockPos var1, Block var2) {
        if (!var0.getBlockState(var1).is(var2)) {
            var0.destroyBlock(var1, true, null);
            this.setBlock(var0, var1, var2.defaultBlockState());
        }
    }
}

