/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ProbabilityFeatureConfiguration;

public class SeagrassFeature
extends Feature<ProbabilityFeatureConfiguration> {
    public SeagrassFeature(Codec<ProbabilityFeatureConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<ProbabilityFeatureConfiguration> var0) {
        boolean var1 = false;
        RandomSource var2 = var0.random();
        WorldGenLevel var3 = var0.level();
        BlockPos var4 = var0.origin();
        ProbabilityFeatureConfiguration var5 = var0.config();
        int var6 = var2.nextInt(8) - var2.nextInt(8);
        int var7 = var2.nextInt(8) - var2.nextInt(8);
        int var8 = var3.getHeight(Heightmap.Types.OCEAN_FLOOR, var4.getX() + var6, var4.getZ() + var7);
        BlockPos var9 = new BlockPos(var4.getX() + var6, var8, var4.getZ() + var7);
        if (var3.getBlockState(var9).is(Blocks.WATER)) {
            BlockState var11;
            boolean var10 = var2.nextDouble() < (double)var5.probability;
            BlockState blockState = var11 = var10 ? Blocks.TALL_SEAGRASS.defaultBlockState() : Blocks.SEAGRASS.defaultBlockState();
            if (var11.canSurvive(var3, var9)) {
                if (var10) {
                    BlockState var12 = (BlockState)var11.setValue(TallSeagrassBlock.HALF, DoubleBlockHalf.UPPER);
                    BlockPos var13 = var9.above();
                    if (var3.getBlockState(var13).is(Blocks.WATER)) {
                        var3.setBlock(var9, var11, 2);
                        var3.setBlock(var13, var12, 2);
                    }
                } else {
                    var3.setBlock(var9, var11, 2);
                }
                var1 = true;
            }
        }
        return var1;
    }
}

