/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class VoidStartPlatformFeature
extends Feature<NoneFeatureConfiguration> {
    private static final BlockPos PLATFORM_OFFSET = new BlockPos(8, 3, 8);
    private static final ChunkPos PLATFORM_ORIGIN_CHUNK = new ChunkPos(PLATFORM_OFFSET);
    private static final int PLATFORM_RADIUS = 16;
    private static final int PLATFORM_RADIUS_CHUNKS = 1;

    public VoidStartPlatformFeature(Codec<NoneFeatureConfiguration> var0) {
        super(var0);
    }

    private static int checkerboardDistance(int var0, int var1, int var2, int var3) {
        return Math.max(Math.abs(var0 - var2), Math.abs(var1 - var3));
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> var0) {
        WorldGenLevel var1 = var0.level();
        ChunkPos var2 = new ChunkPos(var0.origin());
        if (VoidStartPlatformFeature.checkerboardDistance(var2.x, var2.z, VoidStartPlatformFeature.PLATFORM_ORIGIN_CHUNK.x, VoidStartPlatformFeature.PLATFORM_ORIGIN_CHUNK.z) > 1) {
            return true;
        }
        BlockPos var3 = PLATFORM_OFFSET.atY(var0.origin().getY() + PLATFORM_OFFSET.getY());
        BlockPos.MutableBlockPos var4 = new BlockPos.MutableBlockPos();
        for (int var5 = var2.getMinBlockZ(); var5 <= var2.getMaxBlockZ(); ++var5) {
            for (int var6 = var2.getMinBlockX(); var6 <= var2.getMaxBlockX(); ++var6) {
                if (VoidStartPlatformFeature.checkerboardDistance(var3.getX(), var3.getZ(), var6, var5) > 16) continue;
                var4.set(var6, var3.getY(), var5);
                if (var4.equals(var3)) {
                    var1.setBlock(var4, Blocks.COBBLESTONE.defaultBlockState(), 2);
                    continue;
                }
                var1.setBlock(var4, Blocks.STONE.defaultBlockState(), 2);
            }
        }
        return true;
    }
}

