/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class MegaPineFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<MegaPineFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(var02 -> MegaPineFoliagePlacer.foliagePlacerParts(var02).and((App)IntProvider.codec(0, 24).fieldOf("crown_height").forGetter(var0 -> var0.crownHeight)).apply((Applicative)var02, MegaPineFoliagePlacer::new));
    private final IntProvider crownHeight;

    public MegaPineFoliagePlacer(IntProvider var0, IntProvider var1, IntProvider var2) {
        super(var0, var1);
        this.crownHeight = var2;
    }

    @Override
    protected FoliagePlacerType<?> type() {
        return FoliagePlacerType.MEGA_PINE_FOLIAGE_PLACER;
    }

    @Override
    protected void createFoliage(LevelSimulatedReader var0, FoliagePlacer.FoliageSetter var1, RandomSource var2, TreeConfiguration var3, int var4, FoliagePlacer.FoliageAttachment var5, int var6, int var7, int var8) {
        BlockPos var9 = var5.pos();
        int var10 = 0;
        for (int var11 = var9.getY() - var6 + var8; var11 <= var9.getY() + var8; ++var11) {
            int var12 = var9.getY() - var11;
            int var13 = var7 + var5.radiusOffset() + Mth.floor((float)var12 / (float)var6 * 3.5f);
            int var14 = var12 > 0 && var13 == var10 && (var11 & 1) == 0 ? var13 + 1 : var13;
            this.placeLeavesRow(var0, var1, var2, var3, new BlockPos(var9.getX(), var11, var9.getZ()), var14, 0, var5.doubleTrunk());
            var10 = var13;
        }
    }

    @Override
    public int foliageHeight(RandomSource var0, int var1, TreeConfiguration var2) {
        return this.crownHeight.sample(var0);
    }

    @Override
    protected boolean shouldSkipLocation(RandomSource var0, int var1, int var2, int var3, int var4, boolean var5) {
        if (var1 + var3 >= 7) {
            return true;
        }
        return var1 * var1 + var3 * var3 > var4 * var4;
    }
}

