/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class AlterGroundDecorator
extends TreeDecorator {
    public static final MapCodec<AlterGroundDecorator> CODEC = BlockStateProvider.CODEC.fieldOf("provider").xmap(AlterGroundDecorator::new, var0 -> var0.provider);
    private final BlockStateProvider provider;

    public AlterGroundDecorator(BlockStateProvider var0) {
        this.provider = var0;
    }

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.ALTER_GROUND;
    }

    @Override
    public void place(TreeDecorator.Context var0) {
        List<BlockPos> var12 = TreeFeature.getLowestTrunkOrRootOfTree(var0);
        if (var12.isEmpty()) {
            return;
        }
        int var2 = var12.get(0).getY();
        var12.stream().filter(var1 -> var1.getY() == var2).forEach(var1 -> {
            this.placeCircle(var0, var1.west().north());
            this.placeCircle(var0, var1.east(2).north());
            this.placeCircle(var0, var1.west().south(2));
            this.placeCircle(var0, var1.east(2).south(2));
            for (int var2 = 0; var2 < 5; ++var2) {
                int var3 = var0.random().nextInt(64);
                int var4 = var3 % 8;
                int var5 = var3 / 8;
                if (var4 != 0 && var4 != 7 && var5 != 0 && var5 != 7) continue;
                this.placeCircle(var0, var1.offset(-3 + var4, 0, -3 + var5));
            }
        });
    }

    private void placeCircle(TreeDecorator.Context var0, BlockPos var1) {
        for (int var2 = -2; var2 <= 2; ++var2) {
            for (int var3 = -2; var3 <= 2; ++var3) {
                if (Math.abs(var2) == 2 && Math.abs(var3) == 2) continue;
                this.placeBlockAt(var0, var1.offset(var2, 0, var3));
            }
        }
    }

    private void placeBlockAt(TreeDecorator.Context var0, BlockPos var1) {
        for (int var2 = 2; var2 >= -3; --var2) {
            BlockPos var3 = var1.above(var2);
            if (Feature.isGrassOrDirt(var0.level(), var3)) {
                var0.setBlock(var3, this.provider.getState(var0.random(), var1));
                break;
            }
            if (!var0.isAir(var3) && var2 < 0) break;
        }
    }
}

